/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.impl;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.IModuleOption;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.impl.SimpleElementFactory;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;
import org.eclipse.birt.report.model.api.metadata.IMetaLogger;
import org.eclipse.birt.report.model.api.metadata.MetaDataReaderException;
import org.eclipse.birt.report.model.api.simpleapi.IReportDesign;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetaDataReader;
import org.eclipse.birt.report.model.metadata.MetaLogManager;
import org.eclipse.birt.report.model.simpleapi.ReportDesign;

public class DesignEngineImpl
implements IDesignEngine {
    private static final String ROM_DEF_FILE_NAME = "rom.def";
    private static Boolean isInitialized = Boolean.FALSE;
    private DesignConfig designConfig;

    public DesignEngineImpl(DesignConfig config) {
        this.designConfig = config;
    }

    private static void initialize(InputStream is) throws MetaDataReaderException {
        try {
            if (!isInitialized.booleanValue()) {
                MetaDataReader.read(is);
            }
            if (!MetaDataDictionary.getInstance().isIntializedExtension()) {
                MetaDataDictionary.intializeExtension();
            }
            if (!isInitialized.booleanValue()) {
                org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory.setInstance(new SimpleElementFactory());
            }
        }
        catch (MetaDataParserException e) {
            throw new MetaDataReaderException("Error.MetaDataReaderException.META_DATA_ERROR", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionHandle newSessionHandle(ULocale locale) {
        if (isInitialized.booleanValue() && MetaDataDictionary.getInstance().isIntializedExtension()) {
            return new SessionHandle(locale);
        }
        Class<DesignEngineImpl> clazz = DesignEngineImpl.class;
        synchronized (DesignEngineImpl.class) {
            IResourceLocator locator;
            block12: {
                if (isInitialized.booleanValue() && MetaDataDictionary.getInstance().isIntializedExtension()) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return new SessionHandle(locale);
                }
                if (!isInitialized.booleanValue()) {
                    MetaDataDictionary.reset();
                }
                try {
                    try {
                        DesignEngineImpl.initialize(org.eclipse.birt.report.model.elements.ReportDesign.class.getResourceAsStream(ROM_DEF_FILE_NAME));
                    }
                    catch (MetaDataReaderException metaDataReaderException) {
                        MetaLogManager.shutDown();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    MetaLogManager.shutDown();
                    throw throwable;
                }
                MetaLogManager.shutDown();
            }
            isInitialized = Boolean.TRUE;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            SessionHandle session = new SessionHandle(locale);
            if (this.designConfig != null && (locator = this.designConfig.getResourceLocator()) != null) {
                session.setResourceLocator(locator);
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMetaDataDictionary getMetaData() {
        if (isInitialized.booleanValue() && MetaDataDictionary.getInstance().isIntializedExtension()) {
            return MetaDataDictionary.getInstance();
        }
        Class<DesignEngineImpl> clazz = DesignEngineImpl.class;
        synchronized (DesignEngineImpl.class) {
            block11: {
                if (isInitialized.booleanValue() && MetaDataDictionary.getInstance().isIntializedExtension()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return MetaDataDictionary.getInstance();
                }
                if (!isInitialized.booleanValue()) {
                    MetaDataDictionary.reset();
                }
                try {
                    try {
                        DesignEngineImpl.initialize(org.eclipse.birt.report.model.elements.ReportDesign.class.getResourceAsStream(ROM_DEF_FILE_NAME));
                    }
                    catch (MetaDataReaderException metaDataReaderException) {
                        MetaLogManager.shutDown();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    MetaLogManager.shutDown();
                    throw throwable;
                }
                MetaLogManager.shutDown();
            }
            isInitialized = Boolean.TRUE;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MetaDataDictionary.getInstance();
        }
    }

    public void registerMetaLogger(IMetaLogger newLogger) {
        MetaLogManager.registerLogger(newLogger);
    }

    public boolean removeMetaLogger(IMetaLogger logger) {
        return MetaLogManager.removeLogger(logger);
    }

    public IReportDesign openDesign(String fileName, InputStream ins, IModuleOption options) throws DesignFileException {
        SessionHandle tmpSession = this.newSessionHandle(null);
        return new ReportDesign(tmpSession.openDesign(fileName, ins, (ModuleOption)options));
    }
}

