/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.eclipse.birt.chart.script.ScriptClassLoaderAdapter;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.IReportEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BIRTScriptClassLoader
extends ScriptClassLoaderAdapter {
    private ClassLoader classLoader;

    public BIRTScriptClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Class<?> loadClass(String className, ClassLoader parentLoader) throws ClassNotFoundException {
        ClassNotFoundException ex;
        Class<?> c;
        block8: {
            if (className == null) {
                return null;
            }
            c = null;
            ex = null;
            if (this.classLoader != null) {
                try {
                    c = SecurityUtil.loadClass(this.classLoader, className);
                    if (c != null) {
                        return c;
                    }
                }
                catch (Throwable throwable) {}
            }
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                ex = e;
                c = BIRTScriptClassLoader.getClassUsingCustomClassPath(className, "webapplication.projectclasspath", parentLoader);
                if (c != null || (c = BIRTScriptClassLoader.getClassUsingCustomClassPath(className, "user.projectclasspath", parentLoader)) != null) break block8;
                c = BIRTScriptClassLoader.getClassUsingCustomClassPath(className, "workspace.projectclasspath", parentLoader);
            }
        }
        if (c == null) {
            throw ex;
        }
        return c;
    }

    private static Class<?> getClassUsingCustomClassPath(final String className, final String classPathKey, final ClassLoader parentLoader) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                String classPath = System.getProperty(classPathKey);
                if (classPath == null || classPath.length() == 0 || className == null) {
                    return null;
                }
                String[] classPathArray = classPath.split(EngineConstants.PROPERTYSEPARATOR, -1);
                URL[] urls = null;
                if (classPathArray.length != 0) {
                    ArrayList<URL> l = new ArrayList<URL>();
                    int i = 0;
                    while (i < classPathArray.length) {
                        String cpValue = classPathArray[i];
                        File file = new File(cpValue);
                        try {
                            l.add(file.toURL());
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    urls = l.toArray(new URL[l.size()]);
                }
                if (urls != null) {
                    DoubleParentClassLoader cmLoader = new DoubleParentClassLoader(parentLoader, IReportEngine.class.getClassLoader());
                    URLClassLoader cl = new URLClassLoader(urls, (ClassLoader)cmLoader);
                    try {
                        return cl.loadClass(className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                return null;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DoubleParentClassLoader
    extends ClassLoader {
        private final ClassLoader cldParent2;

        private DoubleParentClassLoader(ClassLoader parent1, ClassLoader parent2) {
            super(parent1);
            this.cldParent2 = parent2;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return SecurityUtil.loadClass(this.cldParent2, name);
        }
    }
}

