/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.jar;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.core.framework.PlatformLauncher;
import org.eclipse.birt.core.framework.jar.ServicePlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.spi.IRegistryProvider;

public class ServiceLauncher
extends PlatformLauncher {
    static final String MANIFEST_ENTRY = "META-INF/MANIFEST.MF";
    static Logger logger = Logger.getLogger(Platform.class.getName());
    private ServicePlatform platform;

    public void startup(PlatformConfig config) throws FrameworkException {
        this.platform = new ServicePlatform(config);
        try {
            Enumeration<URL> plugins = ServiceLauncher.class.getClassLoader().getResources(MANIFEST_ENTRY);
            while (plugins.hasMoreElements()) {
                URL root = null;
                URL url = plugins.nextElement();
                String path = url.toExternalForm();
                if (path.endsWith(MANIFEST_ENTRY)) {
                    String rootPath = path.substring(0, path.length() - MANIFEST_ENTRY.length());
                    root = new URL(url, rootPath);
                } else {
                    root = new URL(url, "..");
                }
                try {
                    this.platform.installBundle(root);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Failed to install plugin from " + root, ex);
                }
            }
            this.platform.startup();
            Platform.setPlatform(this.platform);
            RegistryFactory.setDefaultRegistryProvider((IRegistryProvider)new IRegistryProvider(){

                public IExtensionRegistry getRegistry() {
                    return ((ServiceLauncher)ServiceLauncher.this).platform.extensionRegistry;
                }
            });
        }
        catch (IOException ex) {
            throw new FrameworkException("Can't find any bundle from the classpath", ex);
        }
        catch (CoreException ex) {
            throw new FrameworkException("Can't register the ExtensionRegistry classpath", ex);
        }
    }

    public void shutdown() {
        Platform.setPlatform(null);
        if (this.platform != null) {
            this.platform.shutdown();
            this.platform = null;
        }
    }
}

