/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.FilterUtil;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.SortingOptimizer;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

public final class QueryExecutionStrategyUtil {
    public static Strategy getQueryExecutionStrategy(DataEngineSession session, IQueryDefinition query, IBaseDataSetDesign dataSet) throws DataException {
        IBaseExpression baseExpr;
        SortingOptimizer opt = new SortingOptimizer(dataSet, query);
        if (session.getEngineContext().getMode() == 4) {
            return Strategy.Complex;
        }
        if (query.getGroups() != null && query.getGroups().size() > 0) {
            for (IGroupDefinition group : query.getGroups()) {
                if (group.getSubqueries() != null && group.getSubqueries().size() > 0) {
                    return Strategy.Complex;
                }
                if (!QueryExecutionStrategyUtil.isDirectColumnRefGroupKey(group, query)) {
                    return Strategy.Complex;
                }
                if (group.getFilters().isEmpty() && group.getSorts().isEmpty() && !query.getQueryExecutionHints().doSortBeforeGrouping() || opt.acceptGroupSorting()) continue;
                return Strategy.Complex;
            }
        }
        if (query.getFilters() != null && query.getFilters().size() > 0) {
            if (FilterUtil.hasMutipassFilters(query.getFilters())) {
                return Strategy.Complex;
            }
            HashSet<String> bindings = new HashSet<String>();
            for (Object filter : query.getFilters()) {
                baseExpr = ((IFilterDefinition)filter).getExpression();
                if (ExpressionCompilerUtil.hasAggregationInExpr(baseExpr)) {
                    return Strategy.Complex;
                }
                bindings.addAll(ExpressionCompilerUtil.extractColumnExpression(baseExpr, "row"));
                if (((IFilterDefinition)filter).updateAggregation()) continue;
                return Strategy.Complex;
            }
            if (PreparedQueryUtil.existAggregationBinding(bindings, query.getBindings())) {
                return Strategy.Complex;
            }
        }
        if (query.getSorts() != null && query.getSorts().size() > 0 && !opt.acceptQuerySorting()) {
            return Strategy.Complex;
        }
        if (query.getSubqueries() != null && query.getSubqueries().size() > 0) {
            return Strategy.Complex;
        }
        if (!query.usesDetails()) {
            return Strategy.Complex;
        }
        boolean hasAggregation = false;
        if (query.getBindings() != null) {
            for (Object binding : query.getBindings().values()) {
                if (binding.getAggrFunction() != null) {
                    hasAggregation = true;
                    IAggrFunction aggr = AggregationManager.getInstance().getAggregation(binding.getAggrFunction());
                    if (aggr != null && aggr.getNumberOfPasses() > 1) {
                        return Strategy.Complex;
                    }
                    ArrayList<IBaseExpression> exprs = new ArrayList<IBaseExpression>();
                    exprs.addAll(binding.getArguments());
                    if (binding.getExpression() != null) {
                        exprs.add(binding.getExpression());
                    }
                    int i = 0;
                    while (i < exprs.size()) {
                        Object expr = exprs.get(i);
                        if (!(expr instanceof IScriptExpression)) {
                            return Strategy.Complex;
                        }
                        IScriptExpression scriptExpr = (IScriptExpression)expr;
                        try {
                            List columnExprs = ExpressionUtil.extractColumnExpressions(scriptExpr.getText());
                            for (IColumnBinding temp : columnExprs) {
                                Object obj = query.getBindings().get(temp.getResultSetColumnName());
                                if (!(obj instanceof IBinding)) continue;
                                IBinding bindingObj = (IBinding)obj;
                                if (bindingObj.getAggrFunction() != null) {
                                    return Strategy.Complex;
                                }
                                IBaseExpression baseExpr2 = ((IBinding)obj).getExpression();
                                if (!(baseExpr2 instanceof IScriptExpression)) continue;
                                String cb = ExpressionUtil.getColumnName(((IScriptExpression)baseExpr2).getText());
                                if (ScriptEvalUtil.compare(bindingObj.getBindingName(), cb) == 0) continue;
                                return Strategy.Complex;
                            }
                        }
                        catch (BirtException birtException) {
                            return Strategy.Complex;
                        }
                        ++i;
                    }
                }
                if (!ExpressionCompilerUtil.hasAggregationInExpr(binding.getExpression())) continue;
                return Strategy.Complex;
            }
        }
        if (dataSet != null) {
            if (dataSet.getFilters() != null) {
                if (FilterUtil.hasMutipassFilters(dataSet.getFilters())) {
                    return Strategy.Complex;
                }
                for (Object filter : dataSet.getFilters()) {
                    baseExpr = ((IFilterDefinition)filter).getExpression();
                    if (ExpressionCompilerUtil.hasAggregationInExpr(baseExpr)) {
                        return Strategy.Complex;
                    }
                    if (((IFilterDefinition)filter).updateAggregation()) continue;
                    return Strategy.Complex;
                }
            }
            if (dataSet.needDistinctValue()) {
                return Strategy.Complex;
            }
            if (dataSet.getComputedColumns() != null) {
                List computedColumns = dataSet.getComputedColumns();
                int i = 0;
                while (i < computedColumns.size()) {
                    IComputedColumn computedColumn = (IComputedColumn)computedColumns.get(i);
                    if (computedColumn.getAggregateFunction() != null) {
                        return Strategy.Complex;
                    }
                    if (computedColumn.getExpression() instanceof IScriptExpression && ExpressionUtil.hasAggregation(((IScriptExpression)computedColumn.getExpression()).getText())) {
                        return Strategy.Complex;
                    }
                    ++i;
                }
            }
        }
        return hasAggregation ? Strategy.SimpleLookingFoward : Strategy.SimpleNoLookingFoward;
    }

    private static boolean isDirectColumnRefGroupKey(IGroupDefinition group, IQueryDefinition query) {
        String dataSetExpr;
        String expr = QueryExecutionStrategyUtil.getGroupKeyExpression(group);
        try {
            dataSetExpr = QueryExecutionStrategyUtil.getDataSetExpr(expr, query);
        }
        catch (DataException dataException) {
            dataSetExpr = null;
        }
        try {
            return dataSetExpr == null || ExpressionUtil.getColumnName(dataSetExpr) != null || ExpressionUtil.getColumnBindingName(dataSetExpr) != null;
        }
        catch (BirtException birtException) {
            return false;
        }
    }

    private static String getGroupKeyExpression(IGroupDefinition src) {
        String expr = src.getKeyColumn();
        expr = expr == null ? src.getKeyExpression() : QueryExecutionStrategyUtil.getColumnRefExpression(expr);
        return expr;
    }

    private static String getColumnRefExpression(String expr) {
        return ExpressionUtil.createJSRowExpression(expr);
    }

    private static String getDataSetExpr(String rowExpr, IQueryDefinition query) throws DataException {
        String dataSetExpr = null;
        try {
            IBaseExpression expr;
            String bindingName = ExpressionUtil.getColumnBindingName(rowExpr);
            Object binding = query.getBindings().get(bindingName);
            if (binding != null && (expr = ((IBinding)binding).getExpression()) != null && expr instanceof IScriptExpression) {
                dataSetExpr = ((IScriptExpression)expr).getText();
            }
            return dataSetExpr;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        SimpleLookingFoward,
        SimpleNoLookingFoward,
        Complex;

    }
}

