/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.disk.IRowIterator;
import org.eclipse.birt.data.engine.executor.cache.disk.MergeSortUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;

class MergeSortRowFiles
implements IRowIterator {
    private IRowIterator[] subRowIterators = null;
    private MergeSortUtil mergeSortUtil = null;
    private ValueIndex[] rowBuffer = null;
    private ValueIndex mValueIndex = null;
    private int rowBufferSize = 0;

    MergeSortRowFiles(IRowIterator[] subRowIterators, MergeSortUtil mergeSortUtil) {
        assert (subRowIterators != null);
        this.subRowIterators = subRowIterators;
        this.mergeSortUtil = mergeSortUtil;
        this.mValueIndex = new ValueIndex(null, 0, mergeSortUtil.getComparator());
    }

    public void reset() throws DataException {
        int i = 0;
        while (i < this.subRowIterators.length) {
            this.subRowIterators[i].reset();
            ++i;
        }
        this.rowBuffer = null;
    }

    public IResultObject fetch() throws IOException, DataException {
        if (this.rowBuffer == null) {
            this.prepareFirstFetch();
        }
        if (this.rowBufferSize == 0) {
            return null;
        }
        ValueIndex reObj = this.rowBuffer[0];
        IResultObject value = reObj.value;
        IResultObject readValue = this.subRowIterators[reObj.index].fetch();
        if (readValue == null) {
            --this.rowBufferSize;
            if (this.rowBufferSize > 0) {
                ValueIndex[] tBuffer = new ValueIndex[this.rowBufferSize];
                System.arraycopy(this.rowBuffer, 1, tBuffer, 0, this.rowBufferSize);
                this.rowBuffer = tBuffer;
            }
        } else {
            int pos = 0;
            this.mValueIndex.value = readValue;
            this.mValueIndex.index = reObj.index;
            if (this.rowBufferSize > 1) {
                pos = Arrays.binarySearch(this.rowBuffer, this.mValueIndex);
                if (pos < 0) {
                    pos = (pos + 1) * -1;
                }
                if (--pos == -1) {
                    pos = 0;
                }
                if (pos > 0) {
                    System.arraycopy(this.rowBuffer, 1, this.rowBuffer, 0, pos);
                }
            }
            this.rowBuffer[pos] = this.mValueIndex;
            this.mValueIndex = reObj;
        }
        return value;
    }

    private void prepareFirstFetch() throws IOException, DataException {
        this.rowBuffer = new ValueIndex[this.subRowIterators.length];
        int i = 0;
        while (i < this.rowBuffer.length) {
            IResultObject value = this.subRowIterators[i].fetch();
            if (value != null) {
                this.rowBuffer[i] = new ValueIndex(value, i, this.mergeSortUtil.getComparator());
            }
            ++i;
        }
        this.rowBufferSize = 0;
        i = 0;
        while (i < this.rowBuffer.length) {
            if (this.rowBuffer[i] != null) {
                this.rowBuffer[this.rowBufferSize] = this.rowBuffer[i];
                ++this.rowBufferSize;
            }
            ++i;
        }
        Arrays.sort(this.rowBuffer, 0, this.rowBufferSize);
    }

    public void close() throws DataException {
        int i = 0;
        while (i < this.subRowIterators.length) {
            this.subRowIterators[i].close();
            ++i;
        }
        this.subRowIterators = null;
    }

    static class ValueIndex
    implements Comparable {
        IResultObject value;
        int index;
        private Comparator comparator;

        ValueIndex(IResultObject value, int index, Comparator comparator) {
            this.value = value;
            this.index = index;
            this.comparator = comparator;
        }

        public int compareTo(Object o) {
            ValueIndex other = (ValueIndex)o;
            int result = this.comparator.compare(this.value, other.value);
            if (result == 0) {
                if (this.index > other.index) {
                    return 1;
                }
                if (this.index == other.index) {
                    return 0;
                }
                return -1;
            }
            return result;
        }
    }
}

