/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.impl.NamingRelationUtil;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.ResultSetCacheUtil;
import org.eclipse.birt.data.engine.impl.document.IRDSave;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.impl.document.stream.VersionManager;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.script.JSDummyRowObject;
import org.mozilla.javascript.Scriptable;

public class PreparedDummyQuery
implements IPreparedQuery {
    private ExprManager exprManager;
    private DataEngineSession session;
    private IQueryDefinition queryDefn;
    private ISubqueryDefinition subQueryDefn;
    private String subQueryName;
    private int subQueryIndex;
    private Map subQueryMap;
    private static Logger logger = Logger.getLogger(PreparedDummyQuery.class.getName());

    PreparedDummyQuery(IQueryDefinition queryDefn, DataEngineSession session) {
        Object[] params = new Object[]{queryDefn, session};
        logger.entering(PreparedDummyQuery.class.getName(), "PreparedDummyQuery", params);
        this.queryDefn = queryDefn;
        this.session = session;
        this.init(session.getEngineContext(), queryDefn, session.getSharedScope());
        logger.exiting(PreparedDummyQuery.class.getName(), "PreparedDummyQuery");
    }

    PreparedDummyQuery(ISubqueryDefinition subQueryDefn, DataEngineSession session) {
        Object[] params = new Object[]{subQueryDefn, session};
        logger.entering(PreparedDummyQuery.class.getName(), "PreparedDummyQuery", params);
        this.subQueryDefn = subQueryDefn;
        this.session = session;
        this.init(session.getEngineContext(), subQueryDefn, session.getSharedScope());
        logger.exiting(PreparedDummyQuery.class.getName(), "PreparedDummyQuery");
    }

    void init(DataEngineContext context, IBaseQueryDefinition queryDefn, Scriptable sharedScope) {
        assert (queryDefn != null);
        this.exprManager = new ExprManager(queryDefn, this.session.getEngineContext().getScriptContext());
        this.exprManager.addBindingExpr(null, queryDefn.getBindings(), 0);
    }

    public IQueryDefinition getReportQueryDefn() {
        return this.queryDefn;
    }

    public Collection getParameterMetaData() throws BirtException {
        return null;
    }

    public IQueryResults execute(Scriptable queryScope) throws BirtException {
        return this.execute(null, queryScope);
    }

    public IQueryResults execute(IQueryResults outerResults, Scriptable queryScope) throws BirtException {
        return this.executeQuery(queryScope, null);
    }

    IQueryResults executeQuery(Scriptable queryScope, Scriptable parentScope) throws BirtException {
        this.processSubQuery();
        return new QueryResults(this, this.exprManager, this.getScope(queryScope), parentScope);
    }

    private void processSubQuery() {
        IBaseQueryDefinition queryDefn2 = null;
        queryDefn2 = this.queryDefn != null ? this.queryDefn : this.subQueryDefn;
        this.subQueryMap = new HashMap();
        this.registerSubQuery(queryDefn2);
    }

    private void registerSubQuery(IBaseQueryDefinition queryDefn2) {
        List groupList;
        Collection subQueryDefns = queryDefn2.getSubqueries();
        if (subQueryDefns != null) {
            for (ISubqueryDefinition subQueryDefn : subQueryDefns) {
                this.subQueryMap.put(subQueryDefn.getName(), subQueryDefn);
                this.registerSubQuery(subQueryDefn);
            }
        }
        if ((groupList = queryDefn2.getGroups()) != null) {
            int i = 0;
            while (i < groupList.size()) {
                GroupDefinition groupDefn = (GroupDefinition)groupList.get(i);
                Collection subQueryDefnsOnGroup = groupDefn.getSubqueries();
                if (subQueryDefnsOnGroup != null) {
                    for (ISubqueryDefinition subQueryDefn : subQueryDefnsOnGroup) {
                        this.subQueryMap.put(subQueryDefn.getName(), subQueryDefn);
                        this.registerSubQuery(subQueryDefn);
                    }
                }
                ++i;
            }
        }
    }

    private Scriptable getScope(Scriptable queryScope) throws BirtException {
        Scriptable topScope = null;
        topScope = queryScope != null ? queryScope : this.session.getSharedScope();
        Scriptable executionScope = null;
        executionScope = ((IDataScriptEngine)((Object)this.session.getEngineContext().getScriptContext().getScriptEngine("javascript"))).getJSContext(this.session.getEngineContext().getScriptContext()).newObject(topScope);
        executionScope.setParentScope(topScope);
        executionScope.setPrototype(this.session.getSharedScope());
        return executionScope;
    }

    private IResultIterator execSubQuery(String parentQueryResultID, String name, Scriptable scope, Scriptable parentScope) throws BirtException {
        Object ob = this.subQueryMap.get(name);
        if (ob == null) {
            return null;
        }
        PreparedQueryUtil.mappingParentColumnBinding((ISubqueryDefinition)ob);
        PreparedDummyQuery preparedQuery = new PreparedDummyQuery((ISubqueryDefinition)ob, this.session);
        preparedQuery.subQueryName = name;
        preparedQuery.subQueryIndex = 0;
        QueryResults queryResults = (QueryResults)preparedQuery.executeQuery(scope, parentScope);
        queryResults.setID(parentQueryResultID);
        return queryResults.getResultIterator();
    }

    public IQueryResults execute(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        try {
            return this.executeQuery(scope, null);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private static class DummyCachedResult
    extends CachedResultSet {
        private DummyCachedResult() {
        }

        public void doSave(StreamWrapper streamWrapper, boolean isSubQuery) throws DataException {
            try {
                if (streamWrapper.getStreamForResultClass() != null) {
                    IOUtil.writeInt(streamWrapper.getStreamForResultClass(), 0);
                    streamWrapper.getStreamForResultClass().close();
                    if (streamWrapper.getStreamForDataSet() != null) {
                        IOUtil.writeInt(streamWrapper.getStreamForDataSet(), 0);
                        streamWrapper.getStreamForDataSet().close();
                    }
                    if (streamWrapper.getStreamForDataSetRowLens() != null) {
                        IOUtil.writeLong(streamWrapper.getStreamForDataSetRowLens(), 0L);
                        streamWrapper.getStreamForDataSetRowLens().close();
                    }
                }
                IOUtil.writeInt(streamWrapper.getStreamForGroupInfo(), 0);
            }
            catch (IOException e) {
                throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, (Object)"Result Class");
            }
        }

        public int getRowCount() throws DataException {
            return 1;
        }
    }

    private class QueryResults
    implements IQueryResults,
    IQueryService {
        private PreparedDummyQuery preparedQuery;
        private ExprManager exprManager;
        private Scriptable queryScope;
        private Scriptable parentScope;
        private ResultIterator resultIterator;
        private String queryResultID;
        private boolean isClosed;
        private String name;

        private QueryResults(PreparedDummyQuery preparedQuery, ExprManager exprManager, Scriptable queryScope, Scriptable parentScope) {
            this.preparedQuery = preparedQuery;
            this.exprManager = exprManager;
            this.queryScope = queryScope;
            this.parentScope = parentScope;
            this.isClosed = false;
        }

        public String getID() {
            if (this.queryResultID == null) {
                this.queryResultID = PreparedDummyQuery.this.session.getQueryResultIDUtil().nextID();
            }
            return this.queryResultID;
        }

        private void setID(String queryResultID) {
            this.queryResultID = queryResultID;
        }

        public IPreparedQuery getPreparedQuery() {
            return this.preparedQuery;
        }

        public IResultMetaData getResultMetaData() throws BirtException {
            return null;
        }

        public IResultIterator getResultIterator() throws BirtException {
            if (this.resultIterator == null) {
                this.exprManager.validateColumnBinding();
                this.resultIterator = new ResultIterator(this, this.exprManager, this.queryScope, this.parentScope);
            }
            return this.resultIterator;
        }

        public void close() throws BirtException {
            this.isClosed = true;
            NamingRelationUtil.merge(PreparedDummyQuery.this.session, this.preparedQuery.getReportQueryDefn(), this);
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public int getNestedLevel() {
            return 0;
        }

        public Scriptable getQueryScope() {
            return this.queryScope;
        }

        public IExecutorHelper getExecutorHelper() throws DataException {
            return new IExecutorHelper(){

                public IExecutorHelper getParent() {
                    return null;
                }

                public Scriptable getScriptable() {
                    return QueryResults.this.resultIterator.getJSDummyRowObject();
                }
            };
        }

        public DataSetRuntime[] getDataSetRuntime(int nestedCount) {
            return null;
        }

        public void cancel() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private class RDSaveUtil {
        private DataEngineContext context;
        private String queryResultID;
        private IBaseQueryDefinition queryDefn;
        private IRDSave rdSave;
        private boolean isBasicSaved;

        RDSaveUtil(DataEngineContext context, IBaseQueryDefinition queryDefn, String queryResultID) {
            this.context = context;
            this.queryDefn = queryDefn;
            this.queryResultID = queryResultID;
        }

        void doSaveExpr(Map valueMap) throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            if (!this.isBasicSaved) {
                int[] subQueryInfo;
                int groupLevel;
                this.isBasicSaved = true;
                if (PreparedDummyQuery.this.subQueryName == null) {
                    groupLevel = -1;
                    subQueryInfo = null;
                } else {
                    groupLevel = 1;
                    int[] nArray = new int[2];
                    nArray[1] = 1;
                    subQueryInfo = nArray;
                }
                this.getRdSave().saveResultIterator(new DummyCachedResult(), groupLevel, subQueryInfo);
            }
            this.getRdSave().saveExprValue(0, valueMap);
        }

        void doSaveFinish() throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            if (!this.isBasicSaved) {
                this.isBasicSaved = true;
                int[] nArray = new int[2];
                nArray[1] = 1;
                this.getRdSave().saveResultIterator(new DummyCachedResult(), -1, nArray);
            }
            this.getRdSave().saveFinish(0);
        }

        void doSaveStart() throws DataException {
            if (!this.needsSaveToDoc()) {
                return;
            }
            this.getRdSave().saveStart();
        }

        private boolean needsSaveToDoc() {
            return this.context != null && this.context.getMode() == 1;
        }

        private IRDSave getRdSave() throws DataException {
            if (this.rdSave == null) {
                this.rdSave = RDUtil.newSave(this.context, this.queryDefn != null ? this.queryDefn : PreparedDummyQuery.this.subQueryDefn, 1, new QueryResultInfo(this.queryResultID, PreparedDummyQuery.this.subQueryName, PreparedDummyQuery.this.subQueryIndex));
            }
            return this.rdSave;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultIterator
    implements IResultIterator {
        private QueryResults queryResults;
        private ExprManager exprManager;
        private Scriptable queryScope;
        private Scriptable jsDummyRowObject;
        private RDSaveUtil rdSaveUtil;
        private Map exprValueMap;
        private static final int NOT_START = 0;
        private static final int IN_ROW = 1;
        private static final int ENDED = 2;
        private int openStatus = 0;
        private OutputStream metaOutputStream = null;
        private DataOutputStream rowOutputStream = null;

        private void checkOpened() throws BirtException {
            if (this.openStatus != 1) {
                throw new DataException("data.engine.resultIteratorNotOpen");
            }
        }

        private ResultIterator(QueryResults queryResults, ExprManager exprManager, Scriptable queryScope, Scriptable parentScope) throws BirtException {
            this.queryResults = queryResults;
            this.exprManager = exprManager;
            this.queryScope = queryScope;
            this.jsDummyRowObject = new JSDummyRowObject(exprManager, queryScope, parentScope, PreparedDummyQuery.this.session.getEngineContext().getScriptContext());
            queryScope.put("row", queryScope, (Object)this.jsDummyRowObject);
            this.getRdSaveUtil().doSaveStart();
            this.exprValueMap = new HashMap();
            Map exprMap = this.getBindingMap(exprManager.getBindingExprs());
            for (Map.Entry entry : exprMap.entrySet()) {
                String exprName = (String)entry.getKey();
                IBaseExpression baseExpr = (IBaseExpression)entry.getValue();
                Object exprValue = ExprEvaluateUtil.evaluateRawExpression(baseExpr, queryScope, PreparedDummyQuery.this.session.getEngineContext().getScriptContext());
                IBinding binding = exprManager.getBinding(exprName);
                if (baseExpr != null && binding.getDataType() != baseExpr.getDataType()) {
                    exprValue = DataTypeUtil.convert(exprValue, binding.getDataType());
                }
                this.exprValueMap.put(exprName, exprValue);
            }
            this.getRdSaveUtil().doSaveExpr(this.exprValueMap);
            if (this.needCache()) {
                try {
                    this.createCacheOutputStream();
                    this.saveMetaData();
                    IOUtil.writeInt(this.rowOutputStream, 1);
                    this.cacheRow();
                }
                catch (IOException iOException) {
                    throw new DataException("data.engine.CreateCacheTempError");
                }
            }
        }

        private void cacheRow() throws IOException, BirtException {
            Object[] columns = this.exprValueMap.keySet().toArray();
            IOUtil.writeInt(this.rowOutputStream, columns.length);
            int i = 0;
            while (i < columns.length) {
                IOUtil.writeObject(this.rowOutputStream, columns[i]);
                ++i;
            }
            IOUtil.writeInt(this.rowOutputStream, 0);
            IOUtil.writeInt(this.rowOutputStream, 0);
            IOUtil.writeInt(this.rowOutputStream, 0);
            Iterator iterator = this.exprValueMap.values().iterator();
            while (iterator.hasNext()) {
                IOUtil.writeObject(this.rowOutputStream, iterator.next());
            }
            this.closeCacheOutputStream();
        }

        private void closeCacheOutputStream() throws DataException {
            try {
                if (this.rowOutputStream != null) {
                    IOUtil.writeInt(this.rowOutputStream, -1);
                    this.rowOutputStream.close();
                    this.rowOutputStream = null;
                }
            }
            catch (IOException iOException) {
                throw new DataException("data.engine.CloseCacheTempError");
            }
        }

        private Scriptable getJSDummyRowObject() {
            return this.jsDummyRowObject;
        }

        private void createCacheOutputStream() throws FileNotFoundException, DataException {
            File tmpDir = new File(PreparedDummyQuery.this.session.getTempDir());
            if (!FileSecurity.fileExist(tmpDir) || !FileSecurity.fileIsDirectory(tmpDir)) {
                FileSecurity.fileMakeDirs(tmpDir);
            }
            this.metaOutputStream = new BufferedOutputStream(FileSecurity.createFileOutputStream(ResultSetCacheUtil.getMetaFile(PreparedDummyQuery.this.session.getTempDir(), this.queryResults.getID())), 1024);
            this.rowOutputStream = new DataOutputStream(new BufferedOutputStream(FileSecurity.createFileOutputStream(ResultSetCacheUtil.getDataFile(PreparedDummyQuery.this.session.getTempDir(), this.queryResults.getID())), 1024));
            ResultSetCacheUtil.getDataFile(PreparedDummyQuery.this.session.getTempDir(), this.queryResults.getID());
            ResultSetCacheUtil.getMetaFile(PreparedDummyQuery.this.session.getTempDir(), this.queryResults.getID());
        }

        private void saveMetaData() throws DataException, IOException {
            ArrayList<IBinding> metaMap = new ArrayList<IBinding>();
            this.populateDataSetRowMapping(metaMap, this.getResultClass());
            ((ResultClass)this.getResultClass()).doSave(this.metaOutputStream, metaMap, VersionManager.getLatestVersion());
            if (this.metaOutputStream != null) {
                this.metaOutputStream.close();
                this.metaOutputStream = null;
            }
        }

        private void populateDataSetRowMapping(List<IBinding> metaMap, IResultClass rsClass) throws DataException {
            int i = 0;
            while (i < rsClass.getFieldCount()) {
                Binding binding = new Binding(rsClass.getFieldName(i + 1));
                binding.setExpression(new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression(rsClass.getFieldName(i + 1))));
                metaMap.add(binding);
                ++i;
            }
        }

        private boolean needCache() {
            if (this.queryResults == null || this.queryResults.getPreparedQuery().getReportQueryDefn() == null) {
                return false;
            }
            return this.queryResults.getPreparedQuery().getReportQueryDefn().cacheQueryResults();
        }

        @Override
        public IQueryResults getQueryResults() {
            return this.queryResults;
        }

        @Override
        public Scriptable getScope() {
            return this.queryScope;
        }

        @Override
        public IResultMetaData getResultMetaData() throws BirtException {
            return new ResultMetaData(new ResultClass(new ArrayList()));
        }

        private IResultClass getResultClass() throws DataException {
            ArrayList<ResultFieldMetadata> columns = new ArrayList<ResultFieldMetadata>();
            Iterator bindings = this.queryResults.getPreparedQuery().getReportQueryDefn().getBindings().values().iterator();
            int position = 0;
            while (bindings.hasNext()) {
                IBinding binding = (IBinding)bindings.next();
                columns.add(new ResultFieldMetadata(position, binding.getBindingName(), binding.getDisplayName(), binding.getClass(), null, false, -1));
                ++position;
            }
            return new ResultClass(columns);
        }

        @Override
        public boolean next() throws BirtException {
            if (this.openStatus == 0) {
                this.openStatus = 1;
                return true;
            }
            if (this.openStatus == 1) {
                this.openStatus = 2;
                return false;
            }
            throw new DataException("data.engine.resultIteratorClosed");
        }

        @Override
        public int getRowId() throws BirtException {
            return this.getRowIndex();
        }

        @Override
        public int getRowIndex() throws BirtException {
            this.checkOpened();
            return 0;
        }

        @Override
        public void moveTo(int rowIndex) throws BirtException {
            this.checkOpened();
            if (rowIndex > 0) {
                throw new DataException("data.engine.invalidRowIndex", rowIndex);
            }
        }

        @Override
        public Object getValue(String name) throws BirtException {
            this.checkOpened();
            if (this.exprManager.getExpr(name) == null) {
                throw new DataException("data.engine.InvalidBoundColumnName", name);
            }
            Object o = this.exprValueMap.get(name);
            IBinding b = this.exprManager.getBinding(name);
            if (o != null && b != null) {
                o = DataTypeUtil.convert(o, b.getDataType());
            }
            return o;
        }

        private Map getBindingMap(List manualBindingExprs) throws DataException {
            HashMap<String, IBaseExpression> exprMap = new HashMap<String, IBaseExpression>();
            int size = manualBindingExprs.size();
            GroupBindingColumn[] groupBindingColumns = new GroupBindingColumn[size];
            Iterator itr = manualBindingExprs.iterator();
            while (itr.hasNext()) {
                GroupBindingColumn temp;
                groupBindingColumns[temp.getGroupLevel()] = temp = (GroupBindingColumn)itr.next();
            }
            int i = 0;
            while (i < size) {
                for (String exprName : groupBindingColumns[i].getColumnNames()) {
                    IBaseExpression baseExpr = groupBindingColumns[i].getExpression(exprName);
                    exprMap.put(exprName, baseExpr);
                }
                ++i;
            }
            return exprMap;
        }

        @Override
        public Boolean getBoolean(String name) throws BirtException {
            return DataTypeUtil.toBoolean(this.getValue(name));
        }

        @Override
        public Integer getInteger(String name) throws BirtException {
            return DataTypeUtil.toInteger(this.getValue(name));
        }

        @Override
        public Double getDouble(String name) throws BirtException {
            return DataTypeUtil.toDouble(this.getValue(name));
        }

        @Override
        public String getString(String name) throws BirtException {
            return DataTypeUtil.toString(this.getValue(name));
        }

        @Override
        public BigDecimal getBigDecimal(String name) throws BirtException {
            return DataTypeUtil.toBigDecimal(this.getValue(name));
        }

        @Override
        public Date getDate(String name) throws BirtException {
            return DataTypeUtil.toDate(this.getValue(name));
        }

        @Override
        public Blob getBlob(String name) throws BirtException {
            return DataTypeUtil.toBlob(this.getValue(name));
        }

        @Override
        public byte[] getBytes(String name) throws BirtException {
            return DataTypeUtil.toBytes(this.getValue(name));
        }

        @Override
        public void skipToEnd(int groupLevel) throws BirtException {
            this.checkOpened();
            if (groupLevel > 0) {
                throw new DataException("data.engine.InvalidGroupLevel", groupLevel);
            }
        }

        @Override
        public int getStartingGroupLevel() throws BirtException {
            this.checkOpened();
            return 0;
        }

        @Override
        public int getEndingGroupLevel() throws BirtException {
            this.checkOpened();
            return 0;
        }

        @Override
        public IResultIterator getSecondaryIterator(String subQueryName, Scriptable scope) throws BirtException {
            this.checkOpened();
            return this.queryResults.preparedQuery.execSubQuery(this.getQueryResultsID(), subQueryName, scope != null ? scope : this.queryScope, this.jsDummyRowObject);
        }

        @Override
        public IResultIterator getSecondaryIterator(ScriptContext context, String subQueryName) throws BirtException {
            Scriptable scope = null;
            if (context != null) {
                scope = ((IDataScriptEngine)((Object)context.getScriptEngine("javascript"))).getJSScope(context);
            }
            return this.getSecondaryIterator(subQueryName, scope);
        }

        private String getQueryResultsID() {
            if (PreparedDummyQuery.this.subQueryName == null) {
                return this.queryResults.getID();
            }
            return String.valueOf(this.queryResults.getID()) + "/" + PreparedDummyQuery.this.subQueryName + "/" + PreparedDummyQuery.this.subQueryIndex;
        }

        @Override
        public void close() throws BirtException {
            this.openStatus = 2;
            this.getRdSaveUtil().doSaveFinish();
        }

        @Override
        public boolean findGroup(Object[] groupKeyValues) throws BirtException {
            this.checkOpened();
            return false;
        }

        private RDSaveUtil getRdSaveUtil() {
            if (this.rdSaveUtil == null) {
                this.rdSaveUtil = new RDSaveUtil(PreparedDummyQuery.this.session.getEngineContext(), PreparedDummyQuery.this.queryDefn, this.queryResults.getID());
            }
            return this.rdSaveUtil;
        }

        @Override
        public boolean isEmpty() throws BirtException {
            return false;
        }

        @Override
        public boolean isBeforeFirst() throws BirtException {
            return !this.isEmpty() && this.openStatus == 0;
        }

        @Override
        public boolean isFirst() throws BirtException {
            return !this.isEmpty() && this.openStatus == 1;
        }
    }
}

