/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryExecutionHints;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.core.DataException;

public class SortingOptimizer {
    private List<ISortDefinition> sortHints;
    private List<ISortDefinition> sortings;
    private List<IGroupDefinition> groups;
    private IQueryExecutionHints queryExeHint;
    private SortMatcher hintsMatcher;
    private boolean optimizeGroupSorting = false;
    private boolean optimizeQuerySorting = false;
    private IBaseQueryDefinition baseQuery = null;
    private IBaseDataSetDesign dataSet = null;

    public SortingOptimizer(IBaseDataSetDesign dataSet, IBaseQueryDefinition query) {
        if (dataSet == null || query == null) {
            return;
        }
        this.sortHints = dataSet.getSortHints();
        this.dataSet = dataSet;
        this.baseQuery = query;
        this.groups = query.getGroups();
        this.sortings = query.getSorts();
        this.queryExeHint = query.getQueryExecutionHints();
        this.hintsMatcher = new SortMatcher(this.sortHints);
    }

    public boolean acceptGroupSorting() {
        if (this.sortHints == null || this.groups == null) {
            return false;
        }
        if (this.queryExeHint != null && !this.queryExeHint.doSortBeforeGrouping()) {
            return false;
        }
        for (IGroupDefinition o : this.groups) {
            IGroupDefinition g = o;
            if (g.getInterval() == 0) continue;
            return false;
        }
        if (this.sortings != null) {
            GroupSortingCaculator calc = new GroupSortingCaculator(this.groups);
            List sorts = calc.getSortingSequence(this.sortings, new SortDefnMatchInfo());
            if (this.hintsMatcher.match(sorts, new GroupDefnSortDefnMatchInfo())) {
                this.optimizeGroupSorting = true;
                this.optimizeQuerySorting = true;
            }
        } else if (this.hintsMatcher.match(this.groups, new GroupDefnMatchInfo())) {
            this.optimizeGroupSorting = true;
        }
        return this.optimizeGroupSorting;
    }

    public boolean acceptQuerySorting() throws DataException {
        if (this.sortHints == null || this.sortings == null) {
            return false;
        }
        if (this.optimizeQuerySorting) {
            return true;
        }
        return this.hintsMatcher.match(this.sortings, new SortDefnMatchInfo());
    }

    private String resolveDataSetExpr(String rowExpr) throws DataException {
        if (rowExpr == null) {
            return null;
        }
        String dataSetExpr = null;
        try {
            String bindingName = ExpressionUtil.getColumnBindingName(rowExpr);
            Object binding = this.baseQuery.getBindings().get(bindingName);
            if (binding != null) {
                IBaseExpression expr = ((IBinding)binding).getExpression();
                if (expr != null && expr instanceof IScriptExpression && (dataSetExpr = ((IScriptExpression)expr).getText()) != null) {
                    return this.resolveDataSetExpr(dataSetExpr);
                }
                return dataSetExpr;
            }
            return rowExpr;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private String resolveColumnAlias(String columnAlias) {
        List rsHints = this.dataSet.getResultSetHints();
        if (rsHints == null) {
            return null;
        }
        String resolved = null;
        IColumnDefinition col2 = null;
        for (IColumnDefinition col2 : rsHints) {
            if (col2.getAlias() == null || !col2.getAlias().equals(columnAlias)) continue;
            resolved = col2.getColumnName();
            break;
        }
        return resolved;
    }

    private String getResolvedExpression(String rowExpr) {
        String expr = null;
        try {
            String bindingName;
            String column;
            expr = this.resolveDataSetExpr(rowExpr);
            if (expr != null && (column = this.resolveColumnAlias(bindingName = ExpressionUtil.getColumnName(expr))) != null) {
                expr = ExpressionUtil.createDataSetRowExpression(column);
            }
        }
        catch (BirtException birtException) {
            expr = null;
        }
        return expr;
    }

    private String getGroupKeyExpression(IGroupDefinition src) {
        String expr = src.getKeyColumn();
        expr = expr == null ? src.getKeyExpression() : this.getColumnRefExpression(expr);
        return expr;
    }

    private String getColumnRefExpression(String expr) {
        return ExpressionUtil.createJSRowExpression(expr);
    }

    class GroupDefnMatchInfo
    implements MatchInfo {
        GroupDefnMatchInfo() {
        }

        public String getKey(Object o) {
            IGroupDefinition grp = (IGroupDefinition)o;
            String rowExpr = SortingOptimizer.this.getGroupKeyExpression(grp);
            return SortingOptimizer.this.getResolvedExpression(rowExpr);
        }

        public int getDirection(Object o) {
            IGroupDefinition grp = (IGroupDefinition)o;
            return grp.getSortDirection();
        }
    }

    class GroupDefnSortDefnMatchInfo
    implements MatchInfo {
        private MatchInfo grpInfo;
        private MatchInfo sortInfo;

        GroupDefnSortDefnMatchInfo() {
            this.grpInfo = new GroupDefnMatchInfo();
            this.sortInfo = new SortDefnMatchInfo();
        }

        public String getKey(Object o) {
            if (o instanceof IGroupDefinition) {
                return this.grpInfo.getKey(o);
            }
            if (o instanceof ISortDefinition) {
                return this.sortInfo.getKey(o);
            }
            return null;
        }

        public int getDirection(Object o) {
            if (o instanceof IGroupDefinition) {
                return this.grpInfo.getDirection(o);
            }
            if (o instanceof ISortDefinition) {
                return this.sortInfo.getDirection(o);
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GroupSortingCaculator {
        private List<?> base = null;
        private MatchInfo hInfo = null;
        private List<?> compareSorts = null;

        public GroupSortingCaculator(List<?> sortHints, MatchInfo info) {
            this.base = sortHints;
            this.hInfo = info;
        }

        public GroupSortingCaculator(List<?> sortHints) {
            this(sortHints, sortingOptimizer.new GroupDefnMatchInfo());
        }

        private void caculate(List<?> sorts, MatchInfo util) {
            if (this.base == null || this.base.size() == 0) {
                return;
            }
            int pos = 0;
            int j = 0;
            while (pos < this.base.size() && j < sorts.size()) {
                String hKey = this.hInfo.getKey(this.base.get(pos));
                int hDirection = this.hInfo.getDirection(this.base.get(pos));
                String mKey = util.getKey(sorts.get(j));
                int mDirection = util.getDirection(sorts.get(j));
                if (hKey != null && mKey != null && hKey.equals(mKey) && hDirection == mDirection) {
                    ++pos;
                    ++j;
                    continue;
                }
                ++pos;
            }
            this.compareSorts = sorts.subList(j, sorts.size());
        }

        public List getSortingSequence(List<?> querySorts, MatchInfo util) {
            this.caculate(querySorts, util);
            ArrayList sorts = new ArrayList();
            Iterator<?> it = this.base.iterator();
            while (it.hasNext()) {
                sorts.add(it.next());
            }
            if (this.compareSorts != null) {
                it = this.compareSorts.iterator();
                while (it.hasNext()) {
                    sorts.add(it.next());
                }
            }
            return sorts;
        }
    }

    static interface MatchInfo {
        public String getKey(Object var1);

        public int getDirection(Object var1);
    }

    class SortDefnMatchInfo
    implements MatchInfo {
        SortDefnMatchInfo() {
        }

        public String getKey(Object o) {
            ISortDefinition sort = (ISortDefinition)o;
            if (sort.getSortLocale() != null || sort.getSortStrength() != -1) {
                return null;
            }
            String sortKey = sort.getColumn();
            sortKey = sortKey == null ? sort.getExpression().getText() : SortingOptimizer.this.getColumnRefExpression(sortKey);
            return SortingOptimizer.this.getResolvedExpression(sortKey);
        }

        public int getDirection(Object o) {
            ISortDefinition sort = (ISortDefinition)o;
            return sort.getSortDirection();
        }
    }

    class SortHintMatchInfo
    implements MatchInfo {
        SortHintMatchInfo() {
        }

        public String getKey(Object o) {
            ISortDefinition sort = (ISortDefinition)o;
            String key = sort.getColumn();
            if (key == null) {
                key = sort.getExpression().getText();
            }
            return key;
        }

        public int getDirection(Object o) {
            ISortDefinition sort = (ISortDefinition)o;
            return sort.getSortDirection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SortMatcher {
        private List<?> hints = null;
        private MatchInfo hInfo = null;

        public SortMatcher(List<?> sortHints, MatchInfo info) {
            this.hints = sortHints;
            this.hInfo = info;
        }

        public SortMatcher(List<?> sortHints) {
            this(sortHints, sortingOptimizer.new SortHintMatchInfo());
        }

        public boolean match(List<?> sorts, MatchInfo util) {
            if (this.hints == null || this.hints.size() == 0 || this.hints.size() < sorts.size()) {
                return false;
            }
            int pos = 0;
            while (pos < this.hints.size() && pos < sorts.size()) {
                String hKey = this.hInfo.getKey(this.hints.get(pos));
                int hDirection = this.hInfo.getDirection(this.hints.get(pos));
                String mKey = util.getKey(sorts.get(pos));
                int mDirection = util.getDirection(sorts.get(pos));
                if (hKey == null || mKey == null || !hKey.equals(mKey) || hDirection != mDirection) break;
                ++pos;
            }
            return pos == sorts.size();
        }
    }
}

