/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.cache.ResultSetUtil;
import org.eclipse.birt.data.engine.impl.StringTable;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetResultSet
implements IDataSetPopulator {
    private int rowIndex;
    private int rowCount;
    private int version;
    private RAInputStream inputStream;
    private BufferedInputStream bis;
    private DataInputStream dis;
    private IResultClass rsMetaData;
    private int colCount;
    private IResultObject currentObject;
    private RAInputStream dataSetRowLensStream;
    private DataInputStream disRowLensStream;
    private long initPos;
    private List<Integer> prefilteredRowIds;
    private Map index;
    private Map<String, StringTable> stringTableMap;
    private boolean includeInnerID = true;

    public DataSetResultSet(RAInputStream inputStream, RAInputStream lensStream, IResultClass rsMetaData, Set<Integer> prefilteredRows, Map<String, StringTable> stringTableMap, Map index, int version) throws DataException {
        this(inputStream, lensStream, rsMetaData, prefilteredRows, stringTableMap, index, version, true);
    }

    public DataSetResultSet(RAInputStream inputStream, RAInputStream lensStream, IResultClass rsMetaData, Set<Integer> prefilteredRows, Map<String, StringTable> stringTableMap, Map index, int version, boolean includeInnerID) throws DataException {
        assert (inputStream != null);
        assert (rsMetaData != null);
        this.inputStream = inputStream;
        this.rowIndex = -1;
        this.includeInnerID = includeInnerID;
        this.version = version;
        this.dataSetRowLensStream = lensStream;
        if (lensStream != null) {
            this.disRowLensStream = new DataInputStream(this.dataSetRowLensStream);
        }
        try {
            this.initPos = this.inputStream.getOffset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.rsMetaData = this.populateResultClass(rsMetaData);
        this.colCount = rsMetaData.getFieldCount();
        if (prefilteredRows != null) {
            this.prefilteredRowIds = new LinkedList<Integer>();
            this.prefilteredRowIds.addAll(prefilteredRows);
        }
        if (this.prefilteredRowIds != null) {
            Collections.sort(this.prefilteredRowIds);
        }
        this.index = index;
        this.stringTableMap = stringTableMap;
        this.initLoad();
    }

    private IResultClass populateResultClass(IResultClass meta) throws DataException {
        ArrayList<ResultFieldMetadata> list = new ArrayList<ResultFieldMetadata>();
        int i = 1;
        while (i <= meta.getFieldCount()) {
            list.add(meta.getFieldMetaData(i));
            ++i;
        }
        if (this.includeInnerID) {
            ResultFieldMetadata rfm = new ResultFieldMetadata(0, "_$$_dte_inner_row_id_$$_", null, Integer.class, null, true, -1);
            list.add(rfm);
        }
        return new ResultClass(list);
    }

    public int getRowCount() {
        if (this.prefilteredRowIds != null) {
            return this.prefilteredRowIds.size();
        }
        return this.rowCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IResultObject next() throws DataException {
        if (this.prefilteredRowIds != null) {
            if (this.prefilteredRowIds.isEmpty()) {
                return null;
            }
            this.skipTo(this.prefilteredRowIds.get(0));
            this.prefilteredRowIds.remove(0);
            return this.getResultObject();
        }
        if (this.rowIndex < this.rowCount - 1 || this.rowCount == -1) {
            try {
                ++this.rowIndex;
                this.currentObject = ResultSetUtil.readResultObject(this.dis, this.rsMetaData, this.colCount, this.stringTableMap, this.index, this.version);
                if (!this.includeInnerID) return this.currentObject;
                this.currentObject.setCustomFieldValue("_$$_dte_inner_row_id_$$_", (Object)this.getCurrentIndex());
                return this.currentObject;
            }
            catch (Exception e) {
                throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, (Object)"Result Data");
            }
        } else {
            this.currentObject = null;
        }
        return this.currentObject;
    }

    public IResultObject getResultObject() {
        return this.currentObject;
    }

    public int getCurrentIndex() {
        return this.rowIndex;
    }

    public void skipTo(int index) throws DataException {
        try {
            if (this.rowIndex == index) {
                return;
            }
            if ((this.rowIndex < this.rowCount || this.rowCount == -1) && this.dataSetRowLensStream != null) {
                this.dataSetRowLensStream.seek((long)index * 8L);
                long position = IOUtil.readLong(this.disRowLensStream);
                this.rowIndex = index;
                this.inputStream.seek(position + this.initPos);
                this.dis = new DataInputStream(this.inputStream);
                this.currentObject = ResultSetUtil.readResultObject(this.dis, this.rsMetaData, this.colCount, this.stringTableMap, this.index, this.version);
                if (this.includeInnerID) {
                    this.currentObject.setCustomFieldValue("_$$_dte_inner_row_id_$$_", (Object)this.getCurrentIndex());
                }
                return;
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    private void initLoad() throws DataException {
        if (this.dis == null) {
            this.bis = new BufferedInputStream(this.inputStream);
            try {
                this.dis = new DataInputStream(this.bis);
                this.rowCount = IOUtil.readInt(this.dis);
            }
            catch (IOException e) {
                throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, (Object)"result data");
            }
        }
    }

    public IResultClass getResultClass() {
        return this.rsMetaData;
    }

    public void close() {
        try {
            if (this.dis != null) {
                this.dis.close();
                this.bis.close();
            }
            if (this.disRowLensStream != null) {
                this.disRowLensStream.close();
            }
        }
        catch (IOException iOException) {}
    }
}

