/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.cursor.Accessor;
import org.eclipse.birt.data.engine.olap.cursor.ComparableObject;
import org.eclipse.birt.data.engine.olap.cursor.UniqueNamingUtil;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.IEdgeAxis;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.Relationship;
import org.eclipse.birt.data.engine.olap.util.CubeRunningNestAggrDefn;

public class AggregationAccessor
extends Accessor {
    private BirtCubeView view;
    private IResultSet resultSet;
    private Map relationMap;
    private int[] currentPosition;
    private boolean firstNextMeasure = true;
    private IAggregationResultSet maxAggregationResultSet = null;
    private EdgeCursor rowEdgeCursor = null;
    private EdgeCursor columnEdgeCursor = null;
    private EdgeCursor pageEdgeCursor = null;
    private Relationship maxRelationship = null;
    private int[] rowLevelIndexs;
    private int[] columnLevelIndexs;
    private int[] pageLevelIndexs;
    private ComparableObject[] rowCursorObjs;
    private ComparableObject[] columnCursorObjs;
    private ComparableObject[] pageCursorObjs;
    private boolean dimensionPrepared = false;
    private Map dimensionCursorMap;
    private Map<String, Integer> aggregationResultSetIDMap;

    public AggregationAccessor(BirtCubeView view, IResultSet result, Map relationMap) {
        this.resultSet = result;
        this.view = view;
        this.relationMap = relationMap;
        this.dimensionPrepared = false;
        this.dimensionCursorMap = new HashMap();
        this.aggregationResultSetIDMap = new HashMap<String, Integer>();
        if (result == null || result.getMeasureResult() == null) {
            return;
        }
        this.currentPosition = new int[this.resultSet.getMeasureResult().length];
        int i = 0;
        while (i < this.resultSet.getMeasureResult().length) {
            try {
                if (this.resultSet.getMeasureResult()[i].getQueryResultSet().length() > 0) {
                    this.resultSet.getMeasureResult()[i].getQueryResultSet().seek(0);
                    this.currentPosition[i] = 0;
                } else {
                    this.currentPosition[i] = -1;
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        this.initMeasureNavigator();
    }

    private void initMeasureNavigator() {
        int j;
        DimLevel level;
        IEdgeAxis[] edgeAxises = this.resultSet.getMeasureResult();
        int measureMaxSize = 0;
        int i = 0;
        while (i < edgeAxises.length) {
            if (edgeAxises[i].getQueryResultSet().getAllLevels() != null && edgeAxises[i].getQueryResultSet().getAllLevels().length > measureMaxSize) {
                this.maxAggregationResultSet = edgeAxises[i].getQueryResultSet();
                measureMaxSize = edgeAxises[i].getQueryResultSet().getAllLevels().length;
            }
            ++i;
        }
        Iterator iterator = this.relationMap.values().iterator();
        int relationMaxLevelSize = 0;
        this.maxRelationship = new Relationship(new ArrayList(), new ArrayList(), new ArrayList());
        while (iterator.hasNext()) {
            Relationship relation = (Relationship)iterator.next();
            int levelSize = relation.getLevelListOnColumn().size() + relation.getLevelListOnPage().size() + relation.getLevelListOnRow().size();
            if (levelSize <= relationMaxLevelSize) continue;
            relationMaxLevelSize = levelSize;
            this.maxRelationship = relation;
        }
        DimLevel[] measureLevels = new DimLevel[]{};
        if (this.maxAggregationResultSet != null) {
            measureLevels = this.maxAggregationResultSet.getAllLevels();
        }
        this.rowLevelIndexs = new int[this.maxRelationship.getLevelListOnRow().size()];
        int i2 = 0;
        while (i2 < this.rowLevelIndexs.length) {
            level = (DimLevel)this.maxRelationship.getLevelListOnRow().get(i2);
            j = 0;
            while (j < measureLevels.length) {
                if (level.equals(measureLevels[j])) {
                    this.rowLevelIndexs[i2] = j;
                }
                ++j;
            }
            ++i2;
        }
        this.columnLevelIndexs = new int[this.maxRelationship.getLevelListOnColumn().size()];
        i2 = 0;
        while (i2 < this.columnLevelIndexs.length) {
            level = (DimLevel)this.maxRelationship.getLevelListOnColumn().get(i2);
            j = 0;
            while (j < measureLevels.length) {
                if (level.equals(measureLevels[j])) {
                    this.columnLevelIndexs[i2] = j;
                }
                ++j;
            }
            ++i2;
        }
        this.pageLevelIndexs = new int[this.maxRelationship.getLevelListOnPage().size()];
        i2 = 0;
        while (i2 < this.pageLevelIndexs.length) {
            level = (DimLevel)this.maxRelationship.getLevelListOnPage().get(i2);
            j = 0;
            while (j < measureLevels.length) {
                if (level.equals(measureLevels[j])) {
                    this.pageLevelIndexs[i2] = j;
                }
                ++j;
            }
            ++i2;
        }
    }

    private void prepareDimensionCursor() throws OLAPException {
        if (this.view.getRowEdgeView() != null) {
            this.rowEdgeCursor = this.view.getRowEdgeView().getEdgeCursor();
            if (this.rowEdgeCursor != null) {
                for (DimensionCursor cursor : this.rowEdgeCursor.getDimensionCursor()) {
                    this.dimensionCursorMap.put(cursor.getName(), cursor);
                }
            }
        }
        if (this.view.getColumnEdgeView() != null) {
            this.columnEdgeCursor = this.view.getColumnEdgeView().getEdgeCursor();
            if (this.columnEdgeCursor != null) {
                for (DimensionCursor cursor : this.columnEdgeCursor.getDimensionCursor()) {
                    this.dimensionCursorMap.put(cursor.getName(), cursor);
                }
            }
        }
        if (this.view.getPageEdgeView() != null) {
            this.pageEdgeCursor = this.view.getPageEdgeView().getEdgeCursor();
            if (this.pageEdgeCursor != null) {
                for (DimensionCursor cursor : this.pageEdgeCursor.getDimensionCursor()) {
                    this.dimensionCursorMap.put(cursor.getName(), cursor);
                }
            }
        }
    }

    public void close() throws OLAPException {
        if (this.resultSet == null || this.resultSet.getMeasureResult() == null) {
            return;
        }
        ArrayList<IOException> errorList = new ArrayList<IOException>();
        int i = 0;
        while (i < this.resultSet.getMeasureResult().length) {
            try {
                this.resultSet.getMeasureResult()[i].getQueryResultSet().close();
            }
            catch (IOException e) {
                errorList.add(e);
            }
            ++i;
        }
        if (!errorList.isEmpty()) {
            throw new OLAPException(((IOException)errorList.get(0)).getLocalizedMessage());
        }
    }

    public Object getObject(int arg0) throws OLAPException {
        if (this.resultSet == null || this.resultSet.getMeasureResult() == null) {
            return null;
        }
        try {
            String aggrName = this.view.getAggregationRegisterTable().getAggrName(arg0);
            int index = 0;
            int aggrIndex = 0;
            IAggregationResultSet rs = null;
            if (this.aggregationResultSetIDMap.containsKey(arg0)) {
                index = this.aggregationResultSetIDMap.get(arg0);
                rs = this.resultSet.getMeasureResult()[index].getQueryResultSet();
                aggrIndex = rs.getAggregationIndex(aggrName);
            } else {
                IEdgeAxis[] axis = this.resultSet.getMeasureResult();
                while (index < axis.length) {
                    aggrIndex = axis[index].getQueryResultSet().getAggregationIndex(aggrName);
                    if (aggrIndex >= 0) {
                        rs = axis[index].getQueryResultSet();
                        this.aggregationResultSetIDMap.put(aggrName, index);
                        break;
                    }
                    ++index;
                }
            }
            if (this.synchronizedWithEdge(index, rs, aggrName, this.getCurrentValueOnEdge(aggrName))) {
                return rs.getAggregationValue(aggrIndex);
            }
            return null;
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
        catch (DataException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
    }

    public Object getObject(String arg0) throws OLAPException {
        if (this.resultSet == null || this.resultSet.getMeasureResult() == null) {
            return null;
        }
        try {
            int index = 0;
            int aggrIndex = 0;
            IAggregationResultSet rs = null;
            if (this.aggregationResultSetIDMap.containsKey(arg0)) {
                index = this.aggregationResultSetIDMap.get(arg0);
                rs = this.resultSet.getMeasureResult()[index].getQueryResultSet();
                aggrIndex = rs.getAggregationIndex(arg0);
            } else {
                IEdgeAxis[] axis = this.resultSet.getMeasureResult();
                while (index < axis.length) {
                    aggrIndex = axis[index].getQueryResultSet().getAggregationIndex(arg0);
                    if (aggrIndex >= 0) {
                        rs = axis[index].getQueryResultSet();
                        this.aggregationResultSetIDMap.put(arg0, index);
                        break;
                    }
                    ++index;
                }
            }
            if (this.synchronizedWithEdge(index, rs, arg0, this.getCurrentValueOnEdge(arg0))) {
                return rs.getAggregationValue(aggrIndex);
            }
            return null;
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
        catch (DataException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
    }

    private boolean synchronizedWithEdge(int index, IAggregationResultSet rs, String aggrName, Map valueMap) throws OLAPException, IOException, DataException {
        if (rs == null || rs.length() <= 0) {
            return false;
        }
        if (valueMap == null) {
            return true;
        }
        List<DimLevel> memberList = Arrays.asList(rs.getAllLevels());
        CalculatedMember member = this.view.getAggregationRegisterTable().getCalculatedMember(aggrName);
        if (member != null && member.getCubeAggrDefn() instanceof CubeRunningNestAggrDefn) {
            return this.findValueMatcherOneByOne(rs, memberList, valueMap, index);
        }
        return this.findValueMatcher(rs, memberList, valueMap, index);
    }

    public boolean nextMeasure() throws IOException, OLAPException {
        int pos = this.maxAggregationResultSet.getPosition();
        if (this.firstNextMeasure) {
            if (pos >= this.maxAggregationResultSet.length()) {
                return false;
            }
            this.firstNextMeasure = false;
        } else {
            if (pos + 1 >= this.maxAggregationResultSet.length()) {
                return false;
            }
            this.maxAggregationResultSet.seek(pos + 1);
        }
        DimLevel[] levels = this.maxAggregationResultSet.getAllLevels();
        Object[] keyValues = new Object[levels.length];
        int i = 0;
        while (i < levels.length) {
            keyValues[i] = this.maxAggregationResultSet.getLevelKeyValue(i)[0];
            ++i;
        }
        if (this.view.getRowEdgeView() != null && this.rowEdgeCursor == null) {
            this.rowEdgeCursor = this.view.getRowEdgeView().getEdgeCursor();
            this.rowCursorObjs = this.fetcheObjects(this.rowEdgeCursor, this.maxRelationship.getLevelListOnRow());
        }
        if (this.view.getColumnEdgeView() != null && this.columnEdgeCursor == null) {
            this.columnEdgeCursor = this.view.getColumnEdgeView().getEdgeCursor();
            this.columnCursorObjs = this.fetcheObjects(this.columnEdgeCursor, this.maxRelationship.getLevelListOnColumn());
        }
        if (this.view.getPageEdgeView() != null && this.pageEdgeCursor == null) {
            this.pageEdgeCursor = this.view.getPageEdgeView().getEdgeCursor();
            this.pageCursorObjs = this.fetcheObjects(this.pageEdgeCursor, this.maxRelationship.getLevelListOnPage());
        }
        if (this.rowEdgeCursor != null) {
            this.moveEdgeCursor(this.rowEdgeCursor, this.rowLevelIndexs, this.rowCursorObjs, levels, keyValues);
        }
        if (this.columnEdgeCursor != null) {
            this.moveEdgeCursor(this.columnEdgeCursor, this.columnLevelIndexs, this.columnCursorObjs, levels, keyValues);
        }
        if (this.pageEdgeCursor != null) {
            this.moveEdgeCursor(this.pageEdgeCursor, this.pageLevelIndexs, this.pageCursorObjs, levels, keyValues);
        }
        return true;
    }

    private ComparableObject[] fetcheObjects(EdgeCursor edgeCursor, List edgeLevels) throws OLAPException {
        ArrayList<ComparableObject> objList = new ArrayList<ComparableObject>();
        if (!edgeCursor.first()) {
            return new ComparableObject[0];
        }
        Object[] cursorValues = this.getCursorValues(edgeCursor, edgeLevels);
        objList.add(new ComparableObject(cursorValues, edgeCursor.getPosition()));
        while (edgeCursor.next()) {
            cursorValues = this.getCursorValues(edgeCursor, edgeLevels);
            objList.add(new ComparableObject(cursorValues, edgeCursor.getPosition()));
        }
        Object[] objArray = objList.toArray(new ComparableObject[0]);
        Arrays.sort(objArray);
        return objArray;
    }

    private boolean moveEdgeCursor(EdgeCursor cursor, int[] levelIndexs, ComparableObject[] cursorObjs, DimLevel[] levels, Object[] keyValues) throws OLAPException {
        Object[] cursorkeyValues = new Object[levelIndexs.length];
        int i = 0;
        while (i < cursorkeyValues.length) {
            cursorkeyValues[i] = keyValues[levelIndexs[i]];
            ++i;
        }
        int index = Arrays.binarySearch(cursorObjs, new ComparableObject(cursorkeyValues, 0L));
        if (index < 0) {
            return false;
        }
        cursor.setPosition(cursorObjs[index].getIndex());
        return true;
    }

    private Object[] getCursorValues(EdgeCursor cursor, List edgeLevels) throws OLAPException {
        List dimCursors = cursor.getDimensionCursor();
        Object[] cursorValue = new Object[edgeLevels.size()];
        int i = 0;
        while (i < edgeLevels.size()) {
            DimensionCursor dimCursor = (DimensionCursor)dimCursors.get(i);
            DimLevel level = (DimLevel)edgeLevels.get(i);
            cursorValue[i] = dimCursor.getObject(level.getLevelName());
            ++i;
        }
        return cursorValue;
    }

    private Map getCurrentValueOnEdge(String aggrName) throws OLAPException {
        Object value;
        DimensionCursor cursor;
        DimLevel level;
        if (!this.dimensionPrepared) {
            this.prepareDimensionCursor();
            this.dimensionPrepared = true;
        }
        Relationship relation = (Relationship)this.relationMap.get(aggrName);
        List pageLevelList = relation.getLevelListOnPage();
        List columnLevelList = relation.getLevelListOnColumn();
        List rowLevelList = relation.getLevelListOnRow();
        HashMap<DimLevel, Object> valueMap = new HashMap<DimLevel, Object>();
        if (columnLevelList.isEmpty() && rowLevelList.isEmpty() && pageLevelList.isEmpty()) {
            return null;
        }
        int index = 0;
        while (index < pageLevelList.size()) {
            level = (DimLevel)pageLevelList.get(index);
            cursor = (DimensionCursor)this.dimensionCursorMap.get(UniqueNamingUtil.getUniqueName(level.getDimensionName(), level.getLevelName()));
            value = cursor.getObject(level.getLevelName());
            valueMap.put(level, value);
            ++index;
        }
        int i = 0;
        while (i < columnLevelList.size()) {
            level = (DimLevel)columnLevelList.get(i);
            cursor = (DimensionCursor)this.dimensionCursorMap.get(UniqueNamingUtil.getUniqueName(level.getDimensionName(), level.getLevelName()));
            value = cursor.getObject(level.getLevelName());
            valueMap.put(level, value);
            ++i;
        }
        i = 0;
        while (i < rowLevelList.size()) {
            level = (DimLevel)rowLevelList.get(i);
            cursor = (DimensionCursor)this.dimensionCursorMap.get(UniqueNamingUtil.getUniqueName(level.getDimensionName(), level.getLevelName()));
            value = cursor.getObject(level.getLevelName());
            valueMap.put(level, value);
            ++i;
        }
        return valueMap;
    }

    /*
     * Unable to fully structure code
     */
    private boolean findValueMatcherOneByOne(IAggregationResultSet rs, List levelList, Map valueMap, int aggrIndex) throws IOException {
        position = 0;
        if (rs.length() > 0 && !levelList.isEmpty()) ** GOTO lbl23
        return true;
lbl-1000:
        // 1 sources

        {
            rs.seek(position);
            match = true;
            i = 0;
            while (i < levelList.size()) {
                level = (DimLevel)levelList.get(i);
                value1 = valueMap.get(level);
                value2 = null;
                index = rs.getLevelIndex(level);
                keyValues = rs.getLevelKeyValue(index);
                if (keyValues != null) {
                    value2 = keyValues[rs.getLevelKeyColCount(index) - 1];
                }
                if (!(value1 == value2 || value1 != null && value2 != null && value1.equals(value2))) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (match) {
                return true;
            }
            ++position;
lbl23:
            // 2 sources

            ** while (position < rs.length())
        }
lbl24:
        // 1 sources

        return false;
    }

    private boolean findValueMatcher(IAggregationResultSet rs, List levelList, Map valueMap, int aggrIndex) {
        if (levelList.isEmpty()) {
            return true;
        }
        int start = 0;
        int state = 0;
        boolean find = false;
        this.currentPosition[aggrIndex] = rs.getPosition();
        while (start < levelList.size()) {
            int direction;
            int compare;
            int sortType;
            DimLevel level = (DimLevel)levelList.get(start);
            Object value1 = valueMap.get(level);
            Object value2 = null;
            int index = rs.getLevelIndex(level);
            Object[] keyValues = rs.getLevelKeyValue(index);
            if (keyValues != null) {
                value2 = keyValues[rs.getLevelKeyColCount(index) - 1];
            }
            int n = (sortType = rs.getSortType(index) == 1 ? -1 : 1) * (compare = AggregationAccessor.compare(value1, value2)) < 0 ? -1 : (direction = compare == 0 ? 0 : 1);
            if (direction < 0 && this.currentPosition[aggrIndex] > 0 && (state == 0 || state == direction)) {
                state = direction;
                try {
                    int n2 = aggrIndex;
                    int n3 = this.currentPosition[n2] - 1;
                    this.currentPosition[n2] = n3;
                    rs.seek(n3);
                }
                catch (IOException iOException) {
                    find = false;
                }
                start = 0;
                continue;
            }
            if (direction > 0 && this.currentPosition[aggrIndex] < rs.length() - 1 && (state == 0 || state == direction)) {
                state = direction;
                try {
                    int n4 = aggrIndex;
                    int n5 = this.currentPosition[n4] + 1;
                    this.currentPosition[n4] = n5;
                    rs.seek(n5);
                }
                catch (IOException iOException) {
                    find = false;
                }
                start = 0;
                continue;
            }
            if (direction == 0) {
                if (start == levelList.size() - 1) {
                    find = true;
                    break;
                }
                ++start;
                continue;
            }
            if (this.currentPosition[aggrIndex] < 0 || this.currentPosition[aggrIndex] >= rs.length()) {
                return false;
            }
            return false;
        }
        return find;
    }

    static int compare(Object value1, Object value2) {
        if (value1 == value2) {
            return 0;
        }
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        if (value1 instanceof Comparable) {
            return ((Comparable)value1).compareTo(value2);
        }
        return value1.toString().compareTo(value2.toString());
    }
}

