/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.IComputedMeasureHelper;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.impl.query.ComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.util.FacttableMeasureJSObjectPopulator;
import org.eclipse.birt.data.engine.olap.util.filter.IFacttableRow;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

public class ComputedMeasureHelper
implements IComputedMeasureHelper {
    private Scriptable scope;
    private FacttableMeasureJSObjectPopulator populator;
    private MeasureInfo[] measureInfos;
    private Map exprMap = new HashMap();
    private ScriptContext cx;

    public ComputedMeasureHelper(Scriptable scope, ScriptContext cx, List computedColumns) throws DataException {
        this.scope = scope;
        this.cx = cx;
        this.measureInfos = new MeasureInfo[computedColumns.size()];
        int i = 0;
        while (i < this.measureInfos.length) {
            ComputedMeasureDefinition ccd = (ComputedMeasureDefinition)computedColumns.get(i);
            this.measureInfos[i] = new MeasureInfo(ccd.getName(), ccd.getDataType());
            this.exprMap.put(ccd.getName(), ccd.getExpression());
            ++i;
        }
        this.populator = new FacttableMeasureJSObjectPopulator(scope, this.exprMap, this.cx);
        this.populator.doInit();
    }

    public Object[] computeMeasureValues(IFacttableRow factTableRow) throws DataException {
        this.populator.setData(factTableRow);
        Object[] result = new Object[this.measureInfos.length];
        int i = 0;
        while (i < this.measureInfos.length) {
            try {
                result[i] = ScriptEvalUtil.evalExpr((IBaseExpression)this.exprMap.get(this.measureInfos[i].getMeasureName()), this.cx.newContext(this.scope), ScriptExpression.defaultID, 0);
            }
            catch (Exception exception) {
                result[i] = null;
            }
            ++i;
        }
        return result;
    }

    public MeasureInfo[] getAllComputedMeasureInfos() {
        return this.measureInfos;
    }

    public void cleanUp() {
        this.populator.cleanUp();
    }
}

