/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.bidi.utils.core;

import org.eclipse.birt.report.data.bidi.utils.core.BidiConstants;

public class BidiFormat {
    private static final char ORDERING_SCHEME_LOGICAL_CODE = 'I';
    private static final char ORDERING_SCHEME_VISUAL_CODE = 'V';
    protected static final char TEXT_DIRECTION_LTR_CODE = 'L';
    protected static final char TEXT_DIRECTION_RTL_CODE = 'R';
    private static final char TEXT_DIRECTION_CONTEXTUALLTR_CODE = 'C';
    private static final char TEXT_DIRECTION_CONTEXTUALRTL_CODE = 'D';
    private static final char SYMSWAPP_YES = 'Y';
    private static final char SYMSWAPP_NO = 'N';
    private static final char SHAPING_NOMINAL_CODE = 'N';
    private static final char SHAPING_SHAPED_CODE = 'S';
    private static final char NUMSHAPING_NOMINAL_CODE = 'N';
    private static final char NUMSHAPING_NATIONAL_CODE = 'H';
    private static final char NUMSHAPING_CONTEXTUAL_CODE = 'C';
    private static final int ORDERING_SCHEME_INDX = 0;
    protected static final int TEXT_DIRECTION_INDX = 1;
    protected static final int SYM_SWAP_INDX = 2;
    private static final int TEXT_SHAPING_INDX = 3;
    private static final int NUMERAL_SHAPING_INDX = 4;
    private static final int MAX_INDX = 5;
    private static final String VALID_FORMAT = "[IViv][LRCDlrcd][YNyn][NSns][NHCnhcp]";
    private String orderingScheme;
    private String textDirection;
    private String numeralShaping;
    private String textShaping;
    private boolean symSwap;

    public BidiFormat(String orderingScheme, String textDirection, boolean symSwap, String textShaping, String numeralShaping) {
        this.orderingScheme = orderingScheme;
        this.textDirection = textDirection;
        this.symSwap = symSwap;
        this.textShaping = textShaping;
        this.numeralShaping = numeralShaping;
    }

    public BidiFormat(String bidiFormatString) {
        if (!BidiFormat.isValidBidiFormat(bidiFormatString)) {
            bidiFormatString = "ILYNN";
        }
        bidiFormatString = bidiFormatString.toUpperCase();
        this.orderingScheme = BidiFormat.getOrderingSchemeFromStr(bidiFormatString);
        this.textDirection = BidiFormat.getTextDirectionFromStr(bidiFormatString);
        this.symSwap = BidiFormat.getSymSwapFromStr(bidiFormatString);
        this.textShaping = BidiFormat.getTextShapingFromStr(bidiFormatString);
        this.numeralShaping = BidiFormat.getNumeralShapingFromStr(bidiFormatString);
    }

    public String getOrderingScheme() {
        return this.orderingScheme;
    }

    public String getTextDirection() {
        return this.textDirection;
    }

    public boolean getSymSwap() {
        return this.symSwap;
    }

    public String getTextShaping() {
        return this.textShaping;
    }

    public String getNumeralShaping() {
        return this.numeralShaping;
    }

    public BidiFormat getBiDiFormat() {
        return this;
    }

    public String getBiDiFormatString() {
        StringBuffer buf = new StringBuffer(6);
        if (this.orderingScheme.equals(BidiConstants.ORDERING_SCHEME_LOGICAL)) {
            buf.append('I');
        } else if (this.orderingScheme.equals(BidiConstants.ORDERING_SCHEME_VISUAL)) {
            buf.append('V');
        }
        if (this.textDirection.equals(BidiConstants.TEXT_DIRECTION_LTR)) {
            buf.append('L');
        } else if (this.textDirection.equals(BidiConstants.TEXT_DIRECTION_RTL)) {
            buf.append('R');
        } else if (this.textDirection.equals(BidiConstants.TEXT_DIRECTION_CONTEXTLTR)) {
            buf.append('C');
        } else if (this.textDirection.equals(BidiConstants.TEXT_DIRECTION_CONTEXTRTL)) {
            buf.append('D');
        }
        if (this.symSwap) {
            buf.append('Y');
        } else {
            buf.append('N');
        }
        if (this.textShaping.equals(BidiConstants.SHAPING_NOMINAL)) {
            buf.append('N');
        } else if (this.textShaping.equals(BidiConstants.SHAPING_SHAPED)) {
            buf.append('S');
        }
        if (this.numeralShaping.equals(BidiConstants.NUMSHAPING_NOMINAL)) {
            buf.append('N');
        } else if (this.numeralShaping.equals(BidiConstants.NUMSHAPING_NATIONAL)) {
            buf.append('H');
        } else if (this.numeralShaping.equals(BidiConstants.NUMSHAPING_CONTEXT)) {
            buf.append('C');
        }
        if (buf.length() < 5) {
            return "ILYNN";
        }
        return String.valueOf(buf);
    }

    private static String getOrderingSchemeFromStr(String bidiFormatStr) {
        char code = bidiFormatStr.charAt(0);
        if (code == 'I') {
            return BidiConstants.ORDERING_SCHEME_LOGICAL;
        }
        return BidiConstants.ORDERING_SCHEME_VISUAL;
    }

    public static String getTextDirectionFromStr(String bidiFormatStr) {
        char code = bidiFormatStr.charAt(1);
        if (code == 'R') {
            return BidiConstants.TEXT_DIRECTION_RTL;
        }
        if (code == 'C') {
            return BidiConstants.TEXT_DIRECTION_CONTEXTLTR;
        }
        if (code == 'D') {
            return BidiConstants.TEXT_DIRECTION_CONTEXTRTL;
        }
        return BidiConstants.TEXT_DIRECTION_LTR;
    }

    private static boolean getSymSwapFromStr(String bidiFormatStr) {
        char code = bidiFormatStr.charAt(2);
        return code == 'Y';
    }

    protected static String getTextShapingFromStr(String bidiFormatStr) {
        char code = bidiFormatStr.charAt(3);
        if (code == 'N') {
            return BidiConstants.SHAPING_NOMINAL;
        }
        return BidiConstants.SHAPING_SHAPED;
    }

    protected static String getNumeralShapingFromStr(String bidiFormatStr) {
        char code = bidiFormatStr.charAt(4);
        if (code == 'C') {
            return BidiConstants.NUMSHAPING_CONTEXT;
        }
        if (code == 'H') {
            return BidiConstants.NUMSHAPING_NATIONAL;
        }
        return BidiConstants.NUMSHAPING_NOMINAL;
    }

    public void update(String fieldName, Object value) {
        if ("bidiFormatOrientation".equals(fieldName) || "bidiFormatContentOrientation".equals(fieldName) || "bidiFormatMetadataOrientation".equals(fieldName)) {
            this.updateTextDirection(value.toString());
        } else if ("bidiFormatOrderingScheme".equals(fieldName) || "bidiFormatContentOrderingScheme".equals(fieldName) || "bidiFormatMetadataOrderingScheme".equals(fieldName)) {
            this.updateOrderingScheme(value.toString());
        } else if ("bidiFormatSymSwap".equals(fieldName) || "bidiFormatContentSymSwap".equals(fieldName) || "bidiFormatMetadataSymSwap".equals(fieldName)) {
            this.updateSymSwap(value);
        } else if ("bidiFormatTextShaping".equals(fieldName) || "bidiFormatContentTextShaping".equals(fieldName) || "bidiFormatMetadataTextShaping".equals(fieldName)) {
            this.updateTextShaping(value.toString());
        } else {
            this.updateNumericShaping(value.toString());
        }
    }

    private void updateTextDirection(String value) {
        if (BidiConstants.TEXT_DIRECTION_LTR.equals(value) || BidiConstants.TEXT_DIRECTION_RTL.equals(value) || BidiConstants.TEXT_DIRECTION_CONTEXTLTR.equals(value) || BidiConstants.TEXT_DIRECTION_CONTEXTRTL.equals(value)) {
            this.textDirection = value;
        }
    }

    private void updateOrderingScheme(String value) {
        if (BidiConstants.ORDERING_SCHEME_LOGICAL.equals(value) || BidiConstants.ORDERING_SCHEME_VISUAL.equals(value)) {
            this.orderingScheme = value;
        }
    }

    private void updateSymSwap(Object value) {
        this.symSwap = Boolean.valueOf(value.toString());
    }

    private void updateTextShaping(String value) {
        if (BidiConstants.SHAPING_NOMINAL.equals(value) || BidiConstants.SHAPING_SHAPED.equals(value)) {
            this.textShaping = value;
        }
    }

    private void updateNumericShaping(String value) {
        if (BidiConstants.NUMSHAPING_CONTEXT.equals(value) || BidiConstants.NUMSHAPING_NATIONAL.equals(value) || BidiConstants.NUMSHAPING_NOMINAL.equals(value)) {
            this.numeralShaping = value;
        }
    }

    public static boolean isValidBidiFormat(String str) {
        return str != null && str.matches(VALID_FORMAT);
    }

    public boolean equals(BidiFormat biDiFormat) {
        return this.numeralShaping.equals(biDiFormat.numeralShaping) && this.orderingScheme.equals(biDiFormat.orderingScheme) && this.textDirection.equals(biDiFormat.textDirection) && this.textShaping.equals(biDiFormat.textShaping) && this.symSwap == biDiFormat.symSwap;
    }

    public String toString() {
        return this.getBiDiFormatString();
    }
}

