/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value;

import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class ListValue
extends Value
implements CSSValueList {
    protected int length;
    protected CSSValue[] items = new CSSValue[5];
    protected char separator = (char)44;

    public ListValue() {
    }

    public ListValue(char s) {
        this.separator = s;
    }

    public char getSeparatorChar() {
        return this.separator;
    }

    public short getCssValueType() {
        return 2;
    }

    public String getCssText() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.length) {
            Value value = (Value)this.items[i];
            if (value != null) {
                short valueType = value.getCssValueType();
                if (valueType == 1) {
                    switch (value.getPrimitiveType()) {
                        case 19: {
                            sb.append(this.encodeString(value.getStringValue()));
                            break;
                        }
                        case 20: {
                            sb.append("url('");
                            sb.append(value.getStringValue());
                            sb.append("')");
                            break;
                        }
                        default: {
                            sb.append(value.getCssText());
                            break;
                        }
                    }
                } else {
                    sb.append(value.getCssText());
                }
                sb.append(this.separator);
            }
            ++i;
        }
        if (sb.length() != 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    protected String encodeString(String value) {
        char[] chars = value.toCharArray();
        boolean needQuote = false;
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '\"': {
                    return String.valueOf('\'') + value + '\'';
                }
                case '\'': {
                    return String.valueOf('\"') + value + '\"';
                }
                case ' ': 
                case '!': 
                case '(': 
                case ')': 
                case ',': 
                case '.': 
                case ';': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '}': {
                    needQuote = true;
                }
            }
            ++i;
        }
        if (needQuote) {
            return String.valueOf('\"') + value + '\"';
        }
        return value;
    }

    public int getLength() throws DOMException {
        return this.length;
    }

    public CSSValue item(int index) throws DOMException {
        return this.items[index];
    }

    public String toString() {
        return this.getCssText();
    }

    public void append(CSSValue v) {
        if (this.length == this.items.length) {
            CSSValue[] t = new CSSValue[this.length * 2];
            int i = 0;
            while (i < this.length) {
                t[i] = this.items[i];
                ++i;
            }
            this.items = t;
        }
        this.items[this.length++] = v;
    }

    public boolean equals(Object value) {
        if (value instanceof ListValue) {
            ListValue l = (ListValue)value;
            if (l.length == this.length) {
                int i = 0;
                while (i < this.length) {
                    CSSValue i1 = this.items[i];
                    CSSValue i2 = l.items[i];
                    if (!(i1 == i2 || i1 != null && i1.equals(i2))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }
}

