/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html.buffer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.engine.content.IContent;

public class PageHintGenerator {
    protected IContent startContent = null;
    protected IContent currentContent = null;
    protected ArrayList pageHint = new ArrayList();

    public void start(IContent content, boolean isFirst) {
        if (this.startContent == null) {
            if (isFirst) {
                this.startContent = content;
                this.currentContent = content;
            }
        } else if (!isFirst) {
            if (this.currentContent != null) {
                this.pageHint.add(new IContent[]{this.startContent, this.currentContent});
                this.startContent = null;
                this.currentContent = null;
            }
        } else {
            this.currentContent = content;
        }
    }

    public void end(IContent content, boolean finished) {
        if (!finished && this.currentContent != null) {
            this.pageHint.add(new IContent[]{this.startContent, this.currentContent});
            this.startContent = null;
            this.currentContent = null;
        }
    }

    public void reset() {
        this.startContent = null;
        this.currentContent = null;
        this.pageHint.clear();
    }

    public List getPageHint() {
        ArrayList<IContent[]> hint = new ArrayList<IContent[]>();
        hint.addAll(this.pageHint);
        if (this.startContent != null && this.currentContent != null) {
            hint.add(new IContent[]{this.startContent, this.currentContent});
        }
        return hint;
    }
}

