/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.RowBandAction;
import org.eclipse.birt.report.model.api.RowBandAdapter;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.RowOperationParameters;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class RowBandInsertAction
extends RowBandAction {
    public RowBandInsertAction(RowBandAdapter adapter) {
        super(adapter);
    }

    protected boolean canInsert(RowOperationParameters parameters) {
        if (this.adapter.hasParent()) {
            return false;
        }
        int destIndex = parameters.getDestIndex();
        SlotHandle slotHandle = this.getSlotHandle(parameters);
        if (slotHandle == null) {
            return false;
        }
        if (destIndex < 0 || destIndex > slotHandle.getCount()) {
            return false;
        }
        if (destIndex == 0) {
            return true;
        }
        RowHandle destHandle = (RowHandle)slotHandle.get(destIndex - 1);
        return !this.containsRowSpan(destHandle) && this.isRectangleArea(destHandle);
    }

    protected void doInsert(RowOperationParameters parameters) throws SemanticException {
        ElementFactory factory = new ElementFactory(this.adapter.getModule());
        RowHandle rowHandle = factory.newTableRow(this.adapter.getColumnCount());
        if (!this.canInsert(parameters)) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{this.adapter.getElementHandle().getName()}, "Error.SemanticError.ROW_INSERT_FORBIDDEN");
        }
        int destIndex = parameters.getDestIndex();
        SlotHandle slotHandle = this.getSlotHandle(parameters);
        ActivityStack stack = this.adapter.getModule().getActivityStack();
        try {
            stack.startTrans(CommandLabelFactory.getCommandLabel("Message.InsertRow"));
            slotHandle.paste(rowHandle, destIndex);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }
}

