/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class IncludedCssStyleSheet
extends Structure {
    public static final String INCLUDED_CSS_STRUCT = "IncludedCssStyleSheet";
    public static final String FILE_NAME_MEMBER = "fileName";
    public static final String EXTERNAL_CSS_URI_MEMBER = "externalCssURI";
    public static final String USE_EXTERNAL_CSS = "useExternalCss";
    protected String fileName;
    protected String externalCssURI;
    protected boolean useExternalCss;

    public String getStructName() {
        return INCLUDED_CSS_STRUCT;
    }

    protected Object getIntrinsicProperty(String propName) {
        if (FILE_NAME_MEMBER.equals(propName)) {
            return this.fileName;
        }
        if (EXTERNAL_CSS_URI_MEMBER.equals(propName)) {
            return this.externalCssURI;
        }
        if (USE_EXTERNAL_CSS.equals(propName)) {
            return this.useExternalCss;
        }
        assert (false);
        return null;
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if (FILE_NAME_MEMBER.equals(propName)) {
            this.fileName = (String)value;
        } else if (EXTERNAL_CSS_URI_MEMBER.equals(propName)) {
            this.externalCssURI = (String)value;
        } else if (USE_EXTERNAL_CSS.equals(propName)) {
            this.useExternalCss = (Boolean)value;
        } else assert (false);
    }

    public List validate(Module module, DesignElement element) {
        PropertyDefn defn;
        String externalCssURI;
        ArrayList<PropertyValueException> list = new ArrayList<PropertyValueException>();
        PropertyDefn memberDefn = (PropertyDefn)this.getDefn().getMember(FILE_NAME_MEMBER);
        String fileName = (String)this.getProperty(module, memberDefn);
        if (StringUtil.isBlank(fileName) && (externalCssURI = (String)this.getProperty(module, defn = (PropertyDefn)this.getDefn().getMember(EXTERNAL_CSS_URI_MEMBER))) == null && !this.useExternalCss) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(FILE_NAME_MEMBER), (Object)fileName, "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String theFileName) {
        this.fileName = theFileName;
    }

    public String getExternalCssURI() {
        return this.externalCssURI;
    }

    public void setExternalCssURI(String externalCssURI) {
        this.externalCssURI = externalCssURI;
    }

    public boolean isUseExternalCss() {
        return this.useExternalCss;
    }

    public void setUseExternalCss(boolean useExternalCss) {
        this.useExternalCss = useExternalCss;
    }

    protected StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new IncludedCssStyleSheetHandle(valueHandle, index);
    }
}

