/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.ContainerContextProvider;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.IContainerDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefnSet;
import org.eclipse.birt.report.model.metadata.SlotDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContainerContext {
    protected final DesignElement container;
    protected final int containerSlotID;
    protected final String containerProp;
    private final boolean isSlot;
    private final SlotDefn slotDefn;

    public ContainerContext(DesignElement theContainer, int slotID) {
        if (theContainer == null) {
            throw new IllegalArgumentException("The container of ContainerInfo should not be null");
        }
        this.container = theContainer;
        this.containerSlotID = slotID;
        IElementDefn tmpDefn = this.container.getDefn();
        assert (tmpDefn != null);
        this.slotDefn = (SlotDefn)tmpDefn.getSlot(this.containerSlotID);
        this.isSlot = true;
        this.containerProp = null;
    }

    public ContainerContext(DesignElement theContainer, String propName) {
        if (theContainer == null || propName == null) {
            throw new IllegalArgumentException("The container and property name should not be null");
        }
        this.container = theContainer;
        this.containerProp = propName;
        if (this.container.getPropertyDefn(propName) == null) {
            throw new IllegalArgumentException("The property \"" + propName + "\" is not defined");
        }
        this.isSlot = false;
        this.containerSlotID = -1;
        this.slotDefn = null;
    }

    public String getContainerIdentifier() {
        if (this.container.getPropertyDefn(this.containerProp) != null) {
            return this.containerProp;
        }
        return this.container.getDefn().getSlot(this.containerSlotID).getName();
    }

    public DesignElement getElement() {
        return this.container;
    }

    public int getSlotID() {
        return this.containerSlotID;
    }

    public String getPropertyName() {
        if (!this.isSlot) {
            return this.containerProp;
        }
        return null;
    }

    public IContainerDefn getContainerDefn() {
        if (this.isSlot) {
            return this.container.getDefn().getSlot(this.containerSlotID);
        }
        ElementPropertyDefn defn = this.container.getPropertyDefn(this.containerProp);
        if (defn != null && defn.isElementType()) {
            return defn;
        }
        return null;
    }

    public int indexOf(Module module, DesignElement content) {
        if (this.isSlot) {
            return this.container.getSlot(this.containerSlotID).findPosn(content);
        }
        Object value = this.container.getProperty(module, this.containerProp);
        if (value == content) {
            return 0;
        }
        if (value instanceof List) {
            return ((List)value).indexOf(content);
        }
        return -1;
    }

    public int indexOf(DesignElement content) {
        return this.indexOf(this.container.getRoot(), content);
    }

    public boolean isManagedByNameSpace() {
        IElementDefn variableElementDefn;
        ElementPropertyDefn propDefn;
        if (this.container.getRoot() == null) {
            return false;
        }
        if (this.containerProp != null && (propDefn = this.container.getPropertyDefn(this.containerProp)).canContain(variableElementDefn = MetaDataDictionary.getInstance().getElement("VariableElement")) && !(this.container instanceof ReportDesign)) {
            return false;
        }
        ContainerContext containerInfo = this;
        while (containerInfo != null) {
            SlotDefn slotInfo;
            if (containerInfo.isSlot && (slotInfo = (SlotDefn)containerInfo.container.getDefn().getSlot(containerInfo.containerSlotID)) != null && !slotInfo.isManagedByNameSpace()) {
                return false;
            }
            containerInfo = containerInfo.container.getContainerInfo();
        }
        DesignElement focusContainer = this.container;
        while (focusContainer != null) {
            if (focusContainer.getDynamicExtendsElement(focusContainer.getRoot()) != null) {
                return false;
            }
            focusContainer = focusContainer.getContainer();
        }
        return true;
    }

    public String getSelector() {
        if (this.slotDefn == null) {
            return null;
        }
        String slotSelector = this.slotDefn.getSelector();
        if (StringUtil.isBlank(slotSelector)) {
            return null;
        }
        if (this.container instanceof GroupElement) {
            int depth = ((GroupElement)this.container).getGroupLevel();
            if (depth > 9) {
                depth = 9;
            }
            return String.valueOf(slotSelector) + "-" + Integer.toString(depth);
        }
        return slotSelector;
    }

    public boolean canContainInRom(IElementDefn defn) {
        if (defn == null) {
            return false;
        }
        return this.getContainerDefn() == null ? false : this.getContainerDefn().canContain(defn);
    }

    public boolean isContainerMultipleCardinality() {
        IContainerDefn defn = this.getContainerDefn();
        if (defn instanceof PropertyDefn) {
            return ((PropertyDefn)defn).isList();
        }
        if (defn instanceof SlotDefn) {
            return ((SlotDefn)defn).isMultipleCardinality();
        }
        return false;
    }

    public List<DesignElement> getContents(Module module) {
        if (this.getContainerDefn() == null) {
            return Collections.emptyList();
        }
        if (this.isSlot) {
            return this.container.getSlot(this.containerSlotID).getContents();
        }
        ElementPropertyDefn defn = this.container.getPropertyDefn(this.containerProp);
        Object value = null;
        value = this.container instanceof Dimension ? this.container.getProperty(module, defn) : this.container.getLocalProperty(module, defn);
        if (defn == null || value == null) {
            return Collections.emptyList();
        }
        if (defn.isList()) {
            return (List)value;
        }
        ArrayList<DesignElement> result = new ArrayList<DesignElement>();
        result.add((DesignElement)value);
        return result;
    }

    public DesignElement getContent(Module module, int posn) {
        if (this.isSlot) {
            return this.container.getSlot(this.containerSlotID).getContent(posn);
        }
        return this.getContent(module, this.containerProp, posn);
    }

    private DesignElement getContent(Module module, String propName, int posn) {
        ElementPropertyDefn defn = this.container.getPropertyDefn(propName);
        if (defn == null) {
            return null;
        }
        if (defn.isList()) {
            List<Object> value = this.container.getListProperty(module, propName);
            return (DesignElement)(value == null ? null : value.get(posn));
        }
        return (DesignElement)(posn == 0 ? this.container.getProperty(module, defn) : null);
    }

    public int getContentCount(Module module) {
        if (this.isSlot) {
            return this.container.getSlot(this.containerSlotID) == null ? 0 : this.container.getSlot(this.containerSlotID).getCount();
        }
        return this.getContentCount(module, this.containerProp);
    }

    private int getContentCount(Module module, String propName) {
        ElementPropertyDefn defn = this.container.getPropertyDefn(propName);
        if (defn == null) {
            return 0;
        }
        if (defn.isList()) {
            List<Object> value = this.container.getListProperty(module, propName);
            return value == null ? 0 : value.size();
        }
        return this.container.getProperty(module, defn) == null ? 0 : 1;
    }

    public void add(Module module, DesignElement content, int posn) {
        if (this.isSlot) {
            this.container.add(content, this.containerSlotID, posn);
        } else {
            this.container.add(module, content, this.containerProp, posn);
        }
    }

    public void add(Module module, DesignElement content) {
        if (this.isSlot) {
            this.container.add(content, this.containerSlotID);
        } else {
            this.container.add(module, content, this.containerProp);
        }
    }

    public void remove(Module module, DesignElement content) {
        if (this.isSlot) {
            this.container.remove(content, this.containerSlotID);
        } else {
            this.container.remove(module, content, this.containerProp);
        }
    }

    public boolean contains(Module module, DesignElement content) {
        return this.indexOf(module, content) != -1;
    }

    public SemanticTriggerDefnSet getTriggerSetForContainerDefn() {
        IContainerDefn defn = this.getContainerDefn();
        if (defn instanceof PropertyDefn) {
            return ((PropertyDefn)defn).getTriggerDefnSet();
        }
        if (defn instanceof SlotDefn) {
            return ((SlotDefn)defn).getTriggerDefnSet();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContainerContext)) {
            return false;
        }
        ContainerContext infoObj = (ContainerContext)obj;
        if (this.container.equals(infoObj.container)) {
            if (this.isSlot && infoObj.isSlot && infoObj.containerSlotID == this.containerSlotID) {
                return true;
            }
            if (!this.isSlot && !infoObj.isSlot && this.containerProp.equals(infoObj.containerProp)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.container.hashCode() * 31;
        return hashCode += this.isSlot ? this.containerSlotID : this.containerProp.hashCode();
    }

    public boolean canContain(Module module, DesignElement content) {
        return new ContainerContextProvider(this).canContain(module, content);
    }

    public boolean canContain(Module module, String type) {
        return new ContainerContextProvider(this).canContain(module, type);
    }

    public final boolean canContain(Module module, IElementDefn defn) {
        return new ContainerContextProvider(this).canContain(module, defn);
    }

    public final List<SemanticException> checkContainmentContext(Module module, DesignElement element) {
        return new ContainerContextProvider(this).checkContainmentContext(module, element);
    }

    public void move(Module module, int from, int to) {
        if (this.isSlot) {
            this.container.getSlot(this.containerSlotID).moveContent(from, to);
        } else {
            this.move(module, this.containerProp, from, to);
        }
    }

    private void move(Module module, String propName, int from, int to) {
        ElementPropertyDefn defn = this.container.getPropertyDefn(propName);
        assert (defn.isList() && defn.getTypeCode() == 23);
        List<Object> items = this.container.getListProperty(module, propName);
        assert (items != null);
        assert (from >= 0 && from < items.size());
        assert (to >= 0 && to < items.size());
        if (from == to) {
            return;
        }
        Object obj = items.remove(from);
        items.add(to, obj);
    }

    public void clearContents() {
        if (this.isSlot) {
            ContainerSlot slot = this.container.getSlot(this.containerSlotID);
            if (slot != null) {
                slot.clear();
            }
        } else {
            this.container.clearProperty(this.containerProp);
        }
    }

    public ContainerContext createContext(DesignElement newElement) {
        if (newElement.getDefn() != this.container.getDefn()) {
            return null;
        }
        ContainerContext newContext = null;
        newContext = this.isSlot ? new ContainerContext(newElement, this.containerSlotID) : new ContainerContext(newElement, this.containerProp);
        return newContext;
    }

    public boolean isROMSlot() {
        return this.isSlot;
    }

    public static boolean isValidContainerment(Module module, DesignElement containerElement, ReportItem item, DataSet dataSet, Cube cube) {
        if (dataSet != null || cube != null) {
            DesignElement container = containerElement;
            while (container != null) {
                if (container instanceof ReportItem) {
                    ReportItem containerItem = (ReportItem)container;
                    DataSet containerDataSet = (DataSet)containerItem.getDataSetElement(module);
                    Cube containerCube = (Cube)containerItem.getCubeElement(module);
                    if ((dataSet == null && containerDataSet == null || dataSet != null && dataSet == containerDataSet) && (cube == null && containerCube == null || cube != null && cube == containerCube)) {
                        container = container.getContainer();
                        continue;
                    }
                    if (containerItem.getProperty(module, "multiViews") != null) {
                        return false;
                    }
                }
                container = container.getContainer();
            }
        }
        return true;
    }
}

