/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IObjectDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;
import org.eclipse.birt.report.model.util.StructureContextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Structure
implements IStructure {
    private StructureContext context;

    public boolean equals(Object obj) {
        if (!(obj instanceof Structure)) {
            return false;
        }
        Structure struct = (Structure)obj;
        if (struct.getDefn() != this.getDefn()) {
            return false;
        }
        Iterator<IPropertyDefn> iter = this.getDefn().propertiesIterator();
        while (iter.hasNext()) {
            PropertyDefn defn = (PropertyDefn)iter.next();
            Object value = this.getLocalProperty(null, defn);
            if (!(value == null ? struct.getLocalProperty(null, defn) != null : !value.equals(struct.getLocalProperty(null, defn)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final IStructure copy() {
        try {
            Structure retValue = (Structure)this.clone();
            StructureContextUtil.setupStructureContext(retValue);
            retValue.context = null;
            return retValue;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    @Override
    public IStructureDefn getDefn() {
        return MetaDataDictionary.getInstance().getStructure(this.getStructName());
    }

    public IPropertyDefn getMemberDefn(String memberName) {
        return (PropertyDefn)this.getDefn().getMember(memberName);
    }

    @Override
    public IObjectDefn getObjectDefn() {
        return MetaDataDictionary.getInstance().getStructure(this.getStructName());
    }

    @Override
    public final Object getProperty(Module module, String memberName) {
        PropertyDefn prop = (PropertyDefn)this.getDefn().getMember(memberName);
        if (prop == null) {
            return null;
        }
        return this.getProperty(module, prop);
    }

    @Override
    public Object getProperty(Module module, PropertyDefn propDefn) {
        assert (propDefn != null);
        Object value = this.getLocalProperty(module, propDefn);
        if (value == null) {
            return propDefn.getDefault();
        }
        if (value instanceof ElementRefValue) {
            ElementRefValue refValue = (ElementRefValue)value;
            return ReferenceValueUtil.needTheNamespacePrefix(refValue, module);
        }
        return value;
    }

    @Override
    public Object getLocalProperty(Module module, PropertyDefn propDefn) {
        Object value = null;
        if (propDefn.isIntrinsic()) {
            value = this.getIntrinsicProperty(propDefn.getName());
        }
        if (propDefn.getTypeCode() == 15) {
            return ReferenceValueUtil.resolveElementReference(this, module, (StructPropertyDefn)propDefn, value);
        }
        return value;
    }

    public Object getLocalProperty(Module module, String memberName) {
        PropertyDefn prop = (PropertyDefn)this.getDefn().getMember(memberName);
        if (prop == null) {
            return null;
        }
        return this.getLocalProperty(module, prop);
    }

    public final void setProperty(String propName, Object value) {
        PropertyDefn prop = (PropertyDefn)this.getDefn().getMember(propName);
        if (prop == null) {
            return;
        }
        this.setProperty(prop, value);
    }

    @Override
    public void setProperty(PropertyDefn prop, Object value) {
        Object updatedValue = this.getCompatibleValue(prop, value);
        this.updateReference(prop, updatedValue);
        this.setupContext(prop, updatedValue);
        if (prop.isIntrinsic()) {
            this.setIntrinsicProperty(prop.getName(), updatedValue);
        }
    }

    protected void updateReference(PropertyDefn prop, Object value) {
        if ((value instanceof ElementRefValue || value == null) && prop.getTypeCode() == 15) {
            ElementRefValue oldRef = (ElementRefValue)this.getLocalProperty(null, prop.getName());
            this.doUpdateReference(oldRef, (ElementRefValue)value, prop);
        }
    }

    protected void setupContext(PropertyDefn prop, Object value) {
        if (prop.getTypeCode() == 16) {
            if (prop.isList()) {
                if (value instanceof List) {
                    List listValue = (List)value;
                    for (Object item : listValue) {
                        Structure struct = (Structure)item;
                        struct.setContext(new StructureContext(this, prop, struct));
                    }
                }
            } else if (value instanceof Structure) {
                ((Structure)value).setContext(new StructureContext(this, prop, (Structure)value));
            }
        }
    }

    private void doUpdateReference(ElementRefValue oldRef, ElementRefValue newRef, PropertyDefn prop) {
        IReferencableElement target;
        String propName = prop.getName();
        if (oldRef != null && (target = oldRef.getTargetElement()) != null) {
            target.dropClient(this, propName);
        }
        if (newRef != null && (target = newRef.getTargetElement()) != null) {
            target.addClient(this, propName);
        }
    }

    protected abstract Object getIntrinsicProperty(String var1);

    protected abstract void setIntrinsicProperty(String var1, Object var2);

    public List<SemanticException> validate(Module module, DesignElement element) {
        return new ArrayList<SemanticException>();
    }

    public StructureHandle getHandle(SimpleValueHandle valueHandle, int index) {
        if (valueHandle == null || valueHandle.getListValue() == null) {
            return null;
        }
        if (index < 0 || index >= valueHandle.getListValue().size()) {
            return null;
        }
        return this.handle(valueHandle, index);
    }

    protected abstract StructureHandle handle(SimpleValueHandle var1, int var2);

    public StructureHandle getHandle(SimpleValueHandle valueHandle) {
        if (valueHandle == null || valueHandle.getListValue() == null) {
            return null;
        }
        int posn = valueHandle.getListValue().indexOf(this);
        if (posn == -1) {
            return null;
        }
        return this.handle(valueHandle, posn);
    }

    @Override
    public boolean isReferencable() {
        return false;
    }

    public String getReferencableProperty() {
        return null;
    }

    public StructureContext getContext() {
        return this.context;
    }

    public void setContext(StructureContext context) {
        if (context != null) assert (context.getStructure() == this);
        this.context = context;
    }

    @Override
    public boolean isDesignTime() {
        return true;
    }

    public DesignElement getElement() {
        if (this.context == null) {
            return null;
        }
        return this.context.getElement();
    }

    public String getStringProperty(Module module, String memberName) {
        Object tmpValue = this.getProperty(module, memberName);
        if (tmpValue instanceof Expression) {
            return ((Expression)tmpValue).getStringExpression();
        }
        if (tmpValue instanceof String) {
            return (String)tmpValue;
        }
        return null;
    }

    private static Expression convertObjectToExpression(Object value) {
        Expression expression = null;
        if (!(value instanceof Expression)) {
            expression = new Expression(value, null);
        }
        return expression;
    }

    private static List<Expression> convertListToExpressionList(List<String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<Expression> newList = new ArrayList<Expression>();
        if (!values.isEmpty()) {
            int i = 0;
            while (i < values.size()) {
                Expression tmpValue = Structure.convertObjectToExpression(values.get(i));
                if (tmpValue != null) {
                    newList.add(tmpValue);
                }
                ++i;
            }
        }
        return newList;
    }

    public void setExpressionProperty(String memberName, Expression value) {
        this.setProperty(memberName, (Object)value);
    }

    public Expression getExpressionProperty(String memberName) {
        return (Expression)this.getProperty(null, memberName);
    }

    protected Object getCompatibleValue(PropertyDefn propDefn, Object value) {
        if (propDefn.allowExpression()) {
            List tmpList;
            if (value != null && !(value instanceof List) && !(value instanceof Expression)) {
                return new Expression(value, null);
            }
            if (value != null && value instanceof List && !(tmpList = (List)value).isEmpty() && !(tmpList.get(0) instanceof Expression)) {
                return Structure.convertListToExpressionList(tmpList);
            }
        }
        return value;
    }

    protected void checkStringMember(String value, String memberName, DesignElement element, List errorList) {
        PropertyDefn propDefn = (PropertyDefn)this.getDefn().getMember(memberName);
        if (StringUtil.isBlank(value) && propDefn.isValueRequired()) {
            errorList.add(new PropertyValueException(element, propDefn, (Object)value, "Error.PropertyValueException.VALUE_REQUIRED"));
        }
    }
}

