/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CompatibleOdaDataSourcePropertyState
extends PropertyState {
    static final String JDBC_EXTENSION_ID = "org.eclipse.birt.report.data.oda.jdbc";
    static final String SAMPLE_DB_EXTENSION_ID = "org.eclipse.birt.report.data.oda.sampledb";
    static final String FLAT_FILE_EXTENSION_ID = "org.eclipse.birt.report.data.oda.flatfile";

    CompatibleOdaDataSourcePropertyState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
        assert (element instanceof OdaDataSource);
    }

    public void end() throws SAXException {
        if (CompatibleOdaDataSourcePropertyState.isOldOdaDriverProperty(this.name) || CompatibleOdaDataSourcePropertyState.isOdaDriverModelProperty(this.name)) {
            this.setProperty(this.name, this.text.toString());
            return;
        }
        if ("extensionName".equals(this.name) || "driverName".equals(this.name)) {
            String convertedValue = this.convertToExtensionID(this.text.toString());
            this.setProperty("extensionID", convertedValue);
            return;
        }
        super.end();
    }

    private String convertToExtensionID(String value) {
        if ("jdbc".equalsIgnoreCase(value)) {
            return JDBC_EXTENSION_ID;
        }
        if ("flatfile".equalsIgnoreCase(value)) {
            return FLAT_FILE_EXTENSION_ID;
        }
        if ("sampledb".equalsIgnoreCase(value)) {
            return SAMPLE_DB_EXTENSION_ID;
        }
        return null;
    }

    static String getNewOdaDriverProperty(String oldPropertyName) {
        if ("ODA:user".equalsIgnoreCase(oldPropertyName)) {
            return "odaUser";
        }
        if ("ODA:url".equalsIgnoreCase(oldPropertyName)) {
            return "odaURL";
        }
        if ("ODA:driver-class".equalsIgnoreCase(oldPropertyName)) {
            return "odaDriverClass";
        }
        if ("ODA:data-source".equalsIgnoreCase(oldPropertyName)) {
            return "odaDataSource";
        }
        if ("ODA:password".equalsIgnoreCase(oldPropertyName)) {
            return "odaPassword";
        }
        return oldPropertyName;
    }

    static boolean isOldOdaDriverProperty(String propertyName) {
        return !propertyName.equals(CompatibleOdaDataSourcePropertyState.getNewOdaDriverProperty(propertyName));
    }

    static boolean isOdaDriverModelProperty(String propertyName) {
        if ("odaUser".equalsIgnoreCase(propertyName)) {
            return true;
        }
        if ("odaURL".equalsIgnoreCase(propertyName)) {
            return true;
        }
        if ("odaDriverClass".equalsIgnoreCase(propertyName)) {
            return true;
        }
        if ("odaDataSource".equalsIgnoreCase(propertyName)) {
            return true;
        }
        return "odaPassword".equalsIgnoreCase(propertyName);
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        super.parseAttrs(attrs);
        if (CompatibleOdaDataSourcePropertyState.isOldOdaDriverProperty(this.name) || CompatibleOdaDataSourcePropertyState.isOdaDriverModelProperty(this.name)) {
            this.setProperty("extensionID", JDBC_EXTENSION_ID);
            this.name = CompatibleOdaDataSourcePropertyState.getNewOdaDriverProperty(this.name);
        }
    }
}

