/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.DoubleBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.DoubleIntPair;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.DoubleBags;
import org.eclipse.collections.impl.factory.primitive.DoubleSets;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableDoubleSingletonBag
implements ImmutableDoubleBag,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double element1;

    ImmutableDoubleSingletonBag(double element) {
        this.element1 = element;
    }

    public ImmutableDoubleBag newWith(double element) {
        return DoubleBags.immutable.with(new double[]{this.element1, element});
    }

    public ImmutableDoubleBag newWithout(double element) {
        return Double.compare(this.element1, element) == 0 ? DoubleBags.immutable.with() : this;
    }

    public ImmutableDoubleBag newWithAll(DoubleIterable elements) {
        return DoubleHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    public ImmutableDoubleBag newWithoutAll(DoubleIterable elements) {
        return elements.contains(this.element1) ? DoubleBags.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(double value) {
        return Double.compare(this.element1, value) == 0;
    }

    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (Double.compare(this.element1, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (Double.compare(this.element1, value) == 0) continue;
            return false;
        }
        return true;
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        procedure.value(this.element1);
    }

    public ImmutableDoubleBag select(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? DoubleBags.immutable.with(this.element1) : DoubleBags.immutable.empty();
    }

    public ImmutableDoubleBag selectByOccurrences(IntPredicate predicate) {
        return predicate.accept(1) ? DoubleBags.immutable.with(this.element1) : DoubleBags.immutable.empty();
    }

    public ImmutableDoubleSet selectUnique() {
        return DoubleSets.immutable.of(this.element1);
    }

    public ImmutableList<DoubleIntPair> topOccurrences(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        if (count == 0) {
            return Lists.immutable.empty();
        }
        return Lists.immutable.with((Object)PrimitiveTuples.pair(this.element1, 1));
    }

    public ImmutableList<DoubleIntPair> bottomOccurrences(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        if (count == 0) {
            return Lists.immutable.empty();
        }
        return Lists.immutable.with((Object)PrimitiveTuples.pair(this.element1, 1));
    }

    public ImmutableDoubleBag reject(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? DoubleBags.immutable.empty() : DoubleBags.immutable.with(this.element1);
    }

    public <V> ImmutableBag<V> collect(DoubleToObjectFunction<? extends V> function) {
        return HashBag.newBagWith(function.valueOf(this.element1)).toImmutable();
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newListWith(this.element1);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(double item) {
        return Double.compare(this.element1, item) == 0 ? 1 : 0;
    }

    public void forEachWithOccurrences(DoubleIntProcedure doubleIntProcedure) {
        doubleIntProcedure.value(this.element1, 1);
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public int count(DoublePredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return predicate.accept(this.element1);
    }

    public double sum() {
        return this.element1;
    }

    public double min() {
        return this.element1;
    }

    public double max() {
        return this.element1;
    }

    public double maxIfEmpty(double defaultValue) {
        return this.element1;
    }

    public double minIfEmpty(double defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public double[] toSortedArray() {
        return new double[]{this.element1};
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newListWith(this.element1);
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return predicate.accept(this.element1);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public RichIterable<DoubleIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.immutable.with((Object)this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleBag)) {
            return false;
        }
        DoubleBag bag = (DoubleBag)obj;
        if (bag.size() != 1) {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.element1) ^ Double.doubleToLongBits(this.element1) >>> 32) ^ 1;
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSetWith(this.element1);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBagWith(this.element1);
    }

    public ImmutableDoubleBag toImmutable() {
        return this;
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public double[] toArray() {
        return new double[]{this.element1};
    }

    public String toString() {
        return '[' + this.makeString() + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator((DoubleIterator)DoubleHashBag.newBagWith(this.element1).doubleIterator());
    }
}

