/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseIntIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;

final class ImmutableIntArrayList
implements ImmutableIntList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] items;

    private ImmutableIntArrayList(int[] newElements) {
        if (newElements.length <= 1) {
            throw new IllegalArgumentException("Use IntLists.immutable.with() to instantiate an optimized collection");
        }
        this.items = newElements;
    }

    public static ImmutableIntArrayList newList(IntIterable iterable) {
        return new ImmutableIntArrayList(iterable.toArray());
    }

    public static ImmutableIntArrayList newListWith(int ... elements) {
        int[] newArray = new int[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableIntArrayList(newArray);
    }

    public int get(int index) {
        return this.items[index];
    }

    public int getFirst() {
        return this.items[0];
    }

    public int getLast() {
        return this.items[this.items.length - 1];
    }

    public int indexOf(int value) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int value) {
        for (int i = this.items.length - 1; i >= 0; --i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public IntIterator intIterator() {
        return new InternalIntIterator();
    }

    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    public void each(IntProcedure procedure) {
        for (int item : this.items) {
            procedure.value(item);
        }
    }

    public void forEachWithIndex(IntIntProcedure procedure) {
        for (int i = 0; i < this.items.length; ++i) {
            procedure.value(this.items[i], i);
        }
    }

    public int count(IntPredicate predicate) {
        int count = 0;
        for (int item : this.items) {
            if (!predicate.accept(item)) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        for (int item : this.items) {
            if (!predicate.accept(item)) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        for (int item : this.items) {
            if (predicate.accept(item)) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public ImmutableIntList select(IntPredicate predicate) {
        return this.select(predicate, new IntArrayList()).toImmutable();
    }

    public <R extends MutableIntCollection> R select(IntPredicate predicate, R target) {
        for (int item : this.items) {
            if (!predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    public ImmutableIntList reject(IntPredicate predicate) {
        return this.reject(predicate, new IntArrayList()).toImmutable();
    }

    public <R extends MutableIntCollection> R reject(IntPredicate predicate, R target) {
        for (int item : this.items) {
            if (predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        for (int item : this.items) {
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public <V> ImmutableList<V> collect(IntToObjectFunction<? extends V> function) {
        FastList list = this.collect(function, (Collection)((Object)FastList.newList(this.items.length)));
        return list.toImmutable();
    }

    public <V, R extends Collection<V>> R collect(IntToObjectFunction<? extends V> function, R target) {
        for (int item : this.items) {
            target.add((Object)function.valueOf(item));
        }
        return target;
    }

    public long sum() {
        long result = 0L;
        for (int item : this.items) {
            result += (long)item;
        }
        return result;
    }

    public int max() {
        int max = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            int value = this.items[i];
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public int maxIfEmpty(int defaultValue) {
        return this.max();
    }

    public int min() {
        int min = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            int value = this.items[i];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public int minIfEmpty(int defaultValue) {
        return this.min();
    }

    public double average() {
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public long dotProduct(IntList list) {
        if (this.size() != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum = 0L;
        for (int i = 0; i < this.size(); ++i) {
            sum += (long)this.items[i] * (long)list.get(i);
        }
        return sum;
    }

    public LazyIntIterable asReversed() {
        return ReverseIntIterable.adapt((IntList)this);
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    public int binarySearch(int value) {
        return Arrays.binarySearch(this.items, value);
    }

    public int[] toArray() {
        int[] newItems = new int[this.items.length];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        return newItems;
    }

    public boolean contains(int value) {
        for (int item : this.items) {
            if (item != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableIntList toImmutable() {
        return this;
    }

    public ImmutableIntArrayList toReversed() {
        return ImmutableIntArrayList.newList((IntIterable)this.asReversed());
    }

    public ImmutableIntList newWith(int element) {
        int[] newItems = new int[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        newItems[this.items.length] = element;
        return new ImmutableIntArrayList(newItems);
    }

    public ImmutableIntList newWithout(int element) {
        int index = this.indexOf(element);
        if (index != -1) {
            int[] newItems = new int[this.items.length - 1];
            System.arraycopy(this.items, 0, newItems, 0, index);
            System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
            return IntLists.immutable.with(newItems);
        }
        return this;
    }

    public ImmutableIntList newWithAll(IntIterable elements) {
        int[] newItems = new int[this.items.length + elements.size()];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        int index = 0;
        IntIterator iterator = elements.intIterator();
        while (iterator.hasNext()) {
            newItems[this.items.length + index] = iterator.next();
            ++index;
        }
        return new ImmutableIntArrayList(newItems);
    }

    public ImmutableIntList newWithoutAll(IntIterable elements) {
        MutableIntList mutableIntList = this.toList();
        mutableIntList.removeAll(elements);
        return mutableIntList.toImmutable();
    }

    public int size() {
        return this.items.length;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i]);
        }
        return result;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i], i);
        }
        return result;
    }

    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)this);
            } else {
                IntIterator iterator = this.intIterator();
                while (iterator.hasNext()) {
                    MutableIntList batch = IntLists.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof IntList)) {
            return false;
        }
        IntList list = (IntList)otherList;
        if (this.items.length != list.size()) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == list.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int item : this.items) {
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.items.length; ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                int value = this.items[i];
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImmutableIntList distinct() {
        IntArrayList target = new IntArrayList();
        IntHashSet seenSoFar = new IntHashSet(this.size());
        for (int each : this.items) {
            if (!seenSoFar.add(each)) continue;
            target.add(each);
        }
        return target.toImmutable();
    }

    public ImmutableIntList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    public ImmutableList<IntIntPair> zipInt(IntIterable iterable) {
        int size = this.size();
        int otherSize = iterable.size();
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size, otherSize));
        IntIterator iterator = iterable.intIterator();
        for (int i = 0; i < size && iterator.hasNext(); ++i) {
            target.add((Object)PrimitiveTuples.pair(this.items[i], iterator.next()));
        }
        return target.toImmutable();
    }

    public <T> ImmutableList<IntObjectPair<T>> zip(Iterable<T> iterable) {
        int size = this.size();
        int otherSize = Iterate.sizeOf(iterable);
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size, otherSize));
        Iterator<T> iterator = iterable.iterator();
        for (int i = 0; i < size && iterator.hasNext(); ++i) {
            target.add(PrimitiveTuples.pair(this.items[i], iterator.next()));
        }
        return target.toImmutable();
    }

    public Spliterator.OfInt spliterator() {
        int characteristics = 1040;
        return Spliterators.spliterator(this.items, characteristics);
    }

    private class InternalIntIterator
    implements IntIterator {
        private int currentIndex;

        private InternalIntIterator() {
        }

        public boolean hasNext() {
            return this.currentIndex != ImmutableIntArrayList.this.items.length;
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int next = ImmutableIntArrayList.this.items[this.currentIndex];
            ++this.currentIndex;
            return next;
        }
    }
}

