/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.util.stream.IntStream;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableIntListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableIntArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableIntEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableIntSingletonList;

public enum ImmutableIntListFactoryImpl implements ImmutableIntListFactory
{
    INSTANCE;


    public ImmutableIntList empty() {
        return ImmutableIntEmptyList.INSTANCE;
    }

    public ImmutableIntList of() {
        return this.empty();
    }

    public ImmutableIntList with() {
        return this.empty();
    }

    public ImmutableIntList of(int one) {
        return this.with(one);
    }

    public ImmutableIntList with(int one) {
        return new ImmutableIntSingletonList(one);
    }

    public ImmutableIntList of(int ... items) {
        return this.with(items);
    }

    public ImmutableIntList with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableIntArrayList.newListWith(items);
    }

    public ImmutableIntList ofAll(IntIterable items) {
        return this.withAll(items);
    }

    public ImmutableIntList withAll(IntIterable items) {
        if (items instanceof ImmutableIntList) {
            return (ImmutableIntList)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableIntList ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableIntList withAll(Iterable<Integer> iterable) {
        return IntLists.mutable.withAll(iterable).toImmutable();
    }

    public ImmutableIntList ofAll(IntStream items) {
        return this.withAll(items);
    }

    public ImmutableIntList withAll(IntStream items) {
        return this.with(items.toArray());
    }
}

