/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableByteCharMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableByteCharMap;
import org.eclipse.collections.api.map.primitive.ByteCharMap;

/**
 * ImmutableByteCharMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteCharMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteCharMapFactoryImpl implements ImmutableByteCharMapFactory
{
    public ImmutableByteCharMap empty()
    {
        return ImmutableByteCharEmptyMap.INSTANCE;
    }

    public ImmutableByteCharMap of()
    {
        return this.empty();
    }

    public ImmutableByteCharMap with()
    {
        return this.empty();
    }

    public ImmutableByteCharMap of(byte key, char value)
    {
        return this.with(key, value);
    }

    public ImmutableByteCharMap with(byte key, char value)
    {
        return new ImmutableByteCharSingletonMap(key, value);
    }

    public ImmutableByteCharMap ofAll(ByteCharMap map)
    {
        return this.withAll(map);
    }

    public ImmutableByteCharMap withAll(ByteCharMap map)
    {
        if (map instanceof ImmutableByteCharMap)
        {
            return (ImmutableByteCharMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            byte key = map.keysView().byteIterator().next();
            return new ImmutableByteCharSingletonMap(key, map.get(key));
        }
        return new ImmutableByteCharHashMap(map);
    }
}
