/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Optional;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.block.procedure.AdaptObjectIntProcedureToProcedure;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.iterator.DistinctIterator;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.utility.Iterate;

@Immutable
public class DistinctIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;

    public DistinctIterable(Iterable<T> newAdapted) {
        this.adapted = newAdapted;
    }

    @Override
    public LazyIterable<T> distinct() {
        return this;
    }

    public void each(Procedure<? super T> procedure) {
        UnifiedSet seenSoFar = UnifiedSet.newSet();
        Iterate.forEach(this.adapted, (Procedure & Serializable)each -> {
            if (seenSoFar.add(each)) {
                procedure.value(each);
            }
        });
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        this.each(new AdaptObjectIntProcedureToProcedure<T>(objectIntProcedure));
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        UnifiedSet seenSoFar = UnifiedSet.newSet();
        return Iterate.anySatisfy(this.adapted, (Predicate & Serializable)each -> seenSoFar.add(each) && predicate.accept(each));
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        UnifiedSet seenSoFar = UnifiedSet.newSet();
        return Iterate.allSatisfy(this.adapted, (Predicate & Serializable)each -> !seenSoFar.add(each) || predicate.accept(each));
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        UnifiedSet seenSoFar = UnifiedSet.newSet();
        return Iterate.allSatisfy(this.adapted, (Predicate & Serializable)each -> !seenSoFar.add(each) || !predicate.accept(each));
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        UnifiedSet seenSoFar = UnifiedSet.newSet();
        return Iterate.detect(this.adapted, (Predicate & Serializable)each -> seenSoFar.add(each) && predicate.accept(each));
    }

    @Override
    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        UnifiedSet seenSoFar = UnifiedSet.newSet();
        return Iterate.detectOptional(this.adapted, (Predicate & Serializable)each -> seenSoFar.add(each) && predicate.accept(each));
    }

    public Iterator<T> iterator() {
        return new DistinctIterator<T>(this.adapted);
    }
}

