/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.LongObjectPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.ImmutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.bag.sorted.mutable.TreeBag;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Functions0;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.factory.PrimitiveFunctions;
import org.eclipse.collections.impl.block.factory.Procedures2;
import org.eclipse.collections.impl.block.procedure.MapCollectProcedure;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.block.procedure.SelectInstancesOfProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectByteProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectCharProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectIntProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectLongProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectShortProcedure;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.factory.primitive.ObjectDoubleMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectLongMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyLongIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableLongMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableLongObjectMap;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.partition.bag.PartitionHashBag;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public class LongObjectHashMap<V>
implements MutableLongObjectMap<V>,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final long EMPTY_KEY = 0L;
    private static final long REMOVED_KEY = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 8;
    private static final int INITIAL_LINEAR_PROBE = 4;
    private long[] keys;
    private V[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues<V> sentinelValues;
    private boolean copyKeysOnWrite = false;

    public LongObjectHashMap() {
        this.allocateTable(16);
    }

    public LongObjectHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    public LongObjectHashMap(LongObjectMap<? extends V> map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static <V> LongObjectHashMap<V> newMap() {
        return new LongObjectHashMap<V>();
    }

    public static <V> LongObjectHashMap<V> newMap(LongObjectMap<? extends V> map) {
        return new LongObjectHashMap<V>(map);
    }

    public static <V> LongObjectHashMap<V> newWithKeysValues(long key, V value) {
        return new LongObjectHashMap<V>(1).withKeyValue(key, (Object)value);
    }

    public static <V> LongObjectHashMap<V> newWithKeysValues(long key1, V value1, long key2, V value2) {
        return new LongObjectHashMap<V>(2).withKeysValues(key1, value1, key2, value2);
    }

    public static <V> LongObjectHashMap<V> newWithKeysValues(long key1, V value1, long key2, V value2, long key3, V value3) {
        return new LongObjectHashMap<V>(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongObjectMap)) {
            return false;
        }
        LongObjectMap other = (LongObjectMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0L) || other.containsKey(1L)) {
                return false;
            }
        } else {
            if (!(!((SentinelValues)this.sentinelValues).containsZeroKey || other.containsKey(0L) && LongObjectHashMap.nullSafeEquals(((SentinelValues)this.sentinelValues).zeroValue, other.get(0L)))) {
                return false;
            }
            if (!(!((SentinelValues)this.sentinelValues).containsOneKey || other.containsKey(1L) && LongObjectHashMap.nullSafeEquals(((SentinelValues)this.sentinelValues).oneValue, other.get(1L)))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongObjectHashMap.isNonSentinel(key) || other.containsKey(key) && LongObjectHashMap.nullSafeEquals(this.values[i], other.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result += 0 ^ (((SentinelValues)this.sentinelValues).zeroValue == null ? 0 : ((SentinelValues)this.sentinelValues).zeroValue.hashCode());
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result += 1 ^ (((SentinelValues)this.sentinelValues).oneValue == null ? 0 : ((SentinelValues)this.sentinelValues).oneValue.hashCode());
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(this.keys[i] ^ this.keys[i] >>> 32) ^ (this.values[i] == null ? 0 : this.values[i].hashCode());
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                appendable.append(0L).append("=").append(((SentinelValues)this.sentinelValues).zeroValue);
                first = false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1L).append("=").append(((SentinelValues)this.sentinelValues).oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongObjectHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                    appendable.append(String.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
                    first = false;
                }
                if (((SentinelValues)this.sentinelValues).containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(((SentinelValues)this.sentinelValues).oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                long key = this.keys[i];
                if (!LongObjectHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<V> iterator() {
        return new InternalIterator();
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result[index++] = ((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result[index++] = ((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result[index++] = this.values[i];
        }
        return result;
    }

    public <T> T[] toArray(T[] a) {
        int size = this.size();
        Object[] result = a.length < size ? (Object[])Array.newInstance(a.getClass().getComponentType(), size) : a;
        this.forEachWithIndex((ObjectIntProcedure & Serializable)(each, index) -> {
            result[index] = each;
        });
        if (result.length > size) {
            result[size] = null;
        }
        return result;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        for (Object item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<?> source) {
        return this.containsAllIterable(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        for (Object item : elements) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public LongObjectHashMap<V> tap(Procedure<? super V> procedure) {
        this.forEachValue(procedure);
        return this;
    }

    public void forEach(Procedure<? super V> procedure) {
        this.each(procedure);
    }

    public void each(Procedure<? super V> procedure) {
        this.forEachValue(procedure);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        int index = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                objectIntProcedure.value(((SentinelValues)this.sentinelValues).zeroValue, index++);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                objectIntProcedure.value(((SentinelValues)this.sentinelValues).oneValue, index++);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            objectIntProcedure.value(this.values[i], index++);
        }
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value(((SentinelValues)this.sentinelValues).zeroValue, parameter);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value(((SentinelValues)this.sentinelValues).oneValue, parameter);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i], parameter);
        }
    }

    public void forEachValue(Procedure<? super V> procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(LongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value(0L);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value(1L);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(LongObjectProcedure<? super V> procedure) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                procedure.value(0L, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                procedure.value(1L, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LongObjectHashMap<V> select(LongObjectPredicate<? super V> predicate) {
        LongObjectHashMap<Object> result = LongObjectHashMap.newMap();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(0L, ((SentinelValues)this.sentinelValues).zeroValue)) {
                result.put(0L, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(1L, ((SentinelValues)this.sentinelValues).oneValue)) {
                result.put(1L, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public LongObjectHashMap<V> reject(LongObjectPredicate<? super V> predicate) {
        LongObjectHashMap<Object> result = LongObjectHashMap.newMap();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(0L, ((SentinelValues)this.sentinelValues).zeroValue)) {
                result.put(0L, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(1L, ((SentinelValues)this.sentinelValues).oneValue)) {
                result.put(1L, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public MutableBag<V> select(Predicate<? super V> predicate) {
        HashBag result = new HashBag();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                result.add(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                result.add(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            target.add(this.values[i]);
        }
        return target;
    }

    public <P> MutableBag<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            targetCollection.add(this.values[i]);
        }
        return targetCollection;
    }

    public MutableBag<V> reject(Predicate<? super V> predicate) {
        HashBag result = new HashBag();
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                result.add(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                result.add(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            target.add(this.values[i]);
        }
        return target;
    }

    public <P> MutableBag<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                targetCollection.add((Object)((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i], parameter)) continue;
            targetCollection.add(this.values[i]);
        }
        return targetCollection;
    }

    public PartitionMutableBag<V> partition(Predicate<? super V> predicate) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEach(new PartitionProcedure<V>(predicate, partitionMutableBag));
        return partitionMutableBag;
    }

    public <P> PartitionMutableBag<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEach(new PartitionProcedure<V>(Predicates.bind(predicate, parameter), partitionMutableBag));
        return partitionMutableBag;
    }

    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        HashBag result = HashBag.newBag(this.size());
        this.forEach(new SelectInstancesOfProcedure<S>(clazz, result));
        return result;
    }

    public <VV> MutableBag<VV> collect(Function<? super V, ? extends VV> function) {
        return this.collect(function, new HashBag());
    }

    public MutableBooleanBag collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return this.collectBoolean(booleanFunction, new BooleanHashBag());
    }

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        this.forEach(new CollectBooleanProcedure<V>(booleanFunction, target));
        return target;
    }

    public MutableByteBag collectByte(ByteFunction<? super V> byteFunction) {
        return this.collectByte(byteFunction, new ByteHashBag());
    }

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        this.forEach(new CollectByteProcedure<V>(byteFunction, target));
        return target;
    }

    public MutableCharBag collectChar(CharFunction<? super V> charFunction) {
        return this.collectChar(charFunction, new CharHashBag());
    }

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        this.forEach(new CollectCharProcedure<V>(charFunction, target));
        return target;
    }

    public MutableDoubleBag collectDouble(DoubleFunction<? super V> doubleFunction) {
        return this.collectDouble(doubleFunction, new DoubleHashBag());
    }

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        this.forEach(new CollectDoubleProcedure<V>(doubleFunction, target));
        return target;
    }

    public MutableFloatBag collectFloat(FloatFunction<? super V> floatFunction) {
        return this.collectFloat(floatFunction, new FloatHashBag());
    }

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        this.forEach(new CollectFloatProcedure<V>(floatFunction, target));
        return target;
    }

    public MutableIntBag collectInt(IntFunction<? super V> intFunction) {
        return this.collectInt(intFunction, new IntHashBag());
    }

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        this.forEach(new CollectIntProcedure<V>(intFunction, target));
        return target;
    }

    public MutableLongBag collectLong(LongFunction<? super V> longFunction) {
        return this.collectLong(longFunction, new LongHashBag());
    }

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        this.forEach(new CollectLongProcedure<V>(longFunction, target));
        return target;
    }

    public MutableShortBag collectShort(ShortFunction<? super V> shortFunction) {
        return this.collectShort(shortFunction, new ShortHashBag());
    }

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        this.forEach(new CollectShortProcedure<V>(shortFunction, target));
        return target;
    }

    public <P, VV> MutableBag<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.collect(Functions.bind(function, parameter));
    }

    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                targetCollection.add((Object)function.value(((SentinelValues)this.sentinelValues).zeroValue, parameter));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                targetCollection.add((Object)function.value(((SentinelValues)this.sentinelValues).oneValue, parameter));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            targetCollection.add((Object)function.value(this.values[i], parameter));
        }
        return targetCollection;
    }

    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            target.add((Object)function.valueOf(this.values[i]));
        }
        return target;
    }

    public <VV> MutableBag<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function) {
        return this.collectIf(predicate, function, HashBag.newBag());
    }

    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue));
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                target.add((Object)function.valueOf(((SentinelValues)this.sentinelValues).oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            target.add((Object)function.valueOf(this.values[i]));
        }
        return target;
    }

    public <VV> MutableBag<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        return this.flatCollect(function, new HashBag());
    }

    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                Iterate.addAllTo((Iterable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), target);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Iterate.addAllTo((Iterable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue), target);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            Iterate.addAllTo((Iterable)function.valueOf(this.values[i]), target);
        }
        return target;
    }

    public V detect(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return this.values[i];
        }
        return null;
    }

    public Optional<V> detectOptional(Predicate<? super V> predicate) {
        return Optional.ofNullable(this.detect(predicate));
    }

    public <P> Optional<V> detectWithOptional(Predicate2<? super V, ? super P> predicate, P parameter) {
        return Optional.ofNullable(this.detectWith(predicate, parameter));
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return (V)function.value();
    }

    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return this.values[i];
        }
        return (V)function.value();
    }

    public int count(Predicate<? super V> predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                ++count;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                ++count;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i], parameter)) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue)) {
                return false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && !predicate.accept(((SentinelValues)this.sentinelValues).zeroValue, parameter)) {
                return false;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && !predicate.accept(((SentinelValues)this.sentinelValues).oneValue, parameter)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i], parameter)) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return !this.anySatisfy(predicate);
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return !this.anySatisfyWith(predicate, parameter);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.value(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.value(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.value(result, this.values[i]);
        }
        return result;
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        int result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.intValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.intValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.intValueOf(result, this.values[i]);
        }
        return result;
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        long result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.longValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.longValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.longValueOf(result, this.values[i]);
        }
        return result;
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        float result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.floatValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.floatValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.floatValueOf(result, this.values[i]);
        }
        return result;
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        double result = injectedValue;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                result = function.doubleValueOf(result, ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                result = function.doubleValueOf(result, ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.doubleValueOf(result, this.values[i]);
        }
        return result;
    }

    @Deprecated
    public <S> MutableBag<Pair<V, S>> zip(Iterable<S> that) {
        return this.zip(that, HashBag.newBag());
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return IterableIterate.zip(this, that, target);
    }

    @Deprecated
    public MutableSet<Pair<V, Integer>> zipWithIndex() {
        return this.zipWithIndex((Collection)((Object)UnifiedSet.newSet()));
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return IterableIterate.zipWithIndex(this, target);
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        Iterator<V> iterator = this.iterator();
        MutableList result = Lists.mutable.of();
        while (iterator.hasNext()) {
            FastList batch = FastList.newList();
            for (int i = 0; i < size && iterator.hasNext(); ++i) {
                batch.add(iterator.next());
            }
            result.add(batch);
        }
        return result;
    }

    public <K, VV> MutableMap<K, VV> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<V, K, VV>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public <K, VV> MutableMap<K, VV> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<V, K, VV>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }

    public <VV> MutableBagMultimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return this.groupBy(function, HashBagMultimap.newMultimap());
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                target.put(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), ((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                target.put(function.valueOf(((SentinelValues)this.sentinelValues).oneValue), ((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            target.put(function.valueOf(this.values[i]), this.values[i]);
        }
        return target;
    }

    public <VV> MutableBagMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.groupByEach(function, HashBagMultimap.newMultimap());
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        if (this.sentinelValues != null) {
            Iterable iterable;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                iterable = (Iterable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
                for (Object key : iterable) {
                    target.put(key, ((SentinelValues)this.sentinelValues).zeroValue);
                }
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                iterable = (Iterable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                for (Object key : iterable) {
                    target.put(key, ((SentinelValues)this.sentinelValues).oneValue);
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            Iterable iterable = (Iterable)function.valueOf(this.values[i]);
            for (Object key : iterable) {
                target.put(key, this.values[i]);
            }
        }
        return target;
    }

    public <VV> MutableMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap());
    }

    public <VV, R extends MutableMap<VV, V>> R groupByUniqueKey(Function<? super V, ? extends VV> function, R target) {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey && target.put(function.valueOf(((SentinelValues)this.sentinelValues).zeroValue), ((SentinelValues)this.sentinelValues).zeroValue) != null) {
                throw new IllegalStateException("Key " + function.valueOf(((SentinelValues)this.sentinelValues).zeroValue) + " already exists in map!");
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && target.put(function.valueOf(((SentinelValues)this.sentinelValues).oneValue), ((SentinelValues)this.sentinelValues).oneValue) != null) {
                throw new IllegalStateException("Key " + function.valueOf(((SentinelValues)this.sentinelValues).oneValue) + " already exists in map!");
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || target.put(function.valueOf(this.values[i]), this.values[i]) == null) continue;
            throw new IllegalStateException("Key " + function.valueOf(this.values[i]) + " already exists in map!");
        }
        return target;
    }

    public V getFirst() {
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public V getLast() {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
        }
        return null;
    }

    public V getOnly() {
        if (this.size() != 1) {
            throw new IllegalStateException("Size must be 1 but was " + this.size());
        }
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public MutableList<V> toList() {
        MutableList list = Lists.mutable.of();
        this.forEachWith(Procedures2.addToCollection(), list);
        return list;
    }

    public <R extends Collection<V>> R into(R target) {
        return Iterate.addAllTo(this, target);
    }

    public MutableList<V> toSortedList() {
        return this.toList().sortThis();
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return this.toList().sortThis(comparator);
    }

    public <VV extends Comparable<? super VV>> MutableList<V> toSortedListBy(Function<? super V, ? extends VV> function) {
        return this.toList().sortThis(Comparators.byFunction(function));
    }

    public MutableSet<V> toSet() {
        UnifiedSet set = UnifiedSet.newSet();
        this.forEachWith(Procedures2.addToCollection(), set);
        return set;
    }

    public MutableSortedSet<V> toSortedSet() {
        TreeSortedSet set = TreeSortedSet.newSet();
        this.forEachWith(Procedures2.addToCollection(), set);
        return set;
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        TreeSortedSet<? super V> set = TreeSortedSet.newSet(comparator);
        this.forEachWith(Procedures2.addToCollection(), set);
        return set;
    }

    public <VV extends Comparable<? super VV>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends VV> function) {
        TreeSortedSet<? super V> set = TreeSortedSet.newSet(Comparators.byFunction(function));
        this.forEachWith(Procedures2.addToCollection(), set);
        return set;
    }

    public MutableBag<V> toBag() {
        MutableBag bag = Bags.mutable.of();
        this.forEachWith(Procedures2.addToCollection(), bag);
        return bag;
    }

    public MutableSortedBag<V> toSortedBag() {
        TreeBag sortedBag = TreeBag.newBag();
        this.forEachWith(Procedures2.addToCollection(), sortedBag);
        return sortedBag;
    }

    public MutableSortedBag<V> toSortedBag(Comparator<? super V> comparator) {
        TreeBag<? super V> sortedBag = TreeBag.newBag(comparator);
        this.forEachWith(Procedures2.addToCollection(), sortedBag);
        return sortedBag;
    }

    public <VV extends Comparable<? super VV>> MutableSortedBag<V> toSortedBagBy(Function<? super V, ? extends VV> function) {
        return this.toSortedBag((Comparator<? super V>)Comparators.byFunction(function));
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MapCollectProcedure<V, NK, NV>(map, keyFunction, valueFunction));
        return map;
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.toSortedMap((Comparator<? super NK>)Comparators.naturalOrder(), keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        TreeSortedMap sortedMap = TreeSortedMap.newMap(comparator);
        this.forEach(new MapCollectProcedure<V, NK, NV>(sortedMap, keyFunction, valueFunction));
        return sortedMap;
    }

    public LazyIterable<V> asLazy() {
        return LazyIterate.adapt(this);
    }

    public V min(Comparator<? super V> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object min = null;
        boolean isMinSet = false;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                min = ((SentinelValues)this.sentinelValues).zeroValue;
                isMinSet = true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && (!isMinSet || comparator.compare(min, ((SentinelValues)this.sentinelValues).oneValue) > 0)) {
                min = ((SentinelValues)this.sentinelValues).oneValue;
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || isMinSet && comparator.compare(min, this.values[i]) <= 0) continue;
            min = this.values[i];
            isMinSet = true;
        }
        return (V)min;
    }

    public V max(Comparator<? super V> comparator) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object max = null;
        boolean isMaxSet = false;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                max = ((SentinelValues)this.sentinelValues).zeroValue;
                isMaxSet = true;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey && (!isMaxSet || comparator.compare(max, ((SentinelValues)this.sentinelValues).oneValue) < 0)) {
                max = ((SentinelValues)this.sentinelValues).oneValue;
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || isMaxSet && comparator.compare(max, this.values[i]) >= 0) continue;
            max = this.values[i];
            isMaxSet = true;
        }
        return (V)max;
    }

    public V min() {
        return (V)this.min((Comparator<? super V>)Comparators.naturalOrder());
    }

    public V max() {
        return (V)this.max((Comparator<? super V>)Comparators.naturalOrder());
    }

    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object max = null;
        boolean isMaxSet = false;
        Comparable maxValue = null;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                max = ((SentinelValues)this.sentinelValues).zeroValue;
                isMaxSet = true;
                maxValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Comparable nextValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                if (!isMaxSet || nextValue.compareTo(maxValue) > 0) {
                    max = ((SentinelValues)this.sentinelValues).oneValue;
                    isMaxSet = true;
                    maxValue = nextValue;
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            V next = this.values[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (isMaxSet && nextValue.compareTo(maxValue) <= 0) continue;
            max = next;
            isMaxSet = true;
            maxValue = nextValue;
        }
        return (V)max;
    }

    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object min = null;
        boolean isMinSet = false;
        Comparable minValue = null;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                min = ((SentinelValues)this.sentinelValues).zeroValue;
                isMinSet = true;
                minValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                Comparable nextValue = (Comparable)function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
                if (!isMinSet || nextValue.compareTo(minValue) < 0) {
                    min = ((SentinelValues)this.sentinelValues).oneValue;
                    isMinSet = true;
                    minValue = nextValue;
                }
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            V next = this.values[i];
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (isMinSet && nextValue.compareTo(minValue) >= 0) continue;
            min = next;
            isMinSet = true;
            minValue = nextValue;
        }
        return (V)min;
    }

    public long sumOfInt(IntFunction<? super V> function) {
        long sum = 0L;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum += (long)function.intValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum += (long)function.intValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum += (long)function.intValueOf(this.values[i]);
        }
        return sum;
    }

    public double sumOfFloat(FloatFunction<? super V> function) {
        double sum = 0.0;
        double compensation = 0.0;
        if (this.sentinelValues != null) {
            double nextSum;
            double adjustedValue;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                adjustedValue = (double)function.floatValueOf(((SentinelValues)this.sentinelValues).zeroValue) - compensation;
                nextSum = sum + adjustedValue;
                compensation = nextSum - sum - adjustedValue;
                sum = nextSum;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                adjustedValue = (double)function.floatValueOf(((SentinelValues)this.sentinelValues).oneValue) - compensation;
                nextSum = sum + adjustedValue;
                compensation = nextSum - sum - adjustedValue;
                sum = nextSum;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            double adjustedValue = (double)function.floatValueOf(this.values[i]) - compensation;
            double nextSum = sum + adjustedValue;
            compensation = nextSum - sum - adjustedValue;
            sum = nextSum;
        }
        return sum;
    }

    public long sumOfLong(LongFunction<? super V> function) {
        long sum = 0L;
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                sum += function.longValueOf(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                sum += function.longValueOf(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            sum += function.longValueOf(this.values[i]);
        }
        return sum;
    }

    public double sumOfDouble(DoubleFunction<? super V> function) {
        double sum = 0.0;
        double compensation = 0.0;
        if (this.sentinelValues != null) {
            double nextSum;
            double adjustedValue;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                adjustedValue = function.doubleValueOf(((SentinelValues)this.sentinelValues).zeroValue) - compensation;
                nextSum = sum + adjustedValue;
                compensation = nextSum - sum - adjustedValue;
                sum = nextSum;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                adjustedValue = function.doubleValueOf(((SentinelValues)this.sentinelValues).oneValue) - compensation;
                nextSum = sum + adjustedValue;
                compensation = nextSum - sum - adjustedValue;
                sum = nextSum;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            double adjustedValue = function.doubleValueOf(this.values[i]) - compensation;
            double nextSum = sum + adjustedValue;
            compensation = nextSum - sum - adjustedValue;
            sum = nextSum;
        }
        return sum;
    }

    public <V1> MutableObjectLongMap<V1> sumByInt(Function<? super V, ? extends V1> groupBy, IntFunction<? super V> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByIntFunction(groupBy, function));
    }

    public <V1> MutableObjectDoubleMap<V1> sumByFloat(Function<? super V, ? extends V1> groupBy, FloatFunction<? super V> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByFloatFunction(groupBy, function));
    }

    public <V1> MutableObjectLongMap<V1> sumByLong(Function<? super V, ? extends V1> groupBy, LongFunction<? super V> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByLongFunction(groupBy, function));
    }

    public <V1> MutableObjectDoubleMap<V1> sumByDouble(Function<? super V, ? extends V1> groupBy, DoubleFunction<? super V> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByDoubleFunction(groupBy, function));
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.keys = new long[this.keys.length];
            this.copyKeysOnWrite = false;
        }
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, null);
    }

    public V put(long key, V value) {
        if (LongObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).zeroValue;
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)oldValue;
        }
        if (LongObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).oneValue;
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            V oldValue = this.values[index];
            this.values[index] = value;
            return oldValue;
        }
        this.addKeyValueAtIndex(key, value, index);
        return null;
    }

    public void putAll(LongObjectMap<? extends V> map) {
        map.forEachKeyValue((LongObjectProcedure & Serializable)(key, value) -> this.put(key, value));
    }

    public boolean containsKey(long key) {
        if (LongObjectHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && ((SentinelValues)this.sentinelValues).containsZeroKey;
        }
        if (LongObjectHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && ((SentinelValues)this.sentinelValues).containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(Object value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i]) || !LongObjectHashMap.nullSafeEquals(this.values[i], value)) continue;
            return true;
        }
        return false;
    }

    public V get(long key) {
        return (V)this.getIfAbsent(key, Functions0.nullValue());
    }

    public V getIfAbsent(long key, Function0<? extends V> ifAbsent) {
        if (LongObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)ifAbsent.value();
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (LongObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)ifAbsent.value();
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[this.probe(key)] == key) {
            return this.values[index];
        }
        return (V)ifAbsent.value();
    }

    public V getIfAbsentPut(long key, V value) {
        if (LongObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return value;
        }
        if (LongObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public V getIfAbsentPut(long key, Function0<? extends V> function) {
        if (LongObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.value();
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            Object value = function.value();
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)value;
        }
        if (LongObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.value();
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            Object value = function.value();
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        Object value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return (V)value;
    }

    public <P> V getIfAbsentPutWith(long key, Function<? super P, ? extends V> function, P parameter) {
        if (LongObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(parameter);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            Object value = function.valueOf(parameter);
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)value;
        }
        if (LongObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(parameter);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            Object value = function.valueOf(parameter);
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        Object value = function.valueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return (V)value;
    }

    public V getIfAbsentPutWithKey(long key, LongToObjectFunction<? extends V> function) {
        if (LongObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                return (V)((SentinelValues)this.sentinelValues).zeroValue;
            }
            Object value = function.valueOf(key);
            ((SentinelValues)this.sentinelValues).containsZeroKey = true;
            ((SentinelValues)this.sentinelValues).zeroValue = value;
            return (V)value;
        }
        if (LongObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                Object value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = value;
                return (V)value;
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                return (V)((SentinelValues)this.sentinelValues).oneValue;
            }
            Object value = function.valueOf(key);
            ((SentinelValues)this.sentinelValues).containsOneKey = true;
            ((SentinelValues)this.sentinelValues).oneValue = value;
            return (V)value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        Object value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return (V)value;
    }

    public V updateValue(long key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        if (LongObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(factory.value());
            } else if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(((SentinelValues)this.sentinelValues).zeroValue);
            } else {
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.valueOf(factory.value());
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (LongObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(factory.value());
            } else if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(((SentinelValues)this.sentinelValues).oneValue);
            } else {
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.valueOf(factory.value());
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        Object value = function.valueOf(factory.value());
        this.addKeyValueAtIndex(key, value, index);
        return (V)value;
    }

    public <P> V updateValueWith(long key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        if (LongObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(factory.value(), parameter);
            } else if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(((SentinelValues)this.sentinelValues).zeroValue, parameter);
            } else {
                ((SentinelValues)this.sentinelValues).containsZeroKey = true;
                ((SentinelValues)this.sentinelValues).zeroValue = function.value(factory.value(), parameter);
            }
            return (V)((SentinelValues)this.sentinelValues).zeroValue;
        }
        if (LongObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.value(factory.value(), parameter);
            } else if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).oneValue = function.value(((SentinelValues)this.sentinelValues).oneValue, parameter);
            } else {
                ((SentinelValues)this.sentinelValues).containsOneKey = true;
                ((SentinelValues)this.sentinelValues).oneValue = function.value(factory.value(), parameter);
            }
            return (V)((SentinelValues)this.sentinelValues).oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.value(this.values[index], parameter);
            return this.values[index];
        }
        Object value = function.value(factory.value(), parameter);
        this.addKeyValueAtIndex(key, value, index);
        return (V)value;
    }

    public V removeKey(long key) {
        if (LongObjectHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsZeroKey) {
                return null;
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).zeroValue;
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                ((SentinelValues)this.sentinelValues).containsZeroKey = false;
                ((SentinelValues)this.sentinelValues).zeroValue = null;
            } else {
                this.sentinelValues = null;
            }
            return (V)oldValue;
        }
        if (LongObjectHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !((SentinelValues)this.sentinelValues).containsOneKey) {
                return null;
            }
            Object oldValue = ((SentinelValues)this.sentinelValues).oneValue;
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                ((SentinelValues)this.sentinelValues).containsOneKey = false;
                ((SentinelValues)this.sentinelValues).oneValue = null;
            } else {
                this.sentinelValues = null;
            }
            return (V)oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            V oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return null;
    }

    public V remove(long key) {
        return this.removeKey(key);
    }

    public LongObjectHashMap<V> withKeyValue(long key, V value) {
        this.put(key, value);
        return this;
    }

    public MutableLongObjectMap<V> withoutKey(long key) {
        this.removeKey(key);
        return this;
    }

    public MutableLongObjectMap<V> withoutAllKeys(LongIterable keys) {
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext()) {
            long item = iterator.next();
            this.removeKey(item);
        }
        return this;
    }

    public LongObjectHashMap<V> withKeysValues(long key1, V value1, long key2, V value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public LongObjectHashMap<V> withKeysValues(long key1, V value1, long key2, V value2, long key3, V value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public LongObjectHashMap<V> withKeysValues(long key1, V value1, long key2, V value2, long key3, V value3, long key4, V value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public MutableLongObjectMap<V> asUnmodifiable() {
        return new UnmodifiableLongObjectMap(this);
    }

    public MutableLongObjectMap<V> asSynchronized() {
        return new SynchronizedLongObjectMap(this);
    }

    public ImmutableLongObjectMap<V> toImmutable() {
        return LongObjectMaps.immutable.withAll((LongObjectMap)this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (((SentinelValues)this.sentinelValues).containsZeroKey) {
                out.writeLong(0L);
                out.writeObject(((SentinelValues)this.sentinelValues).zeroValue);
            }
            if (((SentinelValues)this.sentinelValues).containsOneKey) {
                out.writeLong(1L);
                out.writeObject(((SentinelValues)this.sentinelValues).oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongObjectHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeLong(this.keys[i]);
            out.writeObject(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readLong(), in.readObject());
        }
    }

    private void addKeyValueAtIndex(long key, V value, int index) {
        if (this.keys[index] == 1L) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1L;
        this.values[index] = null;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
        if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
            this.rehash();
        }
    }

    private void copyKeys() {
        long[] copy = new long[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    private static boolean nullSafeEquals(Object value, Object other) {
        return value == null ? other == null : other == value || value.equals(other);
    }

    public MutableLongSet keySet() {
        return new KeySet();
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        long[] old = this.keys;
        V[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!LongObjectHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
        this.copyKeysOnWrite = false;
    }

    int probe(long element) {
        int index = this.mask((int)element);
        long keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0L) {
            return index;
        }
        int removedIndex = keyAtIndex == 1L ? index : -1;
        for (int i = 1; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(long element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            long keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(long element, int removedIndex) {
        int nextIndex = (int)SpreadFunctions.longSpreadOne(element);
        int spreadTwo = (int)Long.reverse(SpreadFunctions.longSpreadTwo(element)) | 1;
        long keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(long element) {
        long code = SpreadFunctions.longSpreadOne(element);
        return this.mask((int)code);
    }

    int spreadTwoAndMask(long element) {
        long code = SpreadFunctions.longSpreadTwo(element);
        return this.mask((int)code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new long[sizeToAllocate];
        this.values = new Object[sizeToAllocate];
    }

    private static boolean isEmptyKey(long key) {
        return key == 0L;
    }

    private static boolean isRemovedKey(long key) {
        return key == 1L;
    }

    private static boolean isNonSentinel(long key) {
        return !LongObjectHashMap.isEmptyKey(key) && !LongObjectHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public Collection<V> values() {
        return new ValuesCollection();
    }

    public LazyLongIterable keysView() {
        return new KeysView();
    }

    public RichIterable<LongObjectPair<V>> keyValuesView() {
        return new KeyValuesView();
    }

    static /* synthetic */ long[] access$802(LongObjectHashMap x0, long[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$1002(LongObjectHashMap x0, Object[] x1) {
        x0.values = x1;
        return x1;
    }

    private class KeyValuesView
    extends AbstractLazyIterable<LongObjectPair<V>> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super LongObjectPair<V>> procedure) {
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0L, LongObjectHashMap.this.sentinelValues.zeroValue));
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1L, LongObjectHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < LongObjectHashMap.this.keys.length; ++i) {
                if (!LongObjectHashMap.isNonSentinel(LongObjectHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(LongObjectHashMap.this.keys[i], LongObjectHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super LongObjectPair<V>> objectIntProcedure) {
            int index = 0;
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(0L, LongObjectHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value(PrimitiveTuples.pair(1L, LongObjectHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < LongObjectHashMap.this.keys.length; ++i) {
                if (!LongObjectHashMap.isNonSentinel(LongObjectHashMap.this.keys[i])) continue;
                objectIntProcedure.value(PrimitiveTuples.pair(LongObjectHashMap.this.keys[i], LongObjectHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super LongObjectPair<V>, ? super P> procedure, P parameter) {
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value(PrimitiveTuples.pair(0L, LongObjectHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value(PrimitiveTuples.pair(1L, LongObjectHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < LongObjectHashMap.this.keys.length; ++i) {
                if (!LongObjectHashMap.isNonSentinel(LongObjectHashMap.this.keys[i])) continue;
                procedure.value(PrimitiveTuples.pair(LongObjectHashMap.this.keys[i], LongObjectHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<LongObjectPair<V>> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<LongObjectPair<V>> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public LongObjectPair<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (LongObjectHashMap.this.containsKey(0L)) {
                        return PrimitiveTuples.pair(0L, LongObjectHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (LongObjectHashMap.this.containsKey(1L)) {
                        return PrimitiveTuples.pair(1L, LongObjectHashMap.this.sentinelValues.oneValue);
                    }
                }
                long[] keys = LongObjectHashMap.this.keys;
                while (!LongObjectHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                LongObjectPair<Object> result = PrimitiveTuples.pair(keys[this.position], LongObjectHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != LongObjectHashMap.this.size();
            }
        }
    }

    private class KeysView
    extends AbstractLazyLongIterable {
        private KeysView() {
        }

        public LongIterator longIterator() {
            return new UnmodifiableLongIterator((LongIterator)new KeysSetIterator());
        }

        @Override
        public void forEach(LongProcedure procedure) {
            this.each(procedure);
        }

        public void each(LongProcedure procedure) {
            LongObjectHashMap.this.forEachKey(procedure);
        }
    }

    protected class ValuesCollection
    implements Collection<V> {
        protected ValuesCollection() {
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        @Override
        public void clear() {
            LongObjectHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return LongObjectHashMap.this.containsValue(o);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return Iterate.allSatisfy(collection, Predicates.in(this));
        }

        @Override
        public boolean isEmpty() {
            return LongObjectHashMap.this.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            return LongObjectHashMap.this.iterator();
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    if (it.next() != null) continue;
                    it.remove();
                    return true;
                }
            } else {
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    Object o2 = it.next();
                    if (o != o2 && !o2.equals(o)) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean changed = false;
            for (Object obj : collection) {
                if (!this.remove(obj)) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean modified = false;
            Iterator e = this.iterator();
            while (e.hasNext()) {
                if (collection.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public int size() {
            return LongObjectHashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            return LongObjectHashMap.this.toArray();
        }

        @Override
        public <T> T[] toArray(T[] result) {
            return LongObjectHashMap.this.toArray(result);
        }
    }

    private class KeysSetIterator
    implements MutableLongIterator {
        private int count;
        private int position;
        private long lastKey;
        private boolean handledZeroKey;
        private boolean handledOneKey;
        private boolean canRemove;

        private KeysSetIterator() {
        }

        public boolean hasNext() {
            return this.count != LongObjectHashMap.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZeroKey) {
                this.handledZeroKey = true;
                if (LongObjectHashMap.this.containsKey(0L)) {
                    this.lastKey = 0L;
                    return this.lastKey;
                }
            }
            if (!this.handledOneKey) {
                this.handledOneKey = true;
                if (LongObjectHashMap.this.containsKey(1L)) {
                    this.lastKey = 1L;
                    return this.lastKey;
                }
            }
            long[] keys = LongObjectHashMap.this.keys;
            while (!LongObjectHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            LongObjectHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeySet
    implements MutableLongSet {
        private KeySet() {
        }

        public MutableLongIterator longIterator() {
            return new KeysSetIterator();
        }

        public void forEach(LongProcedure procedure) {
            this.each(procedure);
        }

        public void each(LongProcedure procedure) {
            LongObjectHashMap.this.forEachKey(procedure);
        }

        public int count(LongPredicate predicate) {
            int count = 0;
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    ++count;
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    ++count;
                }
            }
            for (long key : LongObjectHashMap.this.keys) {
                if (!LongObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(LongPredicate predicate) {
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return true;
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return true;
                }
            }
            for (long key : LongObjectHashMap.this.keys) {
                if (!LongObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0L);
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1L);
                }
            }
            for (long key : LongObjectHashMap.this.keys) {
                if (!LongObjectHashMap.isNonSentinel(key)) continue;
                result = function.valueOf(result, key);
            }
            return result;
        }

        public boolean allSatisfy(LongPredicate predicate) {
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0L)) {
                    return false;
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1L)) {
                    return false;
                }
            }
            for (long key : LongObjectHashMap.this.keys) {
                if (!LongObjectHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        public boolean add(long element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(long ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(LongIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(long key) {
            int oldSize = LongObjectHashMap.this.size();
            LongObjectHashMap.this.removeKey(key);
            return oldSize != LongObjectHashMap.this.size();
        }

        public boolean removeAll(LongIterable source) {
            int oldSize = LongObjectHashMap.this.size();
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                LongObjectHashMap.this.removeKey(iterator.next());
            }
            return oldSize != LongObjectHashMap.this.size();
        }

        public boolean removeAll(long ... source) {
            int oldSize = LongObjectHashMap.this.size();
            for (long item : source) {
                LongObjectHashMap.this.removeKey(item);
            }
            return oldSize != LongObjectHashMap.this.size();
        }

        public boolean retainAll(LongIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
            MutableLongObjectMap retained = LongObjectHashMap.this.select((arg_0, arg_1) -> KeySet.lambda$retainAll$9bd826c3$1((LongSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                LongObjectHashMap.access$802(LongObjectHashMap.this, ((LongObjectHashMap)retained).keys);
                LongObjectHashMap.access$1002(LongObjectHashMap.this, ((LongObjectHashMap)retained).values);
                LongObjectHashMap.this.sentinelValues = ((LongObjectHashMap)retained).sentinelValues;
                LongObjectHashMap.this.occupiedWithData = ((LongObjectHashMap)retained).occupiedWithData;
                LongObjectHashMap.this.occupiedWithSentinels = ((LongObjectHashMap)retained).occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(long ... source) {
            return this.retainAll(LongHashSet.newSetWith(source));
        }

        public void clear() {
            LongObjectHashMap.this.clear();
        }

        public MutableLongSet select(LongPredicate predicate) {
            LongHashSet result = new LongHashSet();
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    result.add(0L);
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    result.add(1L);
                }
            }
            for (long key : LongObjectHashMap.this.keys) {
                if (!LongObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableLongSet reject(LongPredicate predicate) {
            LongHashSet result = new LongHashSet();
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0L)) {
                    result.add(0L);
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1L)) {
                    result.add(1L);
                }
            }
            for (long key : LongObjectHashMap.this.keys) {
                if (!LongObjectHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableLongSet with(long element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableLongSet without(long element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableLongSet withAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableLongSet withoutAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public long detectIfNone(LongPredicate predicate, long ifNone) {
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return 0L;
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return 1L;
                }
            }
            for (long key : LongObjectHashMap.this.keys) {
                if (!LongObjectHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0L));
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1L));
                }
            }
            for (long key : LongObjectHashMap.this.keys) {
                if (!LongObjectHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableLongSet asUnmodifiable() {
            return UnmodifiableLongSet.of(this);
        }

        public MutableLongSet asSynchronized() {
            return SynchronizedLongSet.of(this);
        }

        public long sum() {
            long result = 0L;
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (long key : LongObjectHashMap.this.keys) {
                if (!LongObjectHashMap.isNonSentinel(key)) continue;
                result += key;
            }
            return result;
        }

        public long max() {
            if (LongObjectHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long max = 0L;
            boolean isMaxSet = false;
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0L;
                    isMaxSet = true;
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey) {
                    max = 1L;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < LongObjectHashMap.this.keys.length; ++i) {
                if (!LongObjectHashMap.isNonSentinel(LongObjectHashMap.this.keys[i]) || isMaxSet && max >= LongObjectHashMap.this.keys[i]) continue;
                max = LongObjectHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public long maxIfEmpty(long defaultValue) {
            if (LongObjectHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public long min() {
            if (LongObjectHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long min = 0L;
            boolean isMinSet = false;
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0L;
                    isMinSet = true;
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey && !isMinSet) {
                    min = 1L;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < LongObjectHashMap.this.keys.length; ++i) {
                if (!LongObjectHashMap.isNonSentinel(LongObjectHashMap.this.keys[i]) || isMinSet && LongObjectHashMap.this.keys[i] >= min) continue;
                min = LongObjectHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public long minIfEmpty(long defaultValue) {
            if (LongObjectHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (LongObjectHashMap.this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (LongObjectHashMap.this.isEmpty()) {
                throw new ArithmeticException();
            }
            long[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                long first = sortedArray[middleIndex];
                long second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public long[] toSortedArray() {
            long[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableLongList toSortedList() {
            return LongArrayList.newList((LongIterable)this).sortThis();
        }

        public long[] toArray() {
            int size = LongObjectHashMap.this.size();
            final long[] result = new long[size];
            LongObjectHashMap.this.forEachKey(new LongProcedure(){
                private int index;

                public void value(long each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(long value) {
            return LongObjectHashMap.this.containsKey(value);
        }

        public boolean containsAll(long ... source) {
            for (long item : source) {
                if (LongObjectHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(LongIterable source) {
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                if (LongObjectHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableLongList toList() {
            return LongArrayList.newList((LongIterable)this);
        }

        public MutableLongSet toSet() {
            return LongHashSet.newSet((LongIterable)this);
        }

        public MutableLongBag toBag() {
            return LongHashBag.newBag((LongIterable)this);
        }

        public LazyLongIterable asLazy() {
            return new LazyLongIterableAdapter((LongIterable)this);
        }

        public LongSet freeze() {
            LongObjectHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (LongObjectHashMap.this.sentinelValues != null) {
                containsZeroKey = LongObjectHashMap.this.sentinelValues.containsZeroKey;
                containsOneKey = LongObjectHashMap.this.sentinelValues.containsOneKey;
            }
            return new ImmutableLongMapKeySet(LongObjectHashMap.this.keys, LongObjectHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        public ImmutableLongSet toImmutable() {
            return LongSets.immutable.withAll((LongIterable)this);
        }

        public int size() {
            return LongObjectHashMap.this.size();
        }

        public boolean isEmpty() {
            return LongObjectHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return LongObjectHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LongSet)) {
                return false;
            }
            LongSet other = (LongSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (LongObjectHashMap.this.sentinelValues != null) {
                if (LongObjectHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (LongObjectHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < LongObjectHashMap.this.keys.length; ++i) {
                if (!LongObjectHashMap.isNonSentinel(LongObjectHashMap.this.keys[i])) continue;
                result += (int)(LongObjectHashMap.this.keys[i] ^ LongObjectHashMap.this.keys[i] >>> 32);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (LongObjectHashMap.this.sentinelValues != null) {
                    if (LongObjectHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0L));
                        first = false;
                    }
                    if (LongObjectHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1L));
                        first = false;
                    }
                }
                for (long key : LongObjectHashMap.this.keys) {
                    if (!LongObjectHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ boolean lambda$retainAll$9bd826c3$1(LongSet sourceSet, long key, Object value) {
            return sourceSet.contains(key);
        }
    }

    private class InternalIterator
    implements Iterator<V> {
        private int count;
        private int position;
        private long currentKey;
        private boolean isCurrentKeySet;
        private boolean handledZeroKey;
        private boolean handledOneKey;

        private InternalIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count != LongObjectHashMap.this.size();
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.count;
            if (!this.handledZeroKey) {
                this.handledZeroKey = true;
                if (LongObjectHashMap.this.containsKey(0L)) {
                    this.currentKey = 0L;
                    this.isCurrentKeySet = true;
                    return LongObjectHashMap.this.sentinelValues.zeroValue;
                }
            }
            if (!this.handledOneKey) {
                this.handledOneKey = true;
                if (LongObjectHashMap.this.containsKey(1L)) {
                    this.currentKey = 1L;
                    this.isCurrentKeySet = true;
                    return LongObjectHashMap.this.sentinelValues.oneValue;
                }
            }
            long[] keys = LongObjectHashMap.this.keys;
            while (!LongObjectHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.currentKey = LongObjectHashMap.this.keys[this.position];
            this.isCurrentKeySet = true;
            Object result = LongObjectHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        @Override
        public void remove() {
            if (!this.isCurrentKeySet) {
                throw new IllegalStateException();
            }
            this.isCurrentKeySet = false;
            --this.count;
            if (LongObjectHashMap.isNonSentinel(this.currentKey)) {
                int index = this.position - 1;
                LongObjectHashMap.this.removeKeyAtIndex(index);
            } else {
                LongObjectHashMap.this.removeKey(this.currentKey);
            }
        }
    }

    private static final class SentinelValues<V> {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private V zeroValue;
        private V oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(V value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && LongObjectHashMap.nullSafeEquals(this.zeroValue, value);
            boolean valueEqualsOneValue = this.containsOneKey && LongObjectHashMap.nullSafeEquals(this.oneValue, value);
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

