/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.fixed;

import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.factory.set.FixedSizeSetFactory;
import org.eclipse.collections.api.set.FixedSizeSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.set.fixed.DoubletonSet;
import org.eclipse.collections.impl.set.fixed.EmptySet;
import org.eclipse.collections.impl.set.fixed.QuadrupletonSet;
import org.eclipse.collections.impl.set.fixed.SingletonSet;
import org.eclipse.collections.impl.set.fixed.TripletonSet;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;

@Immutable
public class FixedSizeSetFactoryImpl
implements FixedSizeSetFactory {
    private static final FixedSizeSet<?> EMPTY_SET = new EmptySet();

    public <T> FixedSizeSet<T> empty() {
        return EMPTY_SET;
    }

    public <T> FixedSizeSet<T> of() {
        return this.empty();
    }

    public <T> FixedSizeSet<T> with() {
        return this.empty();
    }

    public <T> FixedSizeSet<T> of(T one) {
        return this.with(one);
    }

    public <T> FixedSizeSet<T> with(T one) {
        return new SingletonSet<T>(one);
    }

    public <T> FixedSizeSet<T> of(T one, T two) {
        return this.with(one, two);
    }

    public <T> FixedSizeSet<T> with(T one, T two) {
        if (Comparators.nullSafeEquals(one, two)) {
            return this.of(one);
        }
        return new DoubletonSet<T>(one, two);
    }

    public <T> FixedSizeSet<T> of(T one, T two, T three) {
        return this.with(one, two, three);
    }

    public <T> FixedSizeSet<T> with(T one, T two, T three) {
        if (Comparators.nullSafeEquals(one, two)) {
            return this.of(one, three);
        }
        if (Comparators.nullSafeEquals(one, three)) {
            return this.of(one, two);
        }
        if (Comparators.nullSafeEquals(two, three)) {
            return this.of(one, two);
        }
        return new TripletonSet<T>(one, two, three);
    }

    public <T> FixedSizeSet<T> of(T one, T two, T three, T four) {
        return this.with(one, two, three, four);
    }

    public <T> FixedSizeSet<T> with(T one, T two, T three, T four) {
        if (Comparators.nullSafeEquals(one, two)) {
            return this.of(one, three, four);
        }
        if (Comparators.nullSafeEquals(one, three)) {
            return this.of(one, two, four);
        }
        if (Comparators.nullSafeEquals(one, four)) {
            return this.of(one, two, three);
        }
        if (Comparators.nullSafeEquals(two, three)) {
            return this.of(one, two, four);
        }
        if (Comparators.nullSafeEquals(two, four)) {
            return this.of(one, two, three);
        }
        if (Comparators.nullSafeEquals(three, four)) {
            return this.of(one, two, three);
        }
        return new QuadrupletonSet<T>(one, two, three, four);
    }

    public <T> MutableSet<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    public <T> MutableSet<T> withAll(Iterable<? extends T> items) {
        UnifiedSet<T> set = UnifiedSet.newSet(items);
        switch (set.size()) {
            case 0: {
                return new EmptySet();
            }
            case 1: {
                Object[] itemArray = set.toArray();
                return new SingletonSet<Object>(itemArray[0]);
            }
            case 2: {
                Object[] itemArray = set.toArray();
                return new DoubletonSet<Object>(itemArray[0], itemArray[1]);
            }
            case 3: {
                Object[] itemArray = set.toArray();
                return new TripletonSet<Object>(itemArray[0], itemArray[1], itemArray[2]);
            }
            case 4: {
                Object[] itemArray = set.toArray();
                return new QuadrupletonSet<Object>(itemArray[0], itemArray[1], itemArray[2], itemArray[3]);
            }
        }
        return set;
    }
}

