/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToCharFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToIntFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToShortFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.block.factory.primitive.ShortPredicates;
import org.eclipse.collections.impl.factory.primitive.ShortSets;
import org.eclipse.collections.impl.lazy.primitive.CollectShortToBooleanIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectShortToByteIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectShortToCharIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectShortToDoubleIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectShortToFloatIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectShortToIntIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectShortToLongIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectShortToShortIterable;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.utility.internal.primitive.ShortIterableIterate;
import org.eclipse.collections.impl.utility.primitive.LazyShortIterate;

public abstract class AbstractLazyShortIterable
implements LazyShortIterable {
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public int size() {
        return this.count(ShortPredicates.alwaysTrue());
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty() {
        return ShortIterableIterate.isEmpty((ShortIterable)this);
    }

    public boolean notEmpty() {
        return ShortIterableIterate.notEmpty((ShortIterable)this);
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        ShortIterableIterate.appendString((ShortIterable)this, appendable, start, separator, end);
    }

    public boolean contains(short value) {
        return this.anySatisfy(ShortPredicates.equal(value));
    }

    public boolean containsAll(short ... source) {
        return this.containsAll((ShortIterable)ShortSets.immutable.of(source));
    }

    public boolean containsAll(ShortIterable source) {
        return source.allSatisfy((ShortPredicate & Serializable)value -> this.contains(value));
    }

    public LazyShortIterable select(ShortPredicate predicate) {
        return LazyShortIterate.select((ShortIterable)this, predicate);
    }

    public LazyShortIterable reject(ShortPredicate predicate) {
        return LazyShortIterate.select((ShortIterable)this, ShortPredicates.not(predicate));
    }

    public LazyShortIterable tap(ShortProcedure procedure) {
        return LazyShortIterate.tap((ShortIterable)this, procedure);
    }

    public <V> LazyIterable<V> collect(ShortToObjectFunction<? extends V> function) {
        return LazyShortIterate.collect((ShortIterable)this, function);
    }

    public <V> LazyIterable<V> flatCollect(ShortToObjectFunction<? extends Iterable<V>> function) {
        return LazyShortIterate.flatCollect((ShortIterable)this, function);
    }

    public LazyBooleanIterable collectBoolean(ShortToBooleanFunction function) {
        return new CollectShortToBooleanIterable((ShortIterable)this, function);
    }

    public LazyByteIterable collectByte(ShortToByteFunction function) {
        return new CollectShortToByteIterable((ShortIterable)this, function);
    }

    public LazyCharIterable collectChar(ShortToCharFunction function) {
        return new CollectShortToCharIterable((ShortIterable)this, function);
    }

    public LazyShortIterable collectShort(ShortToShortFunction function) {
        return new CollectShortToShortIterable((ShortIterable)this, function);
    }

    public LazyIntIterable collectInt(ShortToIntFunction function) {
        return new CollectShortToIntIterable((ShortIterable)this, function);
    }

    public LazyFloatIterable collectFloat(ShortToFloatFunction function) {
        return new CollectShortToFloatIterable((ShortIterable)this, function);
    }

    public LazyLongIterable collectLong(ShortToLongFunction function) {
        return new CollectShortToLongIterable((ShortIterable)this, function);
    }

    public LazyDoubleIterable collectDouble(ShortToDoubleFunction function) {
        return new CollectShortToDoubleIterable((ShortIterable)this, function);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return ShortIterableIterate.detectIfNone((ShortIterable)this, predicate, ifNone);
    }

    public int count(ShortPredicate predicate) {
        return ShortIterableIterate.count((ShortIterable)this, predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return ShortIterableIterate.anySatisfy((ShortIterable)this, predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return ShortIterableIterate.allSatisfy((ShortIterable)this, predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return ShortIterableIterate.noneSatisfy((ShortIterable)this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return ShortIterableIterate.injectInto((ShortIterable)this, injectedValue, function);
    }

    public short[] toArray() {
        return this.toList().toArray();
    }

    public MutableShortList toList() {
        ShortArrayList list = new ShortArrayList();
        this.forEach(arg_0 -> ((MutableShortList)list).add(arg_0));
        return list;
    }

    public MutableShortSet toSet() {
        ShortHashSet set = new ShortHashSet();
        this.forEach(arg_0 -> ((MutableShortSet)set).add(arg_0));
        return set;
    }

    public MutableShortBag toBag() {
        ShortHashBag bag = new ShortHashBag();
        this.forEach(arg_0 -> ((MutableShortBag)bag).add(arg_0));
        return bag;
    }

    public long sum() {
        ShortSumProcedure procedure = new ShortSumProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public short max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ShortMaxProcedure procedure = new ShortMaxProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public short maxIfEmpty(short ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.max();
    }

    public short min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ShortMinProcedure procedure = new ShortMinProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public short minIfEmpty(short ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public short[] toSortedArray() {
        return this.toSortedList().toArray();
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newList((ShortIterable)this).sortThis();
    }

    public LazyShortIterable asLazy() {
        return this;
    }

    private static final class ShortSumProcedure
    implements ShortProcedure {
        private short sum = 0;

        private ShortSumProcedure() {
        }

        public void value(short each) {
            this.sum = (short)(this.sum + each);
        }

        public short getValue() {
            return this.sum;
        }
    }

    private static final class ShortMinProcedure
    implements ShortProcedure {
        private boolean visitedOnce;
        private short min;

        private ShortMinProcedure() {
        }

        public void value(short each) {
            if (this.visitedOnce) {
                if (each < this.min) {
                    this.min = each;
                }
            } else {
                this.min = each;
                this.visitedOnce = true;
            }
        }

        public short getValue() {
            return this.min;
        }
    }

    private static final class ShortMaxProcedure
    implements ShortProcedure {
        private boolean visitedOnce;
        private short max;

        private ShortMaxProcedure() {
        }

        public void value(short each) {
            if (this.visitedOnce) {
                if (this.max < each) {
                    this.max = each;
                }
            } else {
                this.max = each;
                this.visitedOnce = true;
            }
        }

        public short getValue() {
            return this.max;
        }
    }
}

