/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatBytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.FloatByteMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteFloatMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatByteMap;
import org.eclipse.collections.api.map.primitive.MutableByteFloatMap;
import org.eclipse.collections.api.map.primitive.MutableFloatByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.FloatBytePair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedFloatByteProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.primitive.ByteFloatMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.map.mutable.primitive.FloatByteHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;

final class ImmutableFloatByteHashMap
implements ImmutableFloatByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableFloatByteMap delegate;

    ImmutableFloatByteHashMap(FloatByteMap delegate) {
        this.delegate = new FloatByteHashMap(delegate);
    }

    public byte get(float key) {
        return this.delegate.get(key);
    }

    public byte getIfAbsent(float key, byte ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public byte getOrThrow(float key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(float key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(byte value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatByteProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<FloatBytePair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableByteFloatMap flipUniqueValues() {
        MutableByteFloatMap result = ByteFloatMaps.mutable.empty();
        this.forEachKeyValue((FloatByteProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    public ImmutableFloatByteMap select(FloatBytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatByteMap reject(FloatBytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableFloatByteMap toImmutable() {
        return this;
    }

    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator((ByteIterator)this.delegate.byteIterator());
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(BytePredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableByteBag select(BytePredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteBag reject(BytePredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public byte max() {
        return this.delegate.max();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public byte min() {
        return this.delegate.min();
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public byte[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableByteList toSortedList() {
        return this.delegate.toSortedList();
    }

    public byte[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(byte value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(byte ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ByteIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableByteList toList() {
        return this.delegate.toList();
    }

    public MutableByteSet toSet() {
        return this.delegate.toSet();
    }

    public MutableByteBag toBag() {
        return this.delegate.toBag();
    }

    public LazyByteIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableFloatByteMap newWithKeyValue(float key, byte value) {
        FloatByteHashMap map = new FloatByteHashMap(this.size() + 1);
        map.putAll((FloatByteMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableFloatByteMap newWithoutKey(float key) {
        FloatByteHashMap map = new FloatByteHashMap(this.size());
        map.putAll((FloatByteMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableFloatByteMap newWithoutAllKeys(FloatIterable keys) {
        FloatByteHashMap map = new FloatByteHashMap(this.size());
        map.putAll((FloatByteMap)this);
        FloatIterator iterator = keys.floatIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(this.delegate.keySet());
    }

    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableFloatByteMapSerializationProxy((FloatByteMap)this);
    }

    protected static class ImmutableFloatByteMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private FloatByteMap map;

        public ImmutableFloatByteMapSerializationProxy() {
        }

        protected ImmutableFloatByteMapSerializationProxy(FloatByteMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((FloatByteProcedure)new CheckedFloatByteProcedure(){

                    @Override
                    public void safeValue(float key, byte value) throws IOException {
                        out.writeFloat(key);
                        out.writeByte(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            FloatByteHashMap deserializedMap = new FloatByteHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readFloat(), in.readByte());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

