/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectCharPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectCharProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.ImmutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.MutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.ObjectCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.ObjectCharPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.primitive.CharObjectMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.map.immutable.primitive.AbstractImmutableObjectCharMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectCharHashMap;
import org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;

final class ImmutableObjectCharHashMap<K>
extends AbstractImmutableObjectCharMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectCharMap<K> delegate;

    ImmutableObjectCharHashMap(ObjectCharMap<? extends K> delegate) {
        this.delegate = new ObjectCharHashMap<K>(delegate);
    }

    public CharIterator charIterator() {
        return new UnmodifiableCharIterator((CharIterator)this.delegate.charIterator());
    }

    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    public void each(CharProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(CharPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableCharCollection select(CharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharCollection reject(CharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        MutableCollection collection = this.delegate.collect(function);
        return collection.toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public char max() {
        return this.delegate.max();
    }

    public char maxIfEmpty(char defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public char min() {
        return this.delegate.min();
    }

    public char minIfEmpty(char defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public char[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableCharList toSortedList() {
        return this.delegate.toSortedList();
    }

    public char[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(char value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(char ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(CharIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableCharList toList() {
        return this.delegate.toList();
    }

    public MutableCharSet toSet() {
        return this.delegate.toSet();
    }

    public MutableCharBag toBag() {
        return this.delegate.toBag();
    }

    public LazyCharIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableObjectCharMap<K> newWithKeyValue(K key, char value) {
        ObjectCharHashMap<K> map = ObjectCharHashMap.newMap();
        map.putAll((ObjectCharMap<K>)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableObjectCharMap<K> newWithoutKey(K key) {
        ObjectCharHashMap<K> map = ObjectCharHashMap.newMap();
        map.putAll((ObjectCharMap<K>)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableObjectCharMap<K> newWithoutAllKeys(Iterable<? extends K> keys) {
        ObjectCharHashMap<K> map = ObjectCharHashMap.newMap();
        map.putAll((ObjectCharMap<K>)this);
        Iterator<K> iterator = keys.iterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public char get(Object key) {
        return this.delegate.get(key);
    }

    public char getOrThrow(Object key) {
        return this.delegate.getOrThrow(key);
    }

    public char getIfAbsent(Object key, char ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(char value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(CharProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectCharProcedure<? super K> objectCharProcedure) {
        this.delegate.forEachKeyValue(objectCharProcedure);
    }

    public ImmutableObjectCharMap<K> select(ObjectCharPredicate<? super K> objectCharPredicate) {
        return this.delegate.select(objectCharPredicate).toImmutable();
    }

    public ImmutableObjectCharMap<K> reject(ObjectCharPredicate<? super K> objectCharPredicate) {
        return this.delegate.reject(objectCharPredicate).toImmutable();
    }

    public ImmutableObjectCharMap<K> toImmutable() {
        return this;
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public Set<K> keySet() {
        return UnmodifiableMutableSet.of(this.delegate.keySet());
    }

    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of(this.delegate.values());
    }

    public LazyIterable<K> keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<ObjectCharPair<K>> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableCharObjectMap<K> flipUniqueValues() {
        MutableCharObjectMap result = CharObjectMaps.mutable.empty();
        this.forEachKeyValue((ObjectCharProcedure & Serializable)(key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result.toImmutable();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectCharMap.ImmutableObjectCharMapSerializationProxy(this);
    }
}

