/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.stream.LongStream;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.set.primitive.MutableLongSetFactory;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;

public enum MutableLongSetFactoryImpl implements MutableLongSetFactory
{
    INSTANCE;


    public MutableLongSet empty() {
        return new LongHashSet();
    }

    public MutableLongSet of() {
        return this.empty();
    }

    public MutableLongSet with() {
        return this.empty();
    }

    public MutableLongSet of(long ... items) {
        return this.with(items);
    }

    public MutableLongSet with(long ... items) {
        if (items == null || items.length == 0) {
            return this.empty();
        }
        return LongHashSet.newSetWith(items);
    }

    public MutableLongSet ofAll(LongIterable items) {
        return this.withAll(items);
    }

    public MutableLongSet withAll(LongIterable items) {
        return LongHashSet.newSet(items);
    }

    public MutableLongSet ofAll(LongStream items) {
        return this.withAll(items);
    }

    public MutableLongSet withAll(LongStream items) {
        return this.with(items.toArray());
    }
}

