/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableShortListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableShortArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableShortEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableShortSingletonList;

public enum ImmutableShortListFactoryImpl implements ImmutableShortListFactory
{
    INSTANCE;


    public ImmutableShortList empty() {
        return ImmutableShortEmptyList.INSTANCE;
    }

    public ImmutableShortList of() {
        return this.empty();
    }

    public ImmutableShortList with() {
        return this.empty();
    }

    public ImmutableShortList of(short one) {
        return this.with(one);
    }

    public ImmutableShortList with(short one) {
        return new ImmutableShortSingletonList(one);
    }

    public ImmutableShortList of(short ... items) {
        return this.with(items);
    }

    public ImmutableShortList with(short ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableShortArrayList.newListWith(items);
    }

    public ImmutableShortList ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    public ImmutableShortList withAll(ShortIterable items) {
        if (items instanceof ImmutableShortList) {
            return (ImmutableShortList)items;
        }
        return this.with(items.toArray());
    }
}

