/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven.shared;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.ebr.maven.shared.BaseUtility;
import org.osgi.framework.Version;

public class BundleUtil
extends BaseUtility {
    public static String getBundleSymbolicName(MavenProject project) {
        return project.getArtifactId();
    }

    public static String getBundleVersion(String version) {
        if (version.endsWith("-SNAPSHOT")) {
            return version.replace("-SNAPSHOT", ".qualifier");
        }
        return version;
    }

    public static String getExpandedVersion(String bundleVersion, String qualifier) {
        Version version = Version.parseVersion((String)bundleVersion);
        return new Version(version.getMajor(), version.getMinor(), version.getMicro(), qualifier).toString();
    }

    public static String getSourceBundleSymbolicName(MavenProject project) {
        return BundleUtil.getBundleSymbolicName(project) + ".source";
    }

    public BundleUtil(Log log, MavenSession mavenSession) {
        super(log, mavenSession);
    }
}

