/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven.shared;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.ebr.maven.shared.BaseUtility;

public class TemplateHelper
extends BaseUtility {
    private final ClassLoader resourceLoader;

    public TemplateHelper(Log log, Class<?> resourceLoaderScope) {
        super(log, null);
        this.resourceLoader = resourceLoaderScope.getClassLoader();
    }

    public InputStream openTemplate(String name) throws FileNotFoundException {
        InputStream is = this.resourceLoader.getResourceAsStream(name);
        if (is == null) {
            throw new FileNotFoundException(String.format("Template '%s' cannot be found! Please check the plug-in packaging.", name));
        }
        return is;
    }

    public String readTemplateAsString(String name) throws MojoExecutionException {
        try {
            return IOUtils.toString((InputStream)this.openTemplate(name), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Error reading template '%s': %s", name, e.getMessage()));
        }
    }
}

