/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.jetty.util.IntrospectionUtil;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;

public class Injection {
    private Class _targetClass;
    private String _jndiName;
    private String _mappingName;
    private Member _target;
    private String _className;
    private String _fieldName;
    private String _methodName;
    private String _paramCanonicalName;
    private String _annotationResourceType;

    public Class getTargetClass() {
        return this._targetClass;
    }

    public String getTargetClassName() {
        return this._className;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public String getParamCanonicalName() {
        return this._paramCanonicalName;
    }

    public boolean isField() {
        return this._fieldName != null;
    }

    public boolean isMethod() {
        return this._methodName != null;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setJndiName(String jndiName) {
        this._jndiName = jndiName;
    }

    public String getMappingName() {
        return this._mappingName;
    }

    public void setMappingName(String mappingName) {
        this._mappingName = mappingName;
    }

    public Member getTarget() {
        return this._target;
    }

    public void setTarget(String className, String fieldName, String annotationResourceType) {
        this._className = className;
        this._fieldName = fieldName;
        this._annotationResourceType = annotationResourceType;
    }

    public void setTarget(String className, String methodName, String paramCanonicalName, String annotationResourceType) {
        this._className = className;
        this._methodName = methodName;
        this._paramCanonicalName = paramCanonicalName;
        this._annotationResourceType = annotationResourceType;
    }

    public void setTarget(Class clazz, String targetName, Class targetType) {
        String setter = "set" + targetName.substring(0, 1).toUpperCase() + targetName.substring(1);
        try {
            Log.debug("Looking for method for setter: " + setter + " with arg " + targetType);
            this._target = IntrospectionUtil.findMethod(clazz, setter, new Class[]{targetType}, true, false);
            this._targetClass = clazz;
            this._className = clazz.getCanonicalName();
            this._methodName = targetName;
            this._paramCanonicalName = targetType.getCanonicalName();
        }
        catch (NoSuchMethodException me) {
            try {
                this._target = IntrospectionUtil.findField(clazz, targetName, targetType, true, false);
                this._targetClass = clazz;
                this._className = clazz.getCanonicalName();
                this._fieldName = targetName;
            }
            catch (NoSuchFieldException fe) {
                throw new IllegalArgumentException("No such field or method " + targetName + " on class " + this._targetClass);
            }
        }
    }

    public void inject(Object injectable) {
        try {
            if (this._target == null) {
                this.loadField();
            }
            if (this._target == null) {
                this.loadMethod();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (this._target != null) {
            if (this._target instanceof Field) {
                this.injectField((Field)this._target, injectable);
            } else {
                this.injectMethod((Method)this._target, injectable);
            }
        } else {
            throw new IllegalStateException("No method or field to inject with " + this.getJndiName());
        }
    }

    public Object lookupInjectedValue() throws NamingException {
        InitialContext context = new InitialContext();
        return context.lookup("java:comp/env/" + this.getJndiName());
    }

    protected void injectField(Field field, Object injectable) {
        if (this.validateInjection()) {
            try {
                boolean accessibility = field.isAccessible();
                field.setAccessible(true);
                field.set(injectable, this.lookupInjectedValue());
                field.setAccessible(accessibility);
            }
            catch (Exception e) {
                Log.warn(e);
                throw new IllegalStateException("Inject failed for field " + field.getName());
            }
        } else {
            throw new IllegalStateException("Invalid injection for " + this._className + "." + this._fieldName);
        }
    }

    protected void injectMethod(Method method, Object injectable) {
        if (this.validateInjection()) {
            try {
                boolean accessibility = method.isAccessible();
                method.setAccessible(true);
                method.invoke(injectable, this.lookupInjectedValue());
                method.setAccessible(accessibility);
            }
            catch (Exception e) {
                Log.warn(e);
                throw new IllegalStateException("Inject failed for method " + method.getName());
            }
        } else {
            throw new IllegalStateException("Invalid injection for " + this._className + "." + this._methodName);
        }
    }

    protected void loadField() throws ClassNotFoundException, NoSuchFieldException {
        if (this._fieldName == null || this._className == null) {
            return;
        }
        if (this._targetClass == null) {
            this._targetClass = Loader.loadClass(null, this._className);
        }
        this._target = this._targetClass.getDeclaredField(this._fieldName);
    }

    protected void loadMethod() throws ClassNotFoundException, NoSuchMethodException {
        Class arg;
        if (this._methodName == null || this._className == null) {
            return;
        }
        if (this._targetClass == null) {
            this._targetClass = Loader.loadClass(null, this._className);
        }
        if ((arg = TypeUtil.fromName(this._paramCanonicalName)) == null) {
            arg = Loader.loadClass(null, this._paramCanonicalName);
        }
        this._target = this._targetClass.getDeclaredMethod(this._methodName, arg);
    }

    private boolean validateInjection() {
        if (this._annotationResourceType != null) {
            if (this._target == null) {
                return false;
            }
            try {
                Class annotationType = TypeUtil.fromName(this._annotationResourceType);
                if (annotationType == null) {
                    annotationType = Loader.loadClass(null, this._annotationResourceType);
                }
                if (this._target instanceof Field) {
                    return ((Field)this._target).getType().isAssignableFrom(annotationType);
                }
                if (this._target instanceof Method) {
                    Class<?>[] args = ((Method)this._target).getParameterTypes();
                    return args[0].isAssignableFrom(annotationType);
                }
                return false;
            }
            catch (Exception e) {
                Log.warn("Unable to verify injection for " + this._className + "." + (this._fieldName == null ? this._methodName : this._fieldName));
                return false;
            }
        }
        return true;
    }
}

