/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.util.EventListener;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.util.log.Log;

public class SessionHandler
extends ScopedHandler {
    private SessionManager _sessionManager;

    public SessionHandler() {
        this(new HashSessionManager());
    }

    public SessionHandler(SessionManager manager) {
        this.setSessionManager(manager);
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        SessionManager old_session_manager = this._sessionManager;
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, old_session_manager, sessionManager, "sessionManager", true);
        }
        if (sessionManager != null) {
            sessionManager.setSessionHandler(this);
        }
        this._sessionManager = sessionManager;
        if (old_session_manager != null) {
            old_session_manager.setSessionHandler(null);
        }
    }

    public void setServer(Server server) {
        Server old_server = this.getServer();
        if (old_server != null && old_server != server) {
            old_server.getContainer().update((Object)this, this._sessionManager, null, "sessionManager", true);
        }
        super.setServer(server);
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, this._sessionManager, "sessionManager", true);
        }
    }

    protected void doStart() throws Exception {
        this._sessionManager.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._sessionManager.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block18: {
            this.setRequestedId(baseRequest, request);
            SessionManager old_session_manager = null;
            HttpSession old_session = null;
            try {
                old_session_manager = baseRequest.getSessionManager();
                old_session = baseRequest.getSession(false);
                if (old_session_manager != this._sessionManager) {
                    baseRequest.setSessionManager(this._sessionManager);
                    baseRequest.setSession(null);
                }
                HttpSession session = null;
                if (this._sessionManager != null) {
                    session = baseRequest.getSession(false);
                    if (session != null) {
                        HttpCookie cookie;
                        if (session != old_session && (cookie = this._sessionManager.access(session, request.isSecure())) != null) {
                            baseRequest.getResponse().addCookie(cookie);
                        }
                    } else {
                        session = baseRequest.recoverNewSession(this._sessionManager);
                        if (session != null) {
                            baseRequest.setSession(session);
                        }
                    }
                }
                if (Log.isDebugEnabled()) {
                    Log.debug("sessionManager=" + this._sessionManager);
                    Log.debug("session=" + session);
                }
                if (this._nextScope != null) {
                    this._nextScope.doScope(target, baseRequest, request, response);
                } else if (this._outerScope != null) {
                    this._outerScope.doHandle(target, baseRequest, request, response);
                } else {
                    this.doHandle(target, baseRequest, request, response);
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                HttpSession session = request.getSession(false);
                if (old_session_manager != this._sessionManager) {
                    if (session != null) {
                        this._sessionManager.complete(session);
                    }
                    if (old_session_manager != null) {
                        baseRequest.setSessionManager(old_session_manager);
                        baseRequest.setSession(old_session);
                    }
                }
                throw throwable;
            }
            HttpSession session = request.getSession(false);
            if (old_session_manager == this._sessionManager) break block18;
            if (session != null) {
                this._sessionManager.complete(session);
            }
            if (old_session_manager != null) {
                baseRequest.setSessionManager(old_session_manager);
                baseRequest.setSession(old_session);
            }
        }
    }

    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.never()) {
            this.nextHandle(target, baseRequest, request, response);
        } else if (this._nextScope != null && this._nextScope == this._handler) {
            this._nextScope.doHandle(target, baseRequest, request, response);
        } else if (this._handler != null) {
            this._handler.handle(target, baseRequest, request, response);
        }
    }

    protected void setRequestedId(Request baseRequest, HttpServletRequest request) {
        Cookie[] cookies;
        String requested_session_id = request.getRequestedSessionId();
        if (!DispatcherType.REQUEST.equals((Object)baseRequest.getDispatcherType()) || requested_session_id != null) {
            return;
        }
        SessionManager sessionManager = this.getSessionManager();
        boolean requested_session_id_from_cookie = false;
        HttpSession session = null;
        if (this._sessionManager.isUsingCookies() && (cookies = request.getCookies()) != null && cookies.length > 0) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!sessionManager.getSessionCookie().equalsIgnoreCase(cookies[i].getName())) continue;
                if (requested_session_id != null && sessionManager.getHttpSession(requested_session_id) != null) break;
                requested_session_id = cookies[i].getValue();
                requested_session_id_from_cookie = true;
                if (Log.isDebugEnabled()) {
                    Log.debug("Got Session ID " + requested_session_id + " from cookie");
                }
                if ((session = sessionManager.getHttpSession(requested_session_id)) == null) continue;
                baseRequest.setSession(session);
            }
        }
        if (requested_session_id == null || session == null) {
            int s;
            String uri = request.getRequestURI();
            String prefix = sessionManager.getSessionIdPathParameterNamePrefix();
            if (prefix != null && (s = uri.indexOf(prefix)) >= 0) {
                char c;
                int i;
                for (i = s += prefix.length(); i < uri.length() && (c = uri.charAt(i)) != ';' && c != '#' && c != '?' && c != '/'; ++i) {
                }
                requested_session_id = uri.substring(s, i);
                requested_session_id_from_cookie = false;
                if (Log.isDebugEnabled()) {
                    Log.debug("Got Session ID " + requested_session_id + " from URL");
                }
            }
        }
        baseRequest.setRequestedSessionId(requested_session_id);
        baseRequest.setRequestedSessionIdFromCookie(requested_session_id != null && requested_session_id_from_cookie);
    }

    public void addEventListener(EventListener listener) {
        if (this._sessionManager != null) {
            this._sessionManager.addEventListener(listener);
        }
    }

    public void clearEventListeners() {
        if (this._sessionManager != null) {
            this._sessionManager.clearEventListeners();
        }
    }
}

