/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.hpack;

import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.hpack.AuthorityHttpField;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.http2.hpack.StaticTableHttpField;

public class MetaDataBuilder {
    private final int _maxSize;
    private int _size;
    private Integer _status;
    private String _method;
    private HttpScheme _scheme;
    private HostPortHttpField _authority;
    private String _path;
    private long _contentLength = Long.MIN_VALUE;
    private HttpFields _fields = new HttpFields();
    private HpackException.StreamException _streamException;
    private boolean _request;
    private boolean _response;

    protected MetaDataBuilder(int maxHeadersSize) {
        this._maxSize = maxHeadersSize;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public int getSize() {
        return this._size;
    }

    public void emit(HttpField field) throws HpackException.SessionException {
        HttpHeader header = field.getHeader();
        String name = field.getName();
        String value = field.getValue();
        int fieldSize = name.length() + (value == null ? 0 : value.length());
        this._size += fieldSize + 32;
        if (this._size > this._maxSize) {
            throw new HpackException.SessionException("Header Size %d > %d", this._size, this._maxSize);
        }
        if (field instanceof StaticTableHttpField) {
            StaticTableHttpField staticField = (StaticTableHttpField)field;
            switch (header) {
                case C_STATUS: {
                    if (this.checkPseudoHeader(header, this._status)) {
                        this._status = (Integer)staticField.getStaticValue();
                    }
                    this._response = true;
                    break;
                }
                case C_METHOD: {
                    if (this.checkPseudoHeader(header, this._method)) {
                        this._method = value;
                    }
                    this._request = true;
                    break;
                }
                case C_SCHEME: {
                    if (this.checkPseudoHeader(header, (Object)this._scheme)) {
                        this._scheme = (HttpScheme)((Object)staticField.getStaticValue());
                    }
                    this._request = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(name);
                }
            }
        } else if (header != null) {
            switch (header) {
                case C_STATUS: {
                    if (this.checkPseudoHeader(header, this._status)) {
                        this._status = field.getIntValue();
                    }
                    this._response = true;
                    break;
                }
                case C_METHOD: {
                    if (this.checkPseudoHeader(header, this._method)) {
                        this._method = value;
                    }
                    this._request = true;
                    break;
                }
                case C_SCHEME: {
                    if (this.checkPseudoHeader(header, (Object)this._scheme) && value != null) {
                        this._scheme = HttpScheme.CACHE.get(value);
                    }
                    this._request = true;
                    break;
                }
                case C_AUTHORITY: {
                    if (this.checkPseudoHeader(header, this._authority)) {
                        if (field instanceof HostPortHttpField) {
                            this._authority = (HostPortHttpField)field;
                        } else if (value != null) {
                            this._authority = new AuthorityHttpField(value);
                        }
                    }
                    this._request = true;
                    break;
                }
                case HOST: {
                    if (this._authority == null) {
                        if (field instanceof HostPortHttpField) {
                            this._authority = (HostPortHttpField)field;
                        } else if (value != null) {
                            this._authority = new AuthorityHttpField(value);
                        }
                    }
                    this._fields.add(field);
                    break;
                }
                case C_PATH: {
                    if (this.checkPseudoHeader(header, this._path)) {
                        if (value != null && value.length() > 0) {
                            this._path = value;
                        } else {
                            this.streamException("No Path", new Object[0]);
                        }
                    }
                    this._request = true;
                    break;
                }
                case CONTENT_LENGTH: {
                    this._contentLength = field.getLongValue();
                    this._fields.add(field);
                    break;
                }
                case TE: {
                    if ("trailers".equalsIgnoreCase(value)) {
                        this._fields.add(field);
                        break;
                    }
                    this.streamException("Unsupported TE value '%s'", value);
                    break;
                }
                case CONNECTION: {
                    if ("TE".equalsIgnoreCase(value)) {
                        this._fields.add(field);
                        break;
                    }
                    this.streamException("Connection specific field '%s'", new Object[]{header});
                    break;
                }
                default: {
                    if (name.charAt(0) == ':') {
                        this.streamException("Unknown pseudo header '%s'", name);
                        break;
                    }
                    this._fields.add(field);
                    break;
                }
            }
        } else if (name.charAt(0) == ':') {
            this.streamException("Unknown pseudo header '%s'", name);
        } else {
            this._fields.add(field);
        }
    }

    protected void streamException(String messageFormat, Object ... args) {
        HpackException.StreamException stream = new HpackException.StreamException(messageFormat, args);
        if (this._streamException == null) {
            this._streamException = stream;
        } else {
            this._streamException.addSuppressed(stream);
        }
    }

    protected boolean checkPseudoHeader(HttpHeader header, Object value) {
        if (this._fields.size() > 0) {
            this.streamException("Pseudo header %s after fields", header.asString());
            return false;
        }
        if (value == null) {
            return true;
        }
        this.streamException("Duplicate pseudo header %s", header.asString());
        return false;
    }

    public MetaData build() throws HpackException.StreamException {
        if (this._streamException != null) {
            this._streamException.addSuppressed(new Throwable());
            throw this._streamException;
        }
        if (this._request && this._response) {
            throw new HpackException.StreamException("Request and Response headers", new Object[0]);
        }
        HttpFields fields = this._fields;
        try {
            if (this._request) {
                if (this._method == null) {
                    throw new HpackException.StreamException("No Method", new Object[0]);
                }
                if (this._scheme == null) {
                    throw new HpackException.StreamException("No Scheme", new Object[0]);
                }
                if (this._path == null) {
                    throw new HpackException.StreamException("No Path", new Object[0]);
                }
                MetaData.Request request = new MetaData.Request(this._method, this._scheme, this._authority, this._path, HttpVersion.HTTP_2, fields, this._contentLength);
                return request;
            }
            if (this._response) {
                if (this._status == null) {
                    throw new HpackException.StreamException("No Status", new Object[0]);
                }
                MetaData.Response response = new MetaData.Response(HttpVersion.HTTP_2, this._status, fields, this._contentLength);
                return response;
            }
            MetaData metaData = new MetaData(HttpVersion.HTTP_2, fields, this._contentLength);
            return metaData;
        }
        finally {
            this._fields = new HttpFields(Math.max(16, fields.size() + 5));
            this._request = false;
            this._response = false;
            this._status = null;
            this._method = null;
            this._scheme = null;
            this._authority = null;
            this._path = null;
            this._size = 0;
            this._contentLength = Long.MIN_VALUE;
        }
    }

    public void checkSize(int length, boolean huffman) throws HpackException.SessionException {
        if (huffman) {
            length = length * 4 / 3;
        }
        if (this._size + length > this._maxSize) {
            throw new HpackException.SessionException("Header too large %d > %d", this._size + length, this._maxSize);
        }
    }
}

