/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.NegotiatingClientConnectionFactory;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ALPNClientConnectionFactory
extends NegotiatingClientConnectionFactory {
    private static final Logger LOG = Log.getLogger(ALPNClientConnectionFactory.class);
    private final List<ALPNProcessor.Client> processors = new ArrayList<ALPNProcessor.Client>();
    private final Executor executor;
    private final List<String> protocols;

    public ALPNClientConnectionFactory(Executor executor, ClientConnectionFactory connectionFactory, List<String> protocols) {
        super(connectionFactory);
        if (protocols.isEmpty()) {
            throw new IllegalArgumentException("ALPN protocol list cannot be empty");
        }
        this.executor = executor;
        this.protocols = protocols;
        IllegalStateException failure = new IllegalStateException("No Client ALPNProcessors!");
        Iterator<ALPNProcessor.Client> i = ServiceLoader.load(ALPNProcessor.Client.class).iterator();
        while (i.hasNext()) {
            ALPNProcessor.Client processor;
            try {
                processor = i.next();
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(x);
                }
                failure.addSuppressed(x);
                continue;
            }
            try {
                processor.init();
                this.processors.add(processor);
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not initialize " + processor, x);
                }
                failure.addSuppressed(x);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("protocols: {}", protocols);
            LOG.debug("processors: {}", this.processors);
        }
        if (this.processors.isEmpty()) {
            throw failure;
        }
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        SSLEngine engine = (SSLEngine)context.get("ssl.engine");
        for (ALPNProcessor.Client processor : this.processors) {
            if (!processor.appliesTo(engine)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} for {} on {}", processor, engine, endPoint);
            }
            ALPNClientConnection connection = new ALPNClientConnection(endPoint, this.executor, this.getClientConnectionFactory(), engine, context, this.protocols);
            processor.configure(engine, connection);
            return this.customize(connection, context);
        }
        throw new IllegalStateException("No ALPNProcessor for " + engine);
    }
}

