/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public class HttpChannelOverHTTP2
extends HttpChannel {
    private static final Logger LOG = Log.getLogger(HttpChannelOverHTTP2.class);
    private static final HttpField SERVER_VERSION = new PreEncodedHttpField(HttpHeader.SERVER, HttpConfiguration.SERVER_VERSION);
    private static final HttpField POWERED_BY = new PreEncodedHttpField(HttpHeader.X_POWERED_BY, HttpConfiguration.SERVER_VERSION);
    private boolean _expect100Continue;
    private boolean _delayedUntilContent;
    private boolean _handled;

    public HttpChannelOverHTTP2(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransportOverHTTP2 transport) {
        super(connector, configuration, endPoint, transport);
    }

    protected IStream getStream() {
        return this.getHttpTransport().getStream();
    }

    @Override
    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    @Override
    public void setIdleTimeout(long timeoutMs) {
        this.getStream().setIdleTimeout(timeoutMs);
    }

    @Override
    public long getIdleTimeout() {
        return this.getStream().getIdleTimeout();
    }

    public Runnable onRequest(HeadersFrame frame) {
        try {
            String authority;
            MetaData.Request request = (MetaData.Request)frame.getMetaData();
            HttpFields fields = request.getFields();
            if (!fields.contains(HttpHeader.HOST) && (authority = request.getURI().getAuthority()) != null) {
                fields.put("host", authority);
            }
            this._expect100Continue = fields.contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
            HttpFields response = this.getResponse().getHttpFields();
            if (this.getHttpConfiguration().getSendServerVersion()) {
                response.add(SERVER_VERSION);
            }
            if (this.getHttpConfiguration().getSendXPoweredBy()) {
                response.add(POWERED_BY);
            }
            this.onRequest(request);
            boolean endStream = frame.isEndStream();
            if (endStream) {
                this.onContentComplete();
                this.onRequestComplete();
            }
            this._delayedUntilContent = this.getHttpConfiguration().isDelayDispatchUntilContent() && !endStream && !this._expect100Continue;
            boolean bl = this._handled = !this._delayedUntilContent;
            if (LOG.isDebugEnabled()) {
                IStream stream = this.getStream();
                LOG.debug("HTTP2 Request #{}/{}, delayed={}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), this._delayedUntilContent, System.lineSeparator(), request.getMethod(), request.getURI(), request.getHttpVersion(), System.lineSeparator(), fields});
            }
            return this._delayedUntilContent ? null : this;
        }
        catch (BadMessageException x) {
            this.onBadMessage(x.getCode(), x.getReason());
            return null;
        }
        catch (Throwable x) {
            this.onBadMessage(500, null);
            return null;
        }
    }

    public Runnable onPushRequest(MetaData.Request request) {
        try {
            this.onRequest(request);
            this.getRequest().setAttribute("org.eclipse.jetty.pushed", Boolean.TRUE);
            this.onContentComplete();
            this.onRequestComplete();
            if (LOG.isDebugEnabled()) {
                IStream stream = this.getStream();
                LOG.debug("HTTP2 PUSH Request #{}/{}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), request.getMethod(), request.getURI(), request.getHttpVersion(), System.lineSeparator(), request.getFields()});
            }
            return this;
        }
        catch (BadMessageException x) {
            this.onBadMessage(x.getCode(), x.getReason());
            return null;
        }
        catch (Throwable x) {
            this.onBadMessage(500, null);
            return null;
        }
    }

    @Override
    public HttpTransportOverHTTP2 getHttpTransport() {
        return (HttpTransportOverHTTP2)super.getHttpTransport();
    }

    @Override
    public void recycle() {
        this._expect100Continue = false;
        this._delayedUntilContent = false;
        this._handled = false;
        super.recycle();
        this.getHttpTransport().recycle();
    }

    @Override
    protected void commit(MetaData.Response info) {
        super.commit(info);
        if (LOG.isDebugEnabled()) {
            IStream stream = this.getStream();
            LOG.debug("HTTP2 Commit Response #{}/{}:{}{} {} {}{}{}", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), info.getHttpVersion(), info.getStatus(), info.getReason(), System.lineSeparator(), info.getFields()});
        }
    }

    public Runnable onRequestContent(DataFrame frame, final Callback callback) {
        IStream stream = this.getStream();
        if (stream.isReset()) {
            this.consumeInput();
            callback.succeeded();
            return null;
        }
        final ByteBufferPool byteBufferPool = this.getByteBufferPool();
        ByteBuffer original = frame.getData();
        int length = original.remaining();
        final ByteBuffer copy = byteBufferPool.acquire(length, original.isDirect());
        BufferUtil.clearToFill(copy);
        copy.put(original);
        BufferUtil.flipToFlush(copy, 0);
        boolean handle = this.onContent(new HttpInput.Content(copy){

            @Override
            public Invocable.InvocationType getInvocationType() {
                return callback.getInvocationType();
            }

            @Override
            public void succeeded() {
                byteBufferPool.release(copy);
                callback.succeeded();
            }

            @Override
            public void failed(Throwable x) {
                byteBufferPool.release(copy);
                callback.failed(x);
            }
        });
        boolean endStream = frame.isEndStream();
        if (endStream) {
            boolean handle_content = this.onContentComplete();
            boolean handle_request = this.onRequestComplete();
            handle |= handle_content | handle_request;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Request #{}/{}: {} bytes of {} content, handle: {}", stream.getId(), Integer.toHexString(stream.getSession().hashCode()), length, endStream ? "last" : "some", handle);
        }
        boolean wasDelayed = this._delayedUntilContent;
        this._delayedUntilContent = false;
        if (wasDelayed) {
            this._handled = true;
        }
        return handle || wasDelayed ? this : null;
    }

    public void onRequestTrailers(HeadersFrame frame) {
        HttpFields trailers = frame.getMetaData().getFields();
        this.onTrailers(trailers);
        this.onRequestComplete();
        if (LOG.isDebugEnabled()) {
            IStream stream = this.getStream();
            LOG.debug("HTTP2 Request #{}/{}, trailers:{}{}", stream.getId(), Integer.toHexString(stream.getSession().hashCode()), System.lineSeparator(), trailers);
        }
    }

    public boolean isRequestHandled() {
        return this._handled;
    }

    public boolean onStreamTimeout(Throwable failure) {
        if (!this._handled) {
            return true;
        }
        HttpInput input = this.getRequest().getHttpInput();
        boolean readFailed = input.failed(failure);
        if (readFailed) {
            this.handle();
        }
        boolean writeFailed = this.getHttpTransport().onStreamTimeout(failure);
        return readFailed || writeFailed;
    }

    public void onFailure(Throwable failure) {
        this.getHttpTransport().onStreamFailure(failure);
        if (this.onEarlyEOF()) {
            this.handle();
        } else {
            this.getState().asyncError(failure);
        }
    }

    protected void consumeInput() {
        this.getRequest().getHttpInput().consumeAll();
    }

    @Override
    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expect100Continue = false;
            if (available == 0) {
                if (this.getResponse().isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean committed = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!committed) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    @Override
    public String toString() {
        IStream stream = this.getStream();
        long streamId = -1L;
        if (stream != null) {
            streamId = stream.getId();
        }
        return String.format("%s#%d", super.toString(), this.getStream() == null ? -1L : streamId);
    }
}

