/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class ResetGenerator
extends FrameGenerator {
    public ResetGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public int generate(ByteBufferPool.Accumulator accumulator, Frame frame) {
        ResetFrame resetFrame = (ResetFrame)frame;
        return this.generateReset(accumulator, resetFrame.getStreamId(), resetFrame.getError());
    }

    public int generateReset(ByteBufferPool.Accumulator accumulator, int streamId, int error) {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        RetainableByteBuffer header = this.generateHeader(FrameType.RST_STREAM, 4, 0, streamId);
        ByteBuffer byteBuffer = header.getByteBuffer();
        byteBuffer.putInt(error);
        BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)0);
        accumulator.append(header);
        return 13;
    }
}

