/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.transport;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.client.AbstractHttpClientTransport;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.http3.HTTP3Configuration;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.client.HTTP3Client;
import org.eclipse.jetty.http3.client.HTTP3ClientConnectionFactory;
import org.eclipse.jetty.http3.client.HTTP3SessionClient;
import org.eclipse.jetty.http3.client.transport.internal.HttpConnectionOverHTTP3;
import org.eclipse.jetty.http3.client.transport.internal.SessionClientListener;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Transport;
import org.eclipse.jetty.quic.client.QuicTransport;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.QuicSession;

public class HttpClientTransportOverHTTP3
extends AbstractHttpClientTransport
implements ProtocolSession.Factory {
    private final HTTP3ClientConnectionFactory factory = new HTTP3ClientConnectionFactory();
    private final HTTP3Client http3Client;

    public HttpClientTransportOverHTTP3(HTTP3Client http3Client) {
        this.http3Client = Objects.requireNonNull(http3Client);
        this.installBean(http3Client);
        this.setConnectionPoolFactory(destination -> {
            HttpClient httpClient = this.getHttpClient();
            return new MultiplexConnectionPool(destination, httpClient.getMaxConnectionsPerDestination(), 1);
        });
    }

    public HTTP3Client getHTTP3Client() {
        return this.http3Client;
    }

    protected void doStart() throws Exception {
        if (!this.http3Client.isStarted()) {
            HttpClientTransportOverHTTP3.configure(this.getHttpClient(), this.http3Client);
        }
        super.doStart();
    }

    static void configure(HttpClient httpClient, HTTP3Client http3Client) {
        ClientConnector clientConnector = http3Client.getClientConnector();
        clientConnector.setExecutor(httpClient.getExecutor());
        clientConnector.setScheduler(httpClient.getScheduler());
        clientConnector.setByteBufferPool(httpClient.getByteBufferPool());
        clientConnector.setConnectTimeout(Duration.ofMillis(httpClient.getConnectTimeout()));
        clientConnector.setConnectBlocking(httpClient.isConnectBlocking());
        clientConnector.setBindAddress(httpClient.getBindAddress());
        clientConnector.setIdleTimeout(Duration.ofMillis(httpClient.getIdleTimeout()));
        HTTP3Configuration configuration = http3Client.getHTTP3Configuration();
        configuration.setInputBufferSize(httpClient.getResponseBufferSize());
        configuration.setUseInputDirectByteBuffers(httpClient.isUseInputDirectByteBuffers());
        configuration.setUseOutputDirectByteBuffers(httpClient.isUseOutputDirectByteBuffers());
        configuration.setMaxResponseHeadersSize(httpClient.getMaxResponseHeadersSize());
    }

    public Origin newOrigin(Request request) {
        Transport transport = request.getTransport();
        if (transport == null) {
            request.transport((Transport)new QuicTransport(this.http3Client.getQuicConfiguration()));
        }
        return this.getHttpClient().createOrigin(request, new Origin.Protocol(List.of("h3"), false));
    }

    public Destination newDestination(Origin origin) {
        return new HttpDestination(this.getHttpClient(), origin);
    }

    public void connect(InetSocketAddress address, Map<String, Object> context) {
        this.connect((SocketAddress)address, context);
    }

    public void connect(SocketAddress address, Map<String, Object> context) {
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        context.put("org.eclipse.jetty.client.connector.clientConnectionFactory", destination.getClientConnectionFactory());
        TransportSessionClientListener listener = new TransportSessionClientListener(context);
        this.getHTTP3Client().connect(destination.getOrigin().getTransport(), address, (Session.Client.Listener)listener, context).whenComplete(listener::onConnect);
    }

    public ProtocolSession newProtocolSession(QuicSession quicSession, Map<String, Object> context) {
        return this.factory.newProtocolSession(quicSession, context);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        return this.factory.newConnection(endPoint, context);
    }

    protected org.eclipse.jetty.client.Connection newConnection(Destination destination, HTTP3SessionClient session) {
        return new HttpConnectionOverHTTP3(destination, session);
    }

    private class TransportSessionClientListener
    extends SessionClientListener {
        private TransportSessionClientListener(Map<String, Object> context) {
            super(context);
        }

        @Override
        protected org.eclipse.jetty.client.Connection newConnection(Destination destination, HTTP3SessionClient session) {
            return HttpClientTransportOverHTTP3.this.newConnection(destination, session);
        }
    }
}

