/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.conscrypt.client;

import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLEngine;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ConscryptClientALPNProcessor
implements ALPNProcessor.Client {
    private static final Logger LOG = Log.getLogger(ConscryptClientALPNProcessor.class);

    public void init() {
        if (Security.getProvider("Conscrypt") == null) {
            Security.addProvider((Provider)new OpenSSLProvider());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added Conscrypt provider", new Object[0]);
            }
        }
    }

    public boolean appliesTo(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("org.conscrypt.");
    }

    public void configure(SSLEngine sslEngine, Connection connection) {
        try {
            Method setAlpnProtocols = sslEngine.getClass().getDeclaredMethod("setApplicationProtocols", String[].class);
            setAlpnProtocols.setAccessible(true);
            ALPNClientConnection alpn = (ALPNClientConnection)connection;
            String[] protocols = alpn.getProtocols().toArray(new String[0]);
            setAlpnProtocols.invoke((Object)sslEngine, new Object[]{protocols});
            ((SslConnection.DecryptedEndPoint)connection.getEndPoint()).getSslConnection().addHandshakeListener((SslHandshakeListener)new ALPNListener(alpn));
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private final class ALPNListener
    implements SslHandshakeListener {
        private final ALPNClientConnection alpnConnection;

        private ALPNListener(ALPNClientConnection connection) {
            this.alpnConnection = connection;
        }

        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            try {
                SSLEngine sslEngine = this.alpnConnection.getSSLEngine();
                Method method = sslEngine.getClass().getDeclaredMethod("getApplicationProtocol", new Class[0]);
                method.setAccessible(true);
                String protocol = (String)method.invoke((Object)sslEngine, new Object[0]);
                this.alpnConnection.selected(protocol);
            }
            catch (Throwable e) {
                this.alpnConnection.selected(null);
                LOG.warn(e);
            }
        }
    }
}

