/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.JarScanner;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class AnnotationParser {
    private static final Logger LOG = Log.getLogger(AnnotationParser.class);
    protected Set<String> _parsedClassNames = new HashSet<String>();
    protected List<Handler> _handlers = new ArrayList<Handler>();

    public static String normalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        return name.replace('/', '.');
    }

    @Deprecated
    public void registerAnnotationHandler(String annotationName, DiscoverableAnnotationHandler handler) {
        this._handlers.add(handler);
    }

    @Deprecated
    public List<DiscoverableAnnotationHandler> getAnnotationHandlers(String annotationName) {
        ArrayList<DiscoverableAnnotationHandler> handlers = new ArrayList<DiscoverableAnnotationHandler>();
        for (Handler h : this._handlers) {
            DiscoverableAnnotationHandler dah;
            if (!(h instanceof DiscoverableAnnotationHandler) || !annotationName.equals((dah = (DiscoverableAnnotationHandler)h).getAnnotationName())) continue;
            handlers.add(dah);
        }
        return handlers;
    }

    @Deprecated
    public List<DiscoverableAnnotationHandler> getAnnotationHandlers() {
        ArrayList<DiscoverableAnnotationHandler> allAnnotationHandlers = new ArrayList<DiscoverableAnnotationHandler>();
        for (Handler h : this._handlers) {
            if (!(h instanceof DiscoverableAnnotationHandler)) continue;
            allAnnotationHandlers.add((DiscoverableAnnotationHandler)h);
        }
        return allAnnotationHandlers;
    }

    @Deprecated
    public void registerClassHandler(ClassHandler handler) {
        this._handlers.add(handler);
    }

    public void registerHandler(Handler h) {
        if (h == null) {
            return;
        }
        this._handlers.add(h);
    }

    public void registerHandlers(List<? extends Handler> handlers) {
        if (handlers == null) {
            return;
        }
        this._handlers.addAll(handlers);
    }

    public boolean deregisterHandler(Handler h) {
        return this._handlers.remove(h);
    }

    public void clearHandlers() {
        this._handlers.clear();
    }

    public boolean isParsed(String className) {
        return this._parsedClassNames.contains(className);
    }

    public void parse(String className, ClassNameResolver resolver) throws Exception {
        if (className == null) {
            return;
        }
        if (!(resolver.isExcluded(className) || this.isParsed(className) && !resolver.shouldOverride(className))) {
            className = className.replace('.', '/') + ".class";
            URL resource = Loader.getResource(this.getClass(), (String)className, (boolean)false);
            if (resource != null) {
                Resource r = Resource.newResource((URL)resource);
                this.scanClass(r.getInputStream());
            }
        }
    }

    public void parse(Class<?> clazz, ClassNameResolver resolver, boolean visitSuperClasses) throws Exception {
        Class<?> cz = clazz;
        while (cz != null) {
            if (!(resolver.isExcluded(cz.getName()) || this.isParsed(cz.getName()) && !resolver.shouldOverride(cz.getName()))) {
                String nameAsResource = cz.getName().replace('.', '/') + ".class";
                URL resource = Loader.getResource(this.getClass(), (String)nameAsResource, (boolean)false);
                if (resource != null) {
                    Resource r = Resource.newResource((URL)resource);
                    this.scanClass(r.getInputStream());
                }
            }
            if (visitSuperClasses) {
                cz = cz.getSuperclass();
                continue;
            }
            cz = null;
        }
    }

    public void parse(String[] classNames, ClassNameResolver resolver) throws Exception {
        if (classNames == null) {
            return;
        }
        this.parse(Arrays.asList(classNames), resolver);
    }

    public void parse(List<String> classNames, ClassNameResolver resolver) throws Exception {
        for (String s : classNames) {
            if (resolver != null && (resolver.isExcluded(s) || this.isParsed(s) && !resolver.shouldOverride(s))) continue;
            s = s.replace('.', '/') + ".class";
            URL resource = Loader.getResource(this.getClass(), (String)s, (boolean)false);
            if (resource == null) continue;
            Resource r = Resource.newResource((URL)resource);
            this.scanClass(r.getInputStream());
        }
    }

    public void parseDir(Resource dir, ClassNameResolver resolver) throws Exception {
        if (!dir.isDirectory() || !dir.exists() || dir.getName().startsWith(".")) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanning dir {}", new Object[]{dir});
        }
        String[] files = dir.list();
        for (int f = 0; files != null && f < files.length; ++f) {
            try {
                Resource res = dir.addPath(files[f]);
                if (res.isDirectory()) {
                    this.parseDir(res, resolver);
                    continue;
                }
                File file = res.getFile();
                if (this.isValidClassFileName(file == null ? null : file.getName())) {
                    String name = res.getName();
                    if (resolver != null && (resolver.isExcluded(name) || this.isParsed(name) && !resolver.shouldOverride(name))) continue;
                    Resource r = Resource.newResource((URL)res.getURL());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Scanning class {}", new Object[]{r});
                    }
                    this.scanClass(r.getInputStream());
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Skipping scan on invalid file {}", new Object[]{res});
                continue;
            }
            catch (Exception ex) {
                LOG.warn("EXCEPTION ", (Throwable)ex);
            }
        }
    }

    public void parse(ClassLoader loader, boolean visitParents, boolean nullInclusive, final ClassNameResolver resolver) throws Exception {
        if (loader == null) {
            return;
        }
        if (!(loader instanceof URLClassLoader)) {
            return;
        }
        JarScanner scanner = new JarScanner(){

            public void processEntry(URI jarUri, JarEntry entry) {
                try {
                    AnnotationParser.this.parseJarEntry(jarUri, entry, resolver);
                }
                catch (Exception e) {
                    LOG.warn("Problem parsing jar entry: {}", new Object[]{entry.getName()});
                }
            }
        };
        scanner.scan(null, loader, nullInclusive, visitParents);
    }

    public void parse(URI[] uris, ClassNameResolver resolver) throws Exception {
        if (uris == null) {
            return;
        }
        for (URI uri : uris) {
            try {
                this.parse(uri, resolver);
            }
            catch (Exception e) {
                LOG.warn("Problem parsing classes from {}", new Object[]{uri});
            }
        }
    }

    public void parse(URI uri, ClassNameResolver resolver) throws Exception {
        if (uri == null) {
            return;
        }
        this.parse(Resource.newResource((URI)uri), resolver);
    }

    public void parse(Resource r, ClassNameResolver resolver) throws Exception {
        if (r == null) {
            return;
        }
        if (r.exists() && r.isDirectory()) {
            this.parseDir(r, resolver);
            return;
        }
        String fullname = r.toString();
        if (fullname.endsWith(".jar")) {
            this.parseJar(r, resolver);
            return;
        }
        if (fullname.endsWith(".class")) {
            this.scanClass(r.getInputStream());
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.warn("Resource not scannable for classes: {}", new Object[]{r});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseJar(Resource jarResource, ClassNameResolver resolver) throws Exception {
        if (jarResource == null) {
            return;
        }
        URI uri = jarResource.getURI();
        if (jarResource.toString().endsWith(".jar")) {
            InputStream in;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scanning jar {}", new Object[]{jarResource});
            }
            if ((in = jarResource.getInputStream()) == null) {
                return;
            }
            try (JarInputStream jar_in = new JarInputStream(in);){
                JarEntry entry = jar_in.getNextJarEntry();
                while (entry != null) {
                    this.parseJarEntry(uri, entry, resolver);
                    entry = jar_in.getNextJarEntry();
                }
            }
        }
    }

    protected void parseJarEntry(URI jar, JarEntry entry, ClassNameResolver resolver) throws Exception {
        if (jar == null || entry == null) {
            return;
        }
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        if (this.isValidClassFileName(name) && this.isValidClassFilePath(name)) {
            String shortName = name.replace('/', '.').substring(0, name.length() - 6);
            if (resolver == null || !resolver.isExcluded(shortName) && (!this.isParsed(shortName) || resolver.shouldOverride(shortName))) {
                Resource clazz = Resource.newResource((String)("jar:" + jar + "!/" + name));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanning class from jar {}", new Object[]{clazz});
                }
                this.scanClass(clazz.getInputStream());
            }
        }
    }

    protected void scanClass(InputStream is) throws IOException {
        ClassReader reader = new ClassReader(is);
        reader.accept((ClassVisitor)new MyClassVisitor(), 7);
    }

    private boolean isValidClassFileName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (!name.toLowerCase(Locale.ENGLISH).endsWith(".class")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not a class: {}", new Object[]{name});
            }
            return false;
        }
        int c0 = 0;
        int ldir = name.lastIndexOf(47, name.length() - 6);
        int n = c0 = ldir > -1 ? ldir + 1 : c0;
        if (!Character.isJavaIdentifierStart(name.charAt(c0))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not a java identifier: {}" + name, new Object[0]);
            }
            return false;
        }
        return true;
    }

    private boolean isValidClassFilePath(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.startsWith(".") || path.contains("/.")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Contains hidden dirs: {}" + path, new Object[0]);
            }
            return false;
        }
        return true;
    }

    public class MyClassVisitor
    extends EmptyVisitor {
        String _className;
        int _access;
        String _signature;
        String _superName;
        String[] _interfaces;
        int _version;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this._className = AnnotationParser.normalize(name);
            this._access = access;
            this._signature = signature;
            this._superName = superName;
            this._interfaces = interfaces;
            this._version = version;
            AnnotationParser.this._parsedClassNames.add(this._className);
            String[] normalizedInterfaces = null;
            if (interfaces != null) {
                normalizedInterfaces = new String[interfaces.length];
                int i = 0;
                for (String s : interfaces) {
                    normalizedInterfaces[i++] = AnnotationParser.normalize(s);
                }
            }
            for (Handler h : AnnotationParser.this._handlers) {
                if (!(h instanceof ClassHandler)) continue;
                ((ClassHandler)h).handle(this._className, this._version, this._access, this._signature, AnnotationParser.normalize(this._superName), normalizedInterfaces);
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            MyAnnotationVisitor visitor = new MyAnnotationVisitor(AnnotationParser.normalize(desc), new ArrayList()){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    for (Handler h : AnnotationParser.this._handlers) {
                        DiscoverableAnnotationHandler dah;
                        if (!(h instanceof DiscoverableAnnotationHandler) || !this._annotationName.equalsIgnoreCase((dah = (DiscoverableAnnotationHandler)h).getAnnotationName())) continue;
                        dah.handleClass(MyClassVisitor.this._className, MyClassVisitor.this._version, MyClassVisitor.this._access, MyClassVisitor.this._signature, MyClassVisitor.this._superName, MyClassVisitor.this._interfaces, this._annotationName, this._annotationValues);
                    }
                }
            };
            return visitor;
        }

        public MethodVisitor visitMethod(final int access, final String name, final String methodDesc, final String signature, final String[] exceptions) {
            return new EmptyVisitor(){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    MyAnnotationVisitor visitor = new MyAnnotationVisitor(AnnotationParser.normalize(desc), new ArrayList()){

                        @Override
                        public void visitEnd() {
                            super.visitEnd();
                            for (Handler h : AnnotationParser.this._handlers) {
                                DiscoverableAnnotationHandler dah;
                                if (!(h instanceof DiscoverableAnnotationHandler) || !this._annotationName.equalsIgnoreCase((dah = (DiscoverableAnnotationHandler)h).getAnnotationName())) continue;
                                dah.handleMethod(MyClassVisitor.this._className, name, access, methodDesc, signature, exceptions, this._annotationName, this._annotationValues);
                            }
                        }
                    };
                    return visitor;
                }
            };
        }

        public FieldVisitor visitField(final int access, final String fieldName, final String fieldType, final String signature, final Object value) {
            return new EmptyVisitor(){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    MyAnnotationVisitor visitor = new MyAnnotationVisitor(AnnotationParser.normalize(desc), new ArrayList()){

                        @Override
                        public void visitEnd() {
                            super.visitEnd();
                            for (Handler h : AnnotationParser.this._handlers) {
                                DiscoverableAnnotationHandler dah;
                                if (!(h instanceof DiscoverableAnnotationHandler) || !this._annotationName.equalsIgnoreCase((dah = (DiscoverableAnnotationHandler)h).getAnnotationName())) continue;
                                dah.handleField(MyClassVisitor.this._className, fieldName, access, fieldType, signature, value, this._annotationName, this._annotationValues);
                            }
                        }
                    };
                    return visitor;
                }
            };
        }
    }

    public class MyAnnotationVisitor
    implements AnnotationVisitor {
        List<Value> _annotationValues;
        String _annotationName;

        public MyAnnotationVisitor(String annotationName, List<Value> values) {
            this._annotationValues = values;
            this._annotationName = annotationName;
        }

        public List<Value> getAnnotationValues() {
            return this._annotationValues;
        }

        public void visit(String aname, Object avalue) {
            SimpleValue v = new SimpleValue(aname);
            v.setValue(avalue);
            this._annotationValues.add(v);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            String s = AnnotationParser.normalize(desc);
            ListValue v = new ListValue(s);
            this._annotationValues.add(v);
            MyAnnotationVisitor visitor = new MyAnnotationVisitor(s, v.getList());
            return visitor;
        }

        public AnnotationVisitor visitArray(String name) {
            ListValue v = new ListValue(name);
            this._annotationValues.add(v);
            MyAnnotationVisitor visitor = new MyAnnotationVisitor(null, v.getList());
            return visitor;
        }

        public void visitEnum(String name, String desc, String value) {
        }

        public void visitEnd() {
        }
    }

    public static interface FieldHandler
    extends Handler {
        public void handle(String var1, String var2, int var3, String var4, String var5, Object var6);
    }

    public static interface MethodHandler
    extends Handler {
        public void handle(String var1, String var2, int var3, String var4, String var5, String[] var6);
    }

    public static interface ClassHandler
    extends Handler {
        public void handle(String var1, int var2, int var3, String var4, String var5, String[] var6);
    }

    public static interface DiscoverableAnnotationHandler
    extends Handler {
        public void handleClass(String var1, int var2, int var3, String var4, String var5, String[] var6, String var7, List<Value> var8);

        public void handleMethod(String var1, String var2, int var3, String var4, String var5, String[] var6, String var7, List<Value> var8);

        public void handleField(String var1, String var2, int var3, String var4, String var5, Object var6, String var7, List<Value> var8);

        public String getAnnotationName();
    }

    public static interface Handler {
    }

    public class ListValue
    extends Value {
        List<Value> _val;

        public ListValue(String name) {
            super(name);
            this._val = new ArrayList<Value>();
        }

        @Override
        public Object getValue() {
            return this._val;
        }

        public List<Value> getList() {
            return this._val;
        }

        public void addValue(Value v) {
            this._val.add(v);
        }

        public int size() {
            return this._val.size();
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("(");
            buff.append(this.getName());
            buff.append(":");
            for (Value n : this._val) {
                buff.append(" " + n.toString());
            }
            buff.append(")");
            return buff.toString();
        }
    }

    public class SimpleValue
    extends Value {
        Object _val;

        public SimpleValue(String name) {
            super(name);
        }

        public void setValue(Object val) {
            this._val = val;
        }

        @Override
        public Object getValue() {
            return this._val;
        }

        public String toString() {
            return "(" + this.getName() + ":" + this._val + ")";
        }
    }

    public abstract class Value {
        String _name;

        public Value(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public abstract Object getValue();
    }
}

