/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import org.eclipse.jetty.client.AbstractHttpConnection;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AsyncHttpConnection
extends AbstractHttpConnection
implements AsyncConnection {
    private static final Logger LOG = Log.getLogger(AsyncHttpConnection.class);
    private boolean _requestComplete;
    private Buffer _requestContentChunk;
    private final AsyncEndPoint _asyncEndp;

    AsyncHttpConnection(Buffers requestBuffers, Buffers responseBuffers, EndPoint endp) {
        super(requestBuffers, responseBuffers, endp);
        this._asyncEndp = (AsyncEndPoint)endp;
    }

    protected void reset() throws IOException {
        this._requestComplete = false;
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection handle() throws IOException {
        AsyncHttpConnection connection = this;
        boolean progress = true;
        try {
            boolean failed = false;
            while (progress && connection == this) {
                Connection switched;
                AsyncHttpConnection asyncHttpConnection;
                boolean persistent;
                boolean complete;
                Object var9_8;
                LOG.debug("while open={} more={} progress={}", new Object[]{this._endp.isOpen(), this._parser.isMoreInBuffer(), progress});
                progress = false;
                HttpExchange exchange = this._exchange;
                LOG.debug("exchange {} on {}", new Object[]{exchange, this});
                try {
                    block54: {
                        try {
                            if (!this._generator.isCommitted() && exchange != null && exchange.getStatus() == 2) {
                                LOG.debug("commit {}", new Object[]{exchange});
                                progress = true;
                                this.commitRequest();
                            }
                            if (this._generator.isCommitted() && !this._generator.isComplete()) {
                                if (this._generator.flushBuffer() > 0) {
                                    LOG.debug("flushed", new Object[0]);
                                    progress = true;
                                }
                                if (this._generator.isState(2)) {
                                    if (this._requestContentChunk == null) {
                                        this._requestContentChunk = exchange.getRequestContentChunk(null);
                                    }
                                    if (this._requestContentChunk == null) {
                                        LOG.debug("complete {}", new Object[]{exchange});
                                        progress = true;
                                        this._generator.complete();
                                    } else if (this._generator.isEmpty()) {
                                        LOG.debug("addChunk", new Object[0]);
                                        progress = true;
                                        Buffer chunk = this._requestContentChunk;
                                        this._requestContentChunk = exchange.getRequestContentChunk(null);
                                        this._generator.addContent(chunk, this._requestContentChunk == null);
                                    }
                                }
                            }
                            if (this._generator.isComplete() && !this._requestComplete) {
                                LOG.debug("requestComplete {}", new Object[]{exchange});
                                progress = true;
                                this._requestComplete = true;
                                exchange.getEventListener().onRequestComplete();
                            }
                            if (!this._parser.isComplete() && this._parser.parseAvailable()) {
                                LOG.debug("parsed {}", new Object[]{exchange});
                                progress = true;
                            }
                            this._endp.flush();
                            if (!this._asyncEndp.hasProgressed()) break block54;
                            LOG.debug("hasProgressed {}", new Object[]{exchange});
                            progress = true;
                        }
                        catch (Throwable e) {
                            LOG.debug("Failure on " + this._exchange, e);
                            failed = true;
                            AsyncHttpConnection asyncHttpConnection2 = this;
                            synchronized (asyncHttpConnection2) {
                                if (exchange != null) {
                                    if (exchange.getStatus() != 10 && exchange.getStatus() != 11 && !exchange.isDone() && exchange.setStatus(9)) {
                                        exchange.getEventListener().onException(e);
                                    }
                                } else {
                                    if (e instanceof IOException) {
                                        throw (IOException)e;
                                    }
                                    if (e instanceof Error) {
                                        throw (Error)e;
                                    }
                                    if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
                                    throw (RuntimeException)e;
                                }
                            }
                            var9_8 = null;
                            LOG.debug("finally {} on {} progress={} {}", new Object[]{exchange, this, progress, this._endp});
                            complete = failed || this._generator.isComplete() && this._parser.isComplete();
                            if (!complete) continue;
                            persistent = !failed && this._parser.isPersistent() && this._generator.isPersistent();
                            this._generator.setPersistent(persistent);
                            this.reset();
                            if (persistent) {
                                this._endp.setMaxIdleTime((int)this._destination.getHttpClient().getIdleTimeout());
                            }
                            asyncHttpConnection = this;
                            synchronized (asyncHttpConnection) {
                                exchange = this._exchange;
                                this._exchange = null;
                                if (exchange != null) {
                                    exchange.cancelTimeout(this._destination.getHttpClient());
                                }
                                if (this._status == 101) {
                                    switched = exchange.onSwitchProtocol(this._endp);
                                    if (switched != null) {
                                        connection = switched;
                                    }
                                    this._pipeline = null;
                                    if (this._pipeline != null) {
                                        this._destination.send(this._pipeline);
                                    }
                                    this._pipeline = null;
                                    connection = switched;
                                }
                                if (this._pipeline != null) {
                                    if (!persistent || connection != this) {
                                        this._destination.send(this._pipeline);
                                    } else {
                                        this._exchange = this._pipeline;
                                    }
                                    this._pipeline = null;
                                }
                                if (this._exchange == null && !this.isReserved()) {
                                    this._destination.returnConnection(this, !persistent);
                                }
                                continue;
                            }
                        }
                    }
                    var9_8 = null;
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    LOG.debug("finally {} on {} progress={} {}", new Object[]{exchange, this, progress, this._endp});
                    complete = failed || this._generator.isComplete() && this._parser.isComplete();
                    if (!complete) throw throwable;
                    persistent = !failed && this._parser.isPersistent() && this._generator.isPersistent();
                    this._generator.setPersistent(persistent);
                    this.reset();
                    if (persistent) {
                        this._endp.setMaxIdleTime((int)this._destination.getHttpClient().getIdleTimeout());
                    }
                    asyncHttpConnection = this;
                    synchronized (asyncHttpConnection) {
                        exchange = this._exchange;
                        this._exchange = null;
                        if (exchange != null) {
                            exchange.cancelTimeout(this._destination.getHttpClient());
                        }
                        if (this._status == 101) {
                            switched = exchange.onSwitchProtocol(this._endp);
                            if (switched != null) {
                                connection = switched;
                            }
                            this._pipeline = null;
                            if (this._pipeline != null) {
                                this._destination.send(this._pipeline);
                            }
                            this._pipeline = null;
                            connection = switched;
                        }
                        if (this._pipeline != null) {
                            if (!persistent || connection != this) {
                                this._destination.send(this._pipeline);
                            } else {
                                this._exchange = this._pipeline;
                            }
                            this._pipeline = null;
                        }
                        if (this._exchange != null) throw throwable;
                        if (this.isReserved()) throw throwable;
                        this._destination.returnConnection(this, !persistent);
                        throw throwable;
                    }
                }
                LOG.debug("finally {} on {} progress={} {}", new Object[]{exchange, this, progress, this._endp});
                complete = failed || this._generator.isComplete() && this._parser.isComplete();
                if (!complete) continue;
                persistent = !failed && this._parser.isPersistent() && this._generator.isPersistent();
                this._generator.setPersistent(persistent);
                this.reset();
                if (persistent) {
                    this._endp.setMaxIdleTime((int)this._destination.getHttpClient().getIdleTimeout());
                }
                asyncHttpConnection = this;
                synchronized (asyncHttpConnection) {
                    exchange = this._exchange;
                    this._exchange = null;
                    if (exchange != null) {
                        exchange.cancelTimeout(this._destination.getHttpClient());
                    }
                    if (this._status == 101) {
                        switched = exchange.onSwitchProtocol(this._endp);
                        if (switched != null) {
                            connection = switched;
                        }
                        this._pipeline = null;
                        if (this._pipeline != null) {
                            this._destination.send(this._pipeline);
                        }
                        this._pipeline = null;
                        connection = switched;
                    }
                    if (this._pipeline != null) {
                        if (!persistent || connection != this) {
                            this._destination.send(this._pipeline);
                        } else {
                            this._exchange = this._pipeline;
                        }
                        this._pipeline = null;
                    }
                    if (this._exchange == null && !this.isReserved()) {
                        this._destination.returnConnection(this, !persistent);
                    }
                }
            }
            Object var16_14 = null;
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            this._parser.returnBuffers();
            this._generator.returnBuffers();
            LOG.debug("unhandle {} on {}", new Object[]{this._exchange, this._endp});
            throw throwable;
        }
        this._parser.returnBuffers();
        this._generator.returnBuffers();
        LOG.debug("unhandle {} on {}", new Object[]{this._exchange, this._endp});
        return connection;
    }

    public void onInputShutdown() throws IOException {
        if (this._generator.isIdle()) {
            this._endp.shutdownOutput();
        }
    }

    public boolean send(HttpExchange ex) throws IOException {
        boolean sent = super.send(ex);
        if (sent) {
            this._asyncEndp.asyncDispatch();
        }
        return sent;
    }
}

