/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InputStreamContentProvider
implements ContentProvider {
    private static final Logger LOG = Log.getLogger(InputStreamContentProvider.class);
    private final InputStream stream;
    private final int bufferSize;
    private final boolean autoClose;

    public InputStreamContentProvider(InputStream stream) {
        this(stream, 4096);
    }

    public InputStreamContentProvider(InputStream stream, int bufferSize) {
        this(stream, bufferSize, true);
    }

    public InputStreamContentProvider(InputStream stream, int bufferSize, boolean autoClose) {
        this.stream = stream;
        this.bufferSize = bufferSize;
        this.autoClose = autoClose;
    }

    @Override
    public long getLength() {
        return -1L;
    }

    protected ByteBuffer onRead(byte[] buffer, int offset, int length) {
        if (length <= 0) {
            return BufferUtil.EMPTY_BUFFER;
        }
        return ByteBuffer.wrap(buffer, offset, length);
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new Iterator<ByteBuffer>(){
            private final byte[] bytes;
            private Exception failure;
            private ByteBuffer buffer;
            {
                this.bytes = new byte[InputStreamContentProvider.this.bufferSize];
            }

            @Override
            public boolean hasNext() {
                try {
                    int read = InputStreamContentProvider.this.stream.read(this.bytes);
                    if (read > 0) {
                        this.buffer = InputStreamContentProvider.this.onRead(this.bytes, 0, read);
                        return true;
                    }
                    if (read < 0) {
                        this.close();
                        return false;
                    }
                    this.buffer = BufferUtil.EMPTY_BUFFER;
                    return true;
                }
                catch (Exception x) {
                    if (this.failure == null) {
                        this.failure = x;
                        this.close();
                        return true;
                    }
                    return false;
                }
            }

            @Override
            public ByteBuffer next() {
                ByteBuffer result = this.buffer;
                this.buffer = null;
                if (this.failure != null) {
                    throw (NoSuchElementException)new NoSuchElementException().initCause(this.failure);
                }
                if (result == null) {
                    throw new NoSuchElementException();
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void close() {
                if (InputStreamContentProvider.this.autoClose) {
                    try {
                        InputStreamContentProvider.this.stream.close();
                    }
                    catch (IOException x) {
                        LOG.ignore((Throwable)x);
                    }
                }
            }
        };
    }
}

