/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.TimeoutCompleteListener;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;

public abstract class HttpConnection
implements Connection {
    private static final HttpField CHUNKED_FIELD = new HttpField(HttpHeader.TRANSFER_ENCODING, HttpHeaderValue.CHUNKED);
    private final HttpDestination destination;

    protected HttpConnection(HttpDestination destination) {
        this.destination = destination;
    }

    public HttpClient getHttpClient() {
        return this.destination.getHttpClient();
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    @Override
    public void send(Request request, Response.CompleteListener listener) {
        ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>(2);
        if (request.getTimeout() > 0L) {
            TimeoutCompleteListener timeoutListener = new TimeoutCompleteListener(request);
            timeoutListener.schedule(this.getHttpClient().getScheduler());
            listeners.add(timeoutListener);
        }
        if (listener != null) {
            listeners.add(listener);
        }
        HttpExchange exchange = new HttpExchange(this.getHttpDestination(), (HttpRequest)request, listeners);
        this.send(exchange);
    }

    protected abstract void send(HttpExchange var1);

    protected void normalizeRequest(Request request) {
        Authentication.Result authnResult;
        URI authenticationURI;
        String method = request.getMethod();
        HttpVersion version = request.getVersion();
        HttpFields headers = request.getHeaders();
        ContentProvider content = request.getContent();
        ProxyConfiguration.Proxy proxy = this.destination.getProxy();
        String path = request.getPath();
        if (path.trim().length() == 0) {
            path = "/";
            request.path(path);
        }
        if (proxy != null && !HttpMethod.CONNECT.is(method)) {
            path = request.getURI().toString();
            request.path(path);
        }
        if (version.getVersion() > 10 && !headers.containsKey(HttpHeader.HOST.asString())) {
            headers.put(this.getHttpDestination().getHostField());
        }
        if (request.getAgent() == null) {
            headers.put(this.getHttpClient().getUserAgentField());
        }
        if (content != null) {
            long contentLength = content.getLength();
            if (contentLength >= 0L) {
                if (!headers.containsKey(HttpHeader.CONTENT_LENGTH.asString())) {
                    headers.put(HttpHeader.CONTENT_LENGTH, String.valueOf(contentLength));
                }
            } else if (!headers.containsKey(HttpHeader.TRANSFER_ENCODING.asString())) {
                headers.put(CHUNKED_FIELD);
            }
        }
        List<HttpCookie> cookies = this.getHttpClient().getCookieStore().get(request.getURI());
        StringBuilder cookieString = null;
        for (int i = 0; i < cookies.size(); ++i) {
            if (cookieString == null) {
                cookieString = new StringBuilder();
            }
            if (i > 0) {
                cookieString.append("; ");
            }
            HttpCookie cookie = cookies.get(i);
            cookieString.append(cookie.getName()).append("=").append(cookie.getValue());
        }
        if (cookieString != null) {
            request.header(HttpHeader.COOKIE.asString(), cookieString.toString());
        }
        URI uRI = authenticationURI = proxy != null ? proxy.getURI() : request.getURI();
        if (authenticationURI != null && (authnResult = this.getHttpClient().getAuthenticationStore().findAuthenticationResult(authenticationURI)) != null) {
            authnResult.apply(request);
        }
    }

    public String toString() {
        return String.format("%s@%h", this.getClass().getSimpleName(), this);
    }
}

