/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Sweeper;

public class MultiplexConnectionPool
extends AbstractConnectionPool
implements ConnectionPool.Multiplexable,
Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(MultiplexConnectionPool.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final HttpDestination destination;
    private final Deque<Holder> idleConnections;
    private final Map<Connection, Holder> muxedConnections;
    private final Map<Connection, Holder> busyConnections;
    private int maxMultiplex;

    public MultiplexConnectionPool(HttpDestination destination, int maxConnections, Callback requester, int maxMultiplex) {
        super(destination, maxConnections, requester);
        this.destination = destination;
        this.idleConnections = new ArrayDeque<Holder>(maxConnections);
        this.muxedConnections = new HashMap<Connection, Holder>(maxConnections);
        this.busyConnections = new HashMap<Connection, Holder>(maxConnections);
        this.maxMultiplex = maxMultiplex;
    }

    @Override
    public Connection acquire() {
        Connection connection = this.activate();
        if (connection == null) {
            int maxPending = 1 + this.destination.getQueuedRequestCount() / this.getMaxMultiplex();
            this.tryCreate(maxPending);
            connection = this.activate();
        }
        return connection;
    }

    protected void lock() {
        this.lock.lock();
    }

    protected void unlock() {
        this.lock.unlock();
    }

    @Override
    public int getMaxMultiplex() {
        this.lock();
        try {
            int n = this.maxMultiplex;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void setMaxMultiplex(int maxMultiplex) {
        this.lock();
        try {
            this.maxMultiplex = maxMultiplex;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isActive(Connection connection) {
        this.lock();
        try {
            if (this.muxedConnections.containsKey(connection)) {
                boolean bl = true;
                return bl;
            }
            if (this.busyConnections.containsKey(connection)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    protected void onCreated(Connection connection) {
        this.lock();
        try {
            this.idleConnections.offer(new Holder(connection));
        }
        finally {
            this.unlock();
        }
        this.idle(connection, false);
    }

    @Override
    protected Connection activate() {
        Holder holder;
        this.lock();
        try {
            while (true) {
                if (this.muxedConnections.isEmpty()) {
                    holder = this.idleConnections.poll();
                    if (holder == null) {
                        Connection connection = null;
                        return connection;
                    }
                    this.muxedConnections.put(holder.connection, holder);
                } else {
                    holder = this.muxedConnections.values().iterator().next();
                }
                if (holder.count < this.maxMultiplex) {
                    ++holder.count;
                    break;
                }
                this.muxedConnections.remove(holder.connection);
                this.busyConnections.put(holder.connection, holder);
            }
        }
        finally {
            this.unlock();
        }
        return this.active(holder.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release(Connection connection) {
        Holder holder;
        boolean closed = this.isClosed();
        boolean idle = false;
        this.lock();
        try {
            holder = this.muxedConnections.get(connection);
            if (holder != null) {
                int count = --holder.count;
                if (count == 0) {
                    this.muxedConnections.remove(connection);
                    if (!closed) {
                        this.idleConnections.offerFirst(holder);
                        idle = true;
                    }
                }
            } else {
                holder = this.busyConnections.remove(connection);
                if (holder != null) {
                    int count = --holder.count;
                    if (!closed) {
                        if (count == 0) {
                            this.idleConnections.offerFirst(holder);
                            idle = true;
                        } else {
                            this.muxedConnections.put(connection, holder);
                        }
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
        if (holder == null) {
            return false;
        }
        this.released(connection);
        if (idle || closed) {
            return this.idle(connection, closed);
        }
        return true;
    }

    @Override
    public boolean remove(Connection connection) {
        return this.remove(connection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(Connection connection, boolean force) {
        boolean removed;
        boolean idleRemoved;
        boolean activeRemoved;
        block7: {
            activeRemoved = true;
            idleRemoved = false;
            this.lock();
            try {
                Holder holder = this.muxedConnections.remove(connection);
                if (holder == null) {
                    holder = this.busyConnections.remove(connection);
                }
                if (holder != null) break block7;
                activeRemoved = false;
                Iterator<Holder> iterator = this.idleConnections.iterator();
                while (iterator.hasNext()) {
                    holder = iterator.next();
                    if (holder.connection != connection) continue;
                    idleRemoved = true;
                    iterator.remove();
                    break;
                }
            }
            finally {
                this.unlock();
            }
        }
        if (activeRemoved || force) {
            this.released(connection);
        }
        boolean bl = removed = activeRemoved || idleRemoved || force;
        if (removed) {
            this.removed(connection);
        }
        return removed;
    }

    @Override
    public void close() {
        List<Connection> connections;
        super.close();
        this.lock();
        try {
            connections = this.idleConnections.stream().map(holder -> ((Holder)holder).connection).collect(Collectors.toList());
            connections.addAll(this.muxedConnections.keySet());
            connections.addAll(this.busyConnections.keySet());
        }
        finally {
            this.unlock();
        }
        this.close(connections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<Holder> connections = new ArrayList<Holder>();
        this.lock();
        try {
            connections.addAll(this.busyConnections.values());
            connections.addAll(this.muxedConnections.values());
            connections.addAll(this.idleConnections);
        }
        finally {
            this.unlock();
        }
        ContainerLifeCycle.dumpObject((Appendable)out, (Object)this);
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{connections});
    }

    public boolean sweep() {
        ArrayList toSweep = new ArrayList();
        this.lock();
        try {
            this.busyConnections.values().stream().map(holder -> ((Holder)holder).connection).filter(connection -> connection instanceof Sweeper.Sweepable).collect(Collectors.toCollection(() -> toSweep));
            this.muxedConnections.values().stream().map(holder -> ((Holder)holder).connection).filter(connection -> connection instanceof Sweeper.Sweepable).collect(Collectors.toCollection(() -> toSweep));
        }
        finally {
            this.unlock();
        }
        for (Connection connection2 : toSweep) {
            if (!((Sweeper.Sweepable)connection2).sweep()) continue;
            boolean removed = this.remove(connection2, true);
            LOG.warn("Connection swept: {}{}{} from active connections{}{}", new Object[]{connection2, System.lineSeparator(), removed ? "Removed" : "Not removed", System.lineSeparator(), this.dump()});
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int idleSize;
        int muxedSize;
        int busySize;
        this.lock();
        try {
            busySize = this.busyConnections.size();
            muxedSize = this.muxedConnections.size();
            idleSize = this.idleConnections.size();
        }
        finally {
            this.unlock();
        }
        return String.format("%s@%x[c=%d/%d,b=%d,m=%d,i=%d]", this.getClass().getSimpleName(), this.hashCode(), this.getConnectionCount(), this.getMaxConnectionCount(), busySize, muxedSize, idleSize);
    }

    private static class Holder {
        private final Connection connection;
        private int count;

        private Holder(Connection connection) {
            this.connection = connection;
        }

        public String toString() {
            return String.format("%s[%d]", this.connection, this.count);
        }
    }
}

