/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Pattern;

public class FS {
    public static boolean canReadDirectory(File path) {
        return path.exists() && path.isDirectory() && path.canRead();
    }

    public static boolean canReadFile(File path) {
        return path.exists() && path.isFile() && path.canRead();
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void ensureDirectoryExists(File dir) throws IOException {
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new IOException("Unable to create directory: " + dir.getAbsolutePath());
        }
    }

    public static void ensureDirectoryWritable(File dir) throws IOException {
        if (!dir.exists()) {
            throw new IOException("Directory does not exist: " + dir.getAbsolutePath());
        }
        if (!dir.canWrite()) {
            throw new IOException("Unable to write to directory: " + dir.getAbsolutePath());
        }
    }

    public static boolean isFile(File file) {
        if (file == null) {
            return false;
        }
        return file.exists() && file.isFile();
    }

    public static boolean isXml(String filename) {
        return filename.toLowerCase(Locale.ENGLISH).endsWith(".xml");
    }

    public static String toRelativePath(File baseDir, File path) {
        return baseDir.toURI().relativize(path.toURI()).toASCIIString();
    }

    public static String separators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static class XmlFilter
    extends FilenameRegexFilter {
        public XmlFilter() {
            super("^.*\\.xml$");
        }
    }

    public static class IniFilter
    extends FilenameRegexFilter {
        public IniFilter() {
            super("^.*\\.ini$");
        }
    }

    public static class FileNamesFilter
    implements FileFilter {
        private final String[] filenames;

        public FileNamesFilter(String ... names) {
            this.filenames = names;
        }

        @Override
        public boolean accept(File path) {
            if (!path.isFile()) {
                return false;
            }
            for (String name : this.filenames) {
                if (!name.equalsIgnoreCase(path.getName())) continue;
                return true;
            }
            return false;
        }
    }

    public static class FilenameRegexFilter
    implements FileFilter {
        private final Pattern pattern;

        public FilenameRegexFilter(String regex) {
            this.pattern = Pattern.compile(regex, 2);
        }

        @Override
        public boolean accept(File path) {
            return path.isFile() && this.pattern.matcher(path.getName()).matches();
        }
    }

    public static class RelativeRegexFilter
    implements FileFilter {
        private final File baseDir;
        private final Pattern pattern;

        public RelativeRegexFilter(File baseDir, Pattern pattern) {
            this.baseDir = baseDir;
            this.pattern = pattern;
        }

        @Override
        public boolean accept(File path) {
            String relativePath = FS.toRelativePath(this.baseDir, path);
            return this.pattern.matcher(relativePath).matches();
        }
    }

    public static class DirFilter
    implements FileFilter {
        public static final DirFilter INSTANCE = new DirFilter();

        @Override
        public boolean accept(File path) {
            return path.isDirectory();
        }
    }

    public static class AllFilter
    implements FileFilter {
        public static final AllFilter INSTANCE = new AllFilter();

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    }
}

