/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.CommandLineBuilder;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.TextFile;
import org.eclipse.jetty.start.UsageException;

public class StartArgs {
    public static final String CMD_LINE_SOURCE = "<command-line>";
    public static final String VERSION;
    private static final String SERVER_MAIN = "org.eclipse.jetty.xml.XmlConfiguration";
    private List<String> commandLine = new ArrayList<String>();
    private Set<String> modules = new HashSet<String>();
    private Map<String, List<String>> sources = new HashMap<String, List<String>>();
    private List<FileArg> files = new ArrayList<FileArg>();
    private Classpath classpath;
    private List<String> xmlRefs = new ArrayList<String>();
    private List<File> xmls = new ArrayList<File>();
    private Props properties = new Props();
    private Set<String> systemPropertyKeys = new HashSet<String>();
    private List<String> jvmArgs = new ArrayList<String>();
    private List<String> moduleStartdIni = new ArrayList<String>();
    private List<String> moduleStartIni = new ArrayList<String>();
    private Map<String, String> propertySource = new HashMap<String, String>();
    private String moduleGraphFilename;
    private Modules allModules;
    private boolean run = true;
    private boolean download = false;
    private boolean help = false;
    private boolean stopCommand = false;
    private boolean listModules = false;
    private boolean listClasspath = false;
    private boolean listConfig = false;
    private boolean version = false;
    private boolean dryRun = false;
    private boolean exec = false;

    public StartArgs(String[] commandLineArgs) {
        this.commandLine.addAll(Arrays.asList(commandLineArgs));
        this.classpath = new Classpath();
    }

    private void addFile(String uriLocation) {
        FileArg arg = new FileArg(uriLocation);
        if (!this.files.contains(arg)) {
            this.files.add(arg);
        }
    }

    public void addSystemProperty(String key, String value) {
        this.systemPropertyKeys.add(key);
        System.setProperty(key, value);
    }

    private void addUniqueXmlFile(String xmlRef, File xmlfile) throws IOException {
        if (!FS.canReadFile(xmlfile)) {
            throw new IOException("Cannot read file: " + xmlRef);
        }
        if (!this.xmls.contains(xmlfile = xmlfile.getCanonicalFile())) {
            this.xmls.add(xmlfile);
        }
    }

    public void dumpActiveXmls(BaseHome baseHome) {
        System.out.println();
        System.out.println("Jetty Active XMLs:");
        System.out.println("------------------");
        if (this.xmls.isEmpty()) {
            System.out.println(" (no xml files specified)");
            return;
        }
        for (File xml : this.xmls) {
            System.out.printf(" %s%n", baseHome.toShortForm(xml.getAbsolutePath()));
        }
    }

    public void dumpEnvironment() {
        System.out.println();
        System.out.println("Java Environment:");
        System.out.println("-----------------");
        this.dumpSystemProperty("java.home");
        this.dumpSystemProperty("java.vm.vendor");
        this.dumpSystemProperty("java.vm.version");
        this.dumpSystemProperty("java.vm.name");
        this.dumpSystemProperty("java.vm.info");
        this.dumpSystemProperty("java.runtime.name");
        this.dumpSystemProperty("java.runtime.version");
        this.dumpSystemProperty("java.io.tmpdir");
        this.dumpSystemProperty("user.dir");
        this.dumpSystemProperty("user.language");
        this.dumpSystemProperty("user.country");
        System.out.println();
        System.out.println("Jetty Environment:");
        System.out.println("-----------------");
        this.dumpProperty("jetty.home");
        this.dumpProperty("jetty.base");
        this.dumpProperty("jetty.version");
    }

    public void dumpJvmArgs() {
        System.out.println();
        System.out.println("JVM Arguments:");
        System.out.println("--------------");
        if (this.jvmArgs.isEmpty()) {
            System.out.println(" (no jvm args specified)");
            return;
        }
        for (String jvmArgKey : this.jvmArgs) {
            String value = System.getProperty(jvmArgKey);
            if (value != null) {
                System.out.printf(" %s = %s%n", jvmArgKey, value);
                continue;
            }
            System.out.printf(" %s%n", jvmArgKey);
        }
    }

    public void dumpProperties() {
        System.out.println();
        System.out.println("Properties:");
        System.out.println("-----------");
        ArrayList<String> sortedKeys = new ArrayList<String>();
        for (Props.Prop prop : this.properties) {
            if (prop.origin.equals("<system-property>")) continue;
            sortedKeys.add(prop.key);
        }
        if (sortedKeys.isEmpty()) {
            System.out.println(" (no properties specified)");
            return;
        }
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            this.dumpProperty(key);
        }
    }

    public void dumpSystemProperties() {
        System.out.println();
        System.out.println("System Properties:");
        System.out.println("------------------");
        if (this.systemPropertyKeys.isEmpty()) {
            System.out.println(" (no system properties specified)");
            return;
        }
        ArrayList<String> sortedKeys = new ArrayList<String>();
        sortedKeys.addAll(this.systemPropertyKeys);
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            String value = System.getProperty(key);
            System.out.printf(" %s = %s%n", key, this.properties.expand(value));
        }
    }

    private void dumpSystemProperty(String key) {
        System.out.printf(" %s = %s%n", key, System.getProperty(key));
    }

    private void dumpProperty(String key) {
        Props.Prop prop = this.properties.getProp(key);
        if (prop == null) {
            System.out.printf(" %s (not defined)%n", key);
        } else {
            System.out.printf(" %s = %s%n", key, this.properties.expand(prop.value));
            if (StartLog.isDebugEnabled()) {
                System.out.printf("   origin: %s%n", prop.origin);
                while (prop.overrides != null) {
                    prop = prop.overrides;
                    System.out.printf("   (overrides)%n", new Object[0]);
                    System.out.printf("     %s = %s%n", key, this.properties.expand(prop.value));
                    System.out.printf("     origin: %s%n", prop.origin);
                }
            }
        }
    }

    private void ensureSystemPropertySet(String key) {
        if (this.systemPropertyKeys.contains(key)) {
            return;
        }
        if (this.properties.containsKey(key)) {
            String val = this.properties.expand(this.properties.getString(key));
            if (val == null) {
                return;
            }
            this.systemPropertyKeys.add(key);
            System.setProperty(key, val);
        }
    }

    public void expandModules(BaseHome baseHome, List<Module> activeModules) throws IOException {
        for (Module module : activeModules) {
            for (String rawlibref : module.getLibs()) {
                String libref = this.properties.expand(rawlibref);
                if (libref.startsWith("regex:")) {
                    String regex = libref.substring("regex:".length());
                    for (File libfile : baseHome.listFilesRegex(regex)) {
                        this.classpath.addComponent(libfile);
                    }
                    continue;
                }
                if ((libref = FS.separators(libref)).contains("*")) {
                    int idx = libref.lastIndexOf(File.separatorChar);
                    String relativePath = "/";
                    String filenameRef = libref;
                    if (idx >= 0) {
                        relativePath = libref.substring(0, idx);
                        filenameRef = libref.substring(idx + 1);
                    }
                    StringBuilder regex = new StringBuilder();
                    regex.append('^');
                    block7: for (char c : filenameRef.toCharArray()) {
                        switch (c) {
                            case '*': {
                                regex.append(".*");
                                continue block7;
                            }
                            case '.': {
                                regex.append("\\.");
                                continue block7;
                            }
                            default: {
                                regex.append(c);
                            }
                        }
                    }
                    regex.append('$');
                    FS.FilenameRegexFilter filter = new FS.FilenameRegexFilter(regex.toString());
                    for (File libfile : baseHome.listFiles(relativePath, filter)) {
                        this.classpath.addComponent(libfile);
                    }
                    continue;
                }
                File libfile = baseHome.getFile(libref);
                this.classpath.addComponent(libfile);
            }
            for (String xmlRef : module.getXmls()) {
                File xmlfile = baseHome.getFile(xmlRef);
                this.addUniqueXmlFile(xmlRef, xmlfile);
            }
            for (String file : module.getFiles()) {
                StartLog.debug("Adding module specified file: %s", file);
                this.addFile(file);
            }
        }
    }

    public Modules getAllModules() {
        return this.allModules;
    }

    public Classpath getClasspath() {
        return this.classpath;
    }

    public List<String> getCommandLine() {
        return this.commandLine;
    }

    public List<FileArg> getFiles() {
        return this.files;
    }

    public Set<String> getEnabledModules() {
        return this.modules;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public CommandLineBuilder getMainArgs(BaseHome baseHome, boolean addJavaInit) throws IOException {
        CommandLineBuilder cmd = new CommandLineBuilder();
        if (addJavaInit) {
            cmd.addArg(CommandLineBuilder.findJavaBin());
            for (String x : this.jvmArgs) {
                cmd.addArg(x);
            }
            cmd.addRawArg("-Djetty.home=" + baseHome.getHome());
            cmd.addRawArg("-Djetty.base=" + baseHome.getBase());
            for (String propKey : this.systemPropertyKeys) {
                String value = System.getProperty(propKey);
                cmd.addEqualsArg("-D" + propKey, value);
            }
            cmd.addArg("-cp");
            cmd.addRawArg(this.classpath.toString());
            cmd.addRawArg(this.getMainClassname());
        }
        this.ensureSystemPropertySet("STOP.PORT");
        this.ensureSystemPropertySet("STOP.KEY");
        this.ensureSystemPropertySet("STOP.WAIT");
        if (this.properties.size() > 0) {
            File prop_file = File.createTempFile("start", ".properties");
            if (!this.dryRun) {
                prop_file.deleteOnExit();
            }
            try (FileOutputStream out = new FileOutputStream(prop_file);){
                this.properties.store(out, "start.jar properties");
            }
            cmd.addArg(prop_file.getAbsolutePath());
        }
        for (File xml : this.xmls) {
            cmd.addRawArg(xml.getAbsolutePath());
        }
        return cmd;
    }

    public String getMainClassname() {
        String mainclass = System.getProperty("jetty.server", SERVER_MAIN);
        return System.getProperty("main.class", mainclass);
    }

    public String getModuleGraphFilename() {
        return this.moduleGraphFilename;
    }

    public List<String> getModuleStartdIni() {
        return this.moduleStartdIni;
    }

    public List<String> getModuleStartIni() {
        return this.moduleStartIni;
    }

    public Props getProperties() {
        return this.properties;
    }

    public List<String> getSources(String module) {
        return this.sources.get(module);
    }

    private String getValue(String arg) {
        int idx = arg.indexOf(61);
        if (idx == -1) {
            throw new UsageException(-6, "Argument is missing a required value: %s", arg);
        }
        String value = arg.substring(idx + 1).trim();
        if (value.length() <= 0) {
            throw new UsageException(-6, "Argument is missing a required value: %s", arg);
        }
        return value;
    }

    private List<String> getValues(String arg) {
        String v = this.getValue(arg);
        ArrayList<String> l = new ArrayList<String>();
        for (String s : v.split(",")) {
            if (s == null || (s = s.trim()).length() <= 0) continue;
            l.add(s);
        }
        return l;
    }

    public List<File> getXmlFiles() {
        return this.xmls;
    }

    public boolean hasJvmArgs() {
        return this.jvmArgs.size() > 0;
    }

    public boolean hasSystemProperties() {
        for (String key : this.systemPropertyKeys) {
            if ("jetty.home".equals(key) || "jetty.base".equals(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isDownload() {
        return this.download;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isExec() {
        return this.exec;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isListClasspath() {
        return this.listClasspath;
    }

    public boolean isListConfig() {
        return this.listConfig;
    }

    public boolean isListModules() {
        return this.listModules;
    }

    private void setProperty(String key, String value, String source) {
        if (key.equals("jetty.home")) {
            this.properties.setProperty("jetty.home", System.getProperty("jetty.home"), source);
            return;
        }
        if (key.equals("jetty.base")) {
            this.properties.setProperty("jetty.base", System.getProperty("jetty.base"), source);
            return;
        }
        this.properties.setProperty(key, value, source);
    }

    public void setRun(boolean run) {
        this.run = run;
    }

    public boolean isRun() {
        return this.run;
    }

    public boolean isStopCommand() {
        return this.stopCommand;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void parse(BaseHome baseHome, TextFile file) {
        String source;
        try {
            source = baseHome.toShortForm(file.getFile());
        }
        catch (Exception e) {
            throw new UsageException(-6, "Bad file: %s", file);
        }
        for (String line : file) {
            this.parse(line, source);
        }
    }

    public void parse(String rawarg, String source) {
        if (rawarg == null) {
            return;
        }
        String arg = rawarg.trim();
        if (arg.length() <= 0) {
            return;
        }
        if (arg.startsWith("#")) {
            return;
        }
        if ("--help".equals(arg) || "-?".equals(arg)) {
            if (!CMD_LINE_SOURCE.equals(source)) {
                throw new UsageException(-6, "%s not allowed in %s", arg, source);
            }
            this.help = true;
            this.run = false;
            return;
        }
        if ("--debug".equals(arg)) {
            return;
        }
        if ("--stop".equals(arg)) {
            if (!CMD_LINE_SOURCE.equals(source)) {
                throw new UsageException(-6, "%s not allowed in %s", arg, source);
            }
            this.stopCommand = true;
            this.run = false;
            return;
        }
        if (arg.startsWith("--download=")) {
            this.addFile(this.getValue(arg));
            this.run = false;
            this.download = true;
            return;
        }
        if (arg.equals("--create-files")) {
            this.run = false;
            this.download = true;
            return;
        }
        if ("--list-classpath".equals(arg) || "--version".equals(arg) || "-v".equals(arg) || "--info".equals(arg)) {
            this.listClasspath = true;
            this.run = false;
            return;
        }
        if ("--list-config".equals(arg)) {
            this.listConfig = true;
            this.run = false;
            return;
        }
        if ("--dry-run".equals(arg) || "--exec-print".equals(arg)) {
            if (!CMD_LINE_SOURCE.equals(source)) {
                throw new UsageException(-6, "%s not allowed in %s", arg, source);
            }
            this.dryRun = true;
            this.run = false;
            return;
        }
        if ("--exec".equals(arg)) {
            this.exec = true;
            return;
        }
        if (arg.startsWith("--lib=")) {
            String cp = this.getValue(arg);
            this.classpath.addClasspath(cp);
            return;
        }
        if ("--list-modules".equals(arg)) {
            this.listModules = true;
            this.run = false;
            return;
        }
        if (arg.startsWith("--add-to-startd")) {
            if (!CMD_LINE_SOURCE.equals(source)) {
                throw new UsageException(-6, "%s not allowed in %s", arg, source);
            }
            this.moduleStartdIni.addAll(this.getValues(arg));
            this.run = false;
            return;
        }
        if (arg.startsWith("--add-to-start")) {
            if (!CMD_LINE_SOURCE.equals(source)) {
                throw new UsageException(-6, "%s not allowed in %s", arg, source);
            }
            this.moduleStartIni.addAll(this.getValues(arg));
            this.run = false;
            return;
        }
        if (arg.startsWith("--module=")) {
            for (String moduleName : this.getValues(arg)) {
                this.modules.add(moduleName);
                List<String> list = this.sources.get(moduleName);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.sources.put(moduleName, list);
                }
                list.add(source);
            }
            return;
        }
        if (arg.startsWith("--write-module-graph=")) {
            this.moduleGraphFilename = this.getValue(arg);
            this.run = false;
            return;
        }
        if (arg.startsWith("-D")) {
            String[] assign = arg.substring(2).split("=", 2);
            this.systemPropertyKeys.add(assign[0]);
            switch (assign.length) {
                case 2: {
                    System.setProperty(assign[0], assign[1]);
                    this.setProperty(assign[0], assign[1], source);
                    break;
                }
                case 1: {
                    System.setProperty(assign[0], "");
                    this.setProperty(assign[0], "", source);
                    break;
                }
            }
            return;
        }
        if (arg.startsWith("-")) {
            if (!this.jvmArgs.contains(arg)) {
                this.jvmArgs.add(arg);
            }
            return;
        }
        int idx = arg.indexOf(61);
        if (idx >= 0) {
            String key = arg.substring(0, idx);
            String value = arg.substring(idx + 1);
            if (source != CMD_LINE_SOURCE) {
                if (this.propertySource.containsKey(key)) {
                    throw new UsageException(-6, "Property %s in %s already set in %s", key, source, this.propertySource.get(key));
                }
                this.propertySource.put(key, source);
            }
            if ("OPTION".equals(key) || "OPTIONS".equals(key)) {
                StringBuilder warn = new StringBuilder();
                warn.append("The behavior of the argument ");
                warn.append(arg).append(" (seen in ").append(source);
                warn.append(") has changed, and is now considered a normal property.  ");
                warn.append(key).append(" no longer controls what libraries are on your classpath,");
                warn.append(" use --module instead. See --help for details.");
                StartLog.warn(warn.toString(), new Object[0]);
            }
            this.setProperty(key, value, source);
            return;
        }
        if (FS.isXml(arg)) {
            if (!this.xmlRefs.contains(arg)) {
                this.xmlRefs.add(arg);
            }
            return;
        }
        throw new UsageException(-6, "Unrecognized argument: \"%s\" in %s", arg, source);
    }

    public StartArgs parseCommandLine() {
        for (String line : this.commandLine) {
            this.parse(line, CMD_LINE_SOURCE);
        }
        return this;
    }

    public void resolveExtraXmls(BaseHome baseHome) throws IOException {
        for (String xmlRef : this.xmlRefs) {
            File xmlfile = baseHome.getFile(xmlRef);
            if (!xmlfile.exists()) {
                xmlfile = baseHome.getFile("etc/" + xmlRef);
            }
            this.addUniqueXmlFile(xmlRef, xmlfile);
        }
    }

    public void setAllModules(Modules allModules) {
        this.allModules = allModules;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StartArgs [commandLine=");
        builder.append(this.commandLine);
        builder.append(", enabledModules=");
        builder.append(this.modules);
        builder.append(", xmlRefs=");
        builder.append(this.xmlRefs);
        builder.append(", properties=");
        builder.append(this.properties);
        builder.append(", jvmArgs=");
        builder.append(this.jvmArgs);
        builder.append("]");
        return builder.toString();
    }

    static {
        Package pkg;
        String ver = System.getProperty("jetty.version", null);
        if (ver == null && (pkg = StartArgs.class.getPackage()) != null && "Eclipse.org - Jetty".equals(pkg.getImplementationVendor()) && pkg.getImplementationVersion() != null) {
            ver = pkg.getImplementationVersion();
        }
        if (ver == null) {
            ver = "TEST";
        }
        VERSION = ver;
        System.setProperty("jetty.version", VERSION);
    }
}

