/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.net.URI;
import org.eclipse.jetty.http.HttpURI;
import org.junit.Assert;
import org.junit.Test;

public class HttpURITest {
    String[][] tests = new String[][]{{"/path/to/context", null, null, "-1", "/path/to/context", null, null, null}, {"http://example.com/path/to/context;param?query=%22value%22#fragment", "http", "example.com", "-1", "/path/to/context", "param", "query=%22value%22", "fragment"}, {"http://[::1]/path/to/context;param?query=%22value%22#fragment", "http", "[::1]", "-1", "/path/to/context", "param", "query=%22value%22", "fragment"}, {"http://example.com:8080/path/to/context;param?query=%22value%22#fragment", "http", "example.com", "8080", "/path/to/context", "param", "query=%22value%22", "fragment"}, {"http://[::1]:8080/path/to/context;param?query=%22value%22#fragment", "http", "[::1]", "8080", "/path/to/context", "param", "query=%22value%22", "fragment"}};
    public static int INPUT = 0;
    public static int SCHEME = 1;
    public static int HOST = 2;
    public static int PORT = 3;
    public static int PATH = 4;
    public static int PARAM = 5;
    public static int QUERY = 6;
    public static int FRAGMENT = 7;

    @Test
    public void testFromString() throws Exception {
        for (String[] test : this.tests) {
            HttpURI uri = new HttpURI(test[INPUT]);
            Assert.assertEquals((Object)test[SCHEME], (Object)uri.getScheme());
            Assert.assertEquals((Object)test[HOST], (Object)uri.getHost());
            Assert.assertEquals((long)Integer.parseInt(test[PORT]), (long)uri.getPort());
            Assert.assertEquals((Object)test[PATH], (Object)uri.getPath());
            Assert.assertEquals((Object)test[PARAM], (Object)uri.getParam());
            Assert.assertEquals((Object)test[QUERY], (Object)uri.getQuery());
            Assert.assertEquals((Object)test[FRAGMENT], (Object)uri.getFragment());
        }
    }

    @Test
    public void testFromURI() throws Exception {
        for (String[] test : this.tests) {
            HttpURI uri = new HttpURI(new URI(test[INPUT]));
            Assert.assertEquals((Object)test[SCHEME], (Object)uri.getScheme());
            Assert.assertEquals((Object)test[HOST], (Object)uri.getHost());
            Assert.assertEquals((long)Integer.parseInt(test[PORT]), (long)uri.getPort());
            Assert.assertEquals((Object)test[PATH], (Object)uri.getPath());
            Assert.assertEquals((Object)test[PARAM], (Object)uri.getParam());
            Assert.assertEquals((Object)test[QUERY], (Object)uri.getQuery());
            Assert.assertEquals((Object)test[FRAGMENT], (Object)uri.getFragment());
        }
    }
}

