/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ChunkAccumulator;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.content.BufferedContentSink;
import org.eclipse.jetty.io.content.ByteBufferContentSource;
import org.eclipse.jetty.io.content.ContentSinkOutputStream;
import org.eclipse.jetty.io.content.ContentSinkSubscriber;
import org.eclipse.jetty.io.content.ContentSourceInputStream;
import org.eclipse.jetty.io.content.ContentSourcePublisher;
import org.eclipse.jetty.io.content.InputStreamContentSource;
import org.eclipse.jetty.io.internal.ByteBufferChunk;
import org.eclipse.jetty.io.internal.ByteChannelContentSource;
import org.eclipse.jetty.io.internal.ContentCopier;
import org.eclipse.jetty.io.internal.ContentSourceByteBuffer;
import org.eclipse.jetty.io.internal.ContentSourceConsumer;
import org.eclipse.jetty.io.internal.ContentSourceString;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Content {
    private static final Logger LOG = LoggerFactory.getLogger(Content.class);

    private Content() {
    }

    public static void copy(Source source, Sink sink, Callback callback) {
        Content.copy(source, sink, null, callback);
    }

    public static void copy(Source source, Sink sink, Chunk.Processor chunkProcessor, Callback callback) {
        new ContentCopier(source, sink, chunkProcessor, callback).iterate();
    }

    public static interface Source {
        public static Source from(ByteBuffer ... byteBuffers) {
            return new ByteBufferContentSource(byteBuffers);
        }

        public static Source from(Path path) {
            return Source.from(null, path, 0L, -1L);
        }

        public static Source from(Path path, long offset, long length) {
            return Source.from(null, path, offset, length);
        }

        public static Source from(ByteBufferPool.Sized byteBufferPool, Path path) {
            return Source.from(byteBufferPool, path, 0L, -1L);
        }

        public static Source from(ByteBufferPool.Sized byteBufferPool, Path path, long offset, long length) {
            return new ByteChannelContentSource.PathContentSource(byteBufferPool, path, offset, length);
        }

        public static Source from(ByteBufferPool.Sized byteBufferPool, ByteChannel byteChannel) {
            return new ByteChannelContentSource(byteBufferPool, byteChannel);
        }

        public static Source from(ByteBufferPool.Sized byteBufferPool, SeekableByteChannel seekableByteChannel, long offset, long length) {
            return new ByteChannelContentSource(byteBufferPool, seekableByteChannel, offset, length);
        }

        public static Source from(InputStream inputStream) {
            return Source.from(null, inputStream);
        }

        public static Source from(ByteBufferPool.Sized byteBufferPool, InputStream inputStream) {
            return new InputStreamContentSource(inputStream, byteBufferPool);
        }

        public static Source from(ByteBufferPool.Sized byteBufferPool, InputStream inputStream, final long offset, final long length) {
            return new InputStreamContentSource(inputStream, byteBufferPool){
                private long skip;
                private long toRead;
                {
                    super(inputStream, bufferPool);
                    this.skip = offset;
                    this.toRead = length;
                }

                @Override
                protected int fillBufferFromInputStream(InputStream inputStream, byte[] buffer) throws IOException {
                    if (this.skip > 0L) {
                        inputStream.skipNBytes(this.skip);
                        this.skip = 0L;
                    }
                    if (this.toRead == 0L) {
                        return -1;
                    }
                    if (this.toRead < 0L) {
                        return inputStream.read(buffer, 0, buffer.length);
                    }
                    int toReadInt = (int)Math.min(Integer.MAX_VALUE, this.toRead);
                    int len = Math.min(toReadInt, buffer.length);
                    int read = inputStream.read(buffer, 0, len);
                    if (read > 0) {
                        this.toRead -= (long)read;
                    }
                    return read;
                }
            };
        }

        public static void asByteBuffer(Source source, Promise<ByteBuffer> promise) {
            new ContentSourceByteBuffer(source, promise).run();
        }

        public static ByteBuffer asByteBuffer(Source source) throws IOException {
            ByteBuffer byteBuffer;
            block8: {
                Blocker.Promise promise = Blocker.promise();
                try {
                    Source.asByteBuffer(source, (Promise<ByteBuffer>)promise);
                    byteBuffer = (ByteBuffer)promise.block();
                    if (promise == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (promise != null) {
                            try {
                                promise.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable x) {
                        throw IO.rethrow((Throwable)x);
                    }
                }
                promise.close();
            }
            return byteBuffer;
        }

        @Deprecated(forRemoval=true, since="12.0.15")
        public static CompletableFuture<byte[]> asByteArrayAsync(Source source, int maxSize) {
            return new ChunkAccumulator().readAll(source, maxSize);
        }

        @Deprecated(forRemoval=true, since="12.0.15")
        public static CompletableFuture<ByteBuffer> asByteBufferAsync(Source source) {
            return Source.asByteBufferAsync(source, -1);
        }

        @Deprecated(forRemoval=true, since="12.0.15")
        public static CompletableFuture<ByteBuffer> asByteBufferAsync(Source source, int maxSize) {
            return Source.asByteArrayAsync(source, maxSize).thenApply(ByteBuffer::wrap);
        }

        @Deprecated(forRemoval=true, since="12.0.15")
        public static CompletableFuture<RetainableByteBuffer> asRetainableByteBuffer(Source source, ByteBufferPool pool, boolean direct, int maxSize) {
            return new ChunkAccumulator().readAll(source, pool, direct, maxSize);
        }

        public static void asString(Source source, Charset charset, Promise<String> promise) {
            new ContentSourceString(source, charset, promise).convert();
        }

        public static String asString(Source source) throws IOException {
            return Source.asString(source, StandardCharsets.UTF_8);
        }

        public static String asString(Source source, Charset charset) throws IOException {
            String string;
            block8: {
                Blocker.Promise promise = Blocker.promise();
                try {
                    Source.asString(source, charset, (Promise<String>)promise);
                    string = (String)promise.block();
                    if (promise == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (promise != null) {
                            try {
                                promise.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable x) {
                        throw IO.rethrow((Throwable)x);
                    }
                }
                promise.close();
            }
            return string;
        }

        @Deprecated(forRemoval=true, since="12.0.15")
        public static CompletableFuture<String> asStringAsync(Source source, Charset charset) {
            Promise.Completable completable = new Promise.Completable();
            Source.asString(source, charset, (Promise<String>)completable);
            return completable;
        }

        public static InputStream asInputStream(Source source) {
            return new ContentSourceInputStream(source);
        }

        public static Flow.Publisher<Chunk> asPublisher(Source source) {
            return new ContentSourcePublisher(source);
        }

        public static void consumeAll(Source source, Callback callback) {
            new ContentSourceConsumer(source, callback).run();
        }

        public static void consumeAll(Source source) throws IOException {
            try (Blocker.Callback callback = Blocker.callback();){
                Source.consumeAll(source, (Callback)callback);
                callback.block();
            }
            catch (Throwable x) {
                throw IO.rethrow((Throwable)x);
            }
        }

        default public long getLength() {
            return -1L;
        }

        public Chunk read();

        public void demand(Runnable var1);

        public void fail(Throwable var1);

        default public void fail(Throwable failure, boolean last) {
            this.fail(failure);
        }

        default public boolean rewind() {
            return false;
        }

        public static interface Factory {
            public Source newContentSource(ByteBufferPool.Sized var1, long var2, long var4);
        }
    }

    public static interface Sink {
        public static Sink asBuffered(Sink sink, ByteBufferPool bufferPool, boolean direct, int maxAggregationSize, int maxBufferSize) {
            return new BufferedContentSink(sink, bufferPool, direct, maxAggregationSize, maxBufferSize);
        }

        public static OutputStream asOutputStream(Sink sink) {
            return new ContentSinkOutputStream(sink);
        }

        public static Flow.Subscriber<Chunk> asSubscriber(Sink sink, Callback callback) {
            return new ContentSinkSubscriber(sink, callback);
        }

        public static void write(Sink sink, boolean last, ByteBuffer byteBuffer) throws IOException {
            try (Blocker.Callback callback = Blocker.callback();){
                sink.write(last, byteBuffer, (Callback)callback);
                callback.block();
            }
        }

        public static void write(Sink sink, boolean last, String utf8Content, Callback callback) {
            sink.write(last, ByteBuffer.wrap(utf8Content.getBytes(StandardCharsets.UTF_8)), callback);
        }

        public void write(boolean var1, ByteBuffer var2, Callback var3);
    }

    public static interface Chunk
    extends Retainable {
        public static final Chunk EMPTY = new Chunk(){

            @Override
            public ByteBuffer getByteBuffer() {
                return BufferUtil.EMPTY_BUFFER;
            }

            @Override
            public boolean isLast() {
                return false;
            }

            public String toString() {
                return "EMPTY";
            }
        };
        public static final Chunk EOF = new Chunk(){

            @Override
            public ByteBuffer getByteBuffer() {
                return BufferUtil.EMPTY_BUFFER;
            }

            @Override
            public boolean isLast() {
                return true;
            }

            public String toString() {
                return "EOF";
            }
        };

        public static Chunk from(ByteBuffer byteBuffer, boolean last) {
            if (byteBuffer.hasRemaining()) {
                return new ByteBufferChunk.WithReferenceCount(byteBuffer, last);
            }
            return last ? EOF : EMPTY;
        }

        public static Chunk from(ByteBuffer byteBuffer, boolean last, Runnable releaser) {
            if (byteBuffer.hasRemaining()) {
                return new ByteBufferChunk.ReleasedByRunnable(byteBuffer, last, Objects.requireNonNull(releaser));
            }
            releaser.run();
            return last ? EOF : EMPTY;
        }

        public static Chunk from(ByteBuffer byteBuffer, boolean last, Consumer<ByteBuffer> releaser) {
            if (byteBuffer.hasRemaining()) {
                return new ByteBufferChunk.ReleasedByConsumer(byteBuffer, last, Objects.requireNonNull(releaser));
            }
            releaser.accept(byteBuffer);
            return last ? EOF : EMPTY;
        }

        public static Chunk asChunk(ByteBuffer byteBuffer, boolean last, Retainable retainable) {
            if (byteBuffer.hasRemaining()) {
                if (retainable.canRetain()) {
                    return new ByteBufferChunk.WithRetainable(byteBuffer, last, Objects.requireNonNull(retainable));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Copying buffer because could not retain");
                }
                return new ByteBufferChunk.WithReferenceCount(BufferUtil.copy((ByteBuffer)byteBuffer), last);
            }
            retainable.release();
            return last ? EOF : EMPTY;
        }

        public static Chunk from(Throwable failure) {
            return Chunk.from(failure, true);
        }

        public static Chunk from(final Throwable failure, final boolean last) {
            return new Chunk(){

                @Override
                public Throwable getFailure() {
                    return failure;
                }

                @Override
                public ByteBuffer getByteBuffer() {
                    return BufferUtil.EMPTY_BUFFER;
                }

                @Override
                public boolean isLast() {
                    return last;
                }

                public String toString() {
                    return String.format("Chunk@%x{c=%s,l=%b}", this.hashCode(), failure, last);
                }
            };
        }

        public static Chunk next(final Chunk chunk) {
            if (chunk == null) {
                return null;
            }
            if (Chunk.isFailure(chunk)) {
                if (!chunk.isLast()) {
                    return null;
                }
                return new Chunk(){
                    private Throwable failure;

                    @Override
                    public ByteBuffer getByteBuffer() {
                        return BufferUtil.EMPTY_BUFFER;
                    }

                    @Override
                    public Throwable getFailure() {
                        if (this.failure == null) {
                            this.failure = new IOException(chunk.getFailure());
                        }
                        return this.failure;
                    }

                    @Override
                    public boolean isLast() {
                        return true;
                    }

                    public String toString() {
                        return String.format("%s@%x{failure=%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), chunk.getFailure());
                    }
                };
            }
            if (chunk.isLast()) {
                return EOF;
            }
            return null;
        }

        public static boolean isFailure(Chunk chunk) {
            return chunk != null && chunk.getFailure() != null;
        }

        public static boolean isFailure(Chunk chunk, boolean last) {
            return chunk != null && chunk.getFailure() != null && chunk.isLast() == last;
        }

        public ByteBuffer getByteBuffer();

        default public Throwable getFailure() {
            return null;
        }

        public boolean isLast();

        default public int remaining() {
            return this.getByteBuffer().remaining();
        }

        default public boolean hasRemaining() {
            return this.getByteBuffer().hasRemaining();
        }

        default public int get(byte[] bytes, int offset, int length) {
            ByteBuffer b = this.getByteBuffer();
            if (b == null || !b.hasRemaining()) {
                return 0;
            }
            length = Math.min(length, b.remaining());
            b.get(bytes, offset, length);
            return length;
        }

        default public int skip(int length) {
            if (length == 0) {
                return 0;
            }
            ByteBuffer byteBuffer = this.getByteBuffer();
            length = Math.min(byteBuffer.remaining(), length);
            byteBuffer.position(byteBuffer.position() + length);
            return length;
        }

        default public Chunk asReadOnly() {
            if (!this.getByteBuffer().hasRemaining() || this.getByteBuffer().isReadOnly()) {
                return this;
            }
            if (this.canRetain()) {
                return Chunk.asChunk(this.getByteBuffer().asReadOnlyBuffer(), this.isLast(), this);
            }
            return Chunk.from(this.getByteBuffer().asReadOnlyBuffer(), this.isLast());
        }

        public static interface Processor {
            public boolean process(Chunk var1, Callback var2);
        }
    }
}

