/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.LeakDetector;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class LeakTrackingByteBufferPool
extends ContainerLifeCycle
implements ByteBufferPool {
    private static final Logger LOG = Log.getLogger(LeakTrackingByteBufferPool.class);
    private final LeakDetector<ByteBuffer> leakDetector = new LeakDetector<ByteBuffer>(){

        protected void leaked(LeakDetector.LeakInfo leakInfo) {
            LeakTrackingByteBufferPool.this.leaked(leakInfo);
        }
    };
    private final ByteBufferPool delegate;

    public LeakTrackingByteBufferPool(ByteBufferPool delegate) {
        this.delegate = delegate;
        this.addBean(this.leakDetector);
        this.addBean(delegate);
    }

    @Override
    public ByteBuffer acquire(int size, boolean direct) {
        ByteBuffer buffer = this.delegate.acquire(size, direct);
        if (!this.leakDetector.acquired((Object)buffer)) {
            LOG.info("ByteBuffer {}@{} not tracked", new Object[]{buffer, System.identityHashCode(buffer)});
        }
        return buffer;
    }

    @Override
    public void release(ByteBuffer buffer) {
        if (!this.leakDetector.released((Object)buffer)) {
            LOG.info("ByteBuffer {}@{} released but not acquired", new Object[]{buffer, System.identityHashCode(buffer)});
        }
        this.delegate.release(buffer);
    }

    protected void leaked(LeakDetector.LeakInfo leakInfo) {
        LOG.info("ByteBuffer " + leakInfo.getResourceDescription() + " leaked at:", leakInfo.getStackFrames());
    }
}

